/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.coreclasses.rename;

import com.harrand.util.XmlHelper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Rename {
    private int id_;
    private String oldName_;
    private String newName_;
    public static final String RENAME_XML = "Rnm";
    public static final String OLD_NAME_XML = "oNm";
    public static final String NEW_NAME_XML = "nNm";

    public Rename(int id, String oldName, String newName) {
        this.id_ = id;
        this.oldName_ = oldName;
        this.newName_ = newName;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (!(o instanceof Rename)) {
            return false;
        }
        Rename other = (Rename)o;
        return other.getId() == this.getId();
    }

    public int getId() {
        return this.id_;
    }

    public String getOldName() {
        return this.oldName_;
    }

    public String getNewName() {
        return this.newName_;
    }

    public String toString() {
        return this.getOldName() + " => " + this.getNewName() + "(" + this.getId() + ")";
    }

    public Element asXmlElement(Document doc) {
        Element elmRnm = doc.createElement(RENAME_XML);
        XmlHelper.setAttr(elmRnm, "id", this.getId());
        elmRnm.setAttribute(OLD_NAME_XML, this.getOldName());
        elmRnm.setAttribute(NEW_NAME_XML, this.getNewName());
        return elmRnm;
    }

    public static Rename fromXml(Element elmRnm) {
        int id = XmlHelper.getAttrInt(elmRnm, "id");
        String oldName = elmRnm.getAttribute(OLD_NAME_XML);
        String newName = elmRnm.getAttribute(NEW_NAME_XML);
        return new Rename(id, oldName, newName);
    }
}

