/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.coreclasses.print.dev;

import com.harrand.coregui.helper.GuiMessageHelper;
import com.harrand.util.LogUtil;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import javax.print.PrintService;
import javax.print.attribute.Attribute;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintServiceAttributeSet;
import javax.print.attribute.standard.MediaPrintableArea;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.OrientationRequested;

public class PrintDevTesting
implements Printable {
    private static final String PRINT_DLG_TITLE = "Print Diagram";

    @Override
    public int print(Graphics g, PageFormat pf, int page) throws PrinterException {
        if (page < 10) {
            return 0;
        }
        return 1;
    }

    public void PrintDisp() {
        PrinterJob job = PrinterJob.getPrinterJob();
        job.setPrintable(this);
        boolean ok = job.printDialog();
        if (ok) {
            try {
                job.print();
            }
            catch (PrinterException ex) {
                GuiMessageHelper.showInputErrMsg(null, PRINT_DLG_TITLE, ex.getMessage());
            }
        }
    }

    public PrintService[] getServices(boolean listThem) {
        PrinterJob pj = PrinterJob.getPrinterJob();
        pj.setPrintable(this);
        PrintService[] services = PrinterJob.lookupPrintServices();
        for (int i = 0; i < services.length; ++i) {
            PrintService service = services[i];
            if (!listThem) continue;
            LogUtil.logMsg("PrnDiagramPan.srv:  ========  " + service.getName());
            this.queryOrientation(service);
            this.queryMediaPrintableArea(service);
            this.queryPrintableAreaByMedia(service);
            PrintServiceAttributeSet attrs = service.getAttributes();
            Attribute[] attributeArray = attrs.toArray();
        }
        return services;
    }

    private void translateGraphics(Graphics g, PageFormat pf) {
        Graphics2D g2d = (Graphics2D)g;
        g2d.translate(pf.getImageableX(), pf.getImageableY());
    }

    private void showErrMsg() {
        GuiMessageHelper.showWarningMsg(null, PRINT_DLG_TITLE, "Please open and select the diagram you wish you print.");
    }

    private void queryOrientation(PrintService service) {
        Object supportedAttrValues = service.getSupportedAttributeValues(OrientationRequested.class, null, null);
        OrientationRequested[] orientationsRequested = (OrientationRequested[])supportedAttrValues;
        for (int i = 0; i < orientationsRequested.length; ++i) {
            OrientationRequested orientationRequested = orientationsRequested[i];
            LogUtil.logMsg("supports.orientation.toStr: " + orientationRequested.toString());
        }
    }

    private void queryMediaPrintableArea(PrintService service) {
        Object supportedAttrValues = service.getSupportedAttributeValues(MediaPrintableArea.class, null, null);
        if (supportedAttrValues != null) {
            LogUtil.logMsg("MediaPrintableArea.class: " + supportedAttrValues.getClass());
            MediaPrintableArea[] areas = (MediaPrintableArea[])supportedAttrValues;
            int n = 25400;
        } else {
            LogUtil.logMsg("MediaPrintableArea.class: NULL");
        }
    }

    private void queryPrintableAreaByMedia(PrintService service) {
        HashPrintRequestAttributeSet aset = new HashPrintRequestAttributeSet();
        aset.add(MediaSizeName.NA_5X7);
        Object supportedAttrValues = service.getSupportedAttributeValues(MediaPrintableArea.class, null, aset);
        if (supportedAttrValues != null) {
            MediaPrintableArea[] areas = (MediaPrintableArea[])supportedAttrValues;
            MediaPrintableArea area = areas[0];
            int unit = 25400;
            LogUtil.logMsg("MediaPrintableArea.nm: " + area.getName());
            LogUtil.logMsg("MediaPrintableArea(X, Y, width, height): " + area.getX(unit) + ", " + area.getY(unit) + ", " + area.getWidth(unit) + ", " + area.getHeight(unit));
        } else {
            LogUtil.logMsg("MediaPrintableArea: NULL");
        }
    }
}

