/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.coreclasses.print;

import com.harrand.coreclasses.help.StrHelper;
import com.harrand.coreclasses.print.PageMedia;
import com.harrand.util.LogUtil;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.PrinterJob;
import javax.print.PrintService;

public class PrintSettings {
    private int orientationId_;
    private PageMedia pageMedia_;
    private PrintService printService_;

    public PrintSettings(int orientationId, PrintService printService, PageMedia pageMedia) {
        this.orientationId_ = orientationId;
        this.printService_ = printService;
        this.pageMedia_ = pageMedia;
    }

    public void applyToJob(PrinterJob job) {
        PageFormat pageFormat = job.getPageFormat(null);
        pageFormat.setOrientation(this.orientationId_);
        try {
            job.setPrintService(this.printService_);
        }
        catch (Exception e) {
            String serviceNm = StrHelper.getNullSafeString(this.printService_.getName());
            LogUtil.logErr("PrintSettings apply err: " + e.getMessage() + ", using PrintService: " + serviceNm);
        }
    }

    public int getOrientationId() {
        return this.orientationId_;
    }

    public PrintService getPrintService() {
        return this.printService_;
    }

    public PageMedia getPageMedia() {
        return this.pageMedia_;
    }

    public String getPaperToString(Paper paper) {
        String str = "PrintFacade.pageFormat.paper: \nwidth: " + paper.getWidth() + "\n" + "height: " + paper.getHeight() + "\n" + "imageableX: " + paper.getImageableX() + "\n" + "imageableY: " + paper.getImageableY() + "\n" + "imageableW: " + paper.getImageableWidth() + "\n" + "imageableH: " + paper.getImageableHeight();
        return str;
    }
}

