/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.coreclasses.list;

import com.harrand.coreclasses.interfaces.IOrderedMap;
import com.harrand.coreclasses.interfaces.implementation.BasicOrderedMap;
import com.harrand.coreclasses.interfaces.implementation.BasicSortable;
import com.harrand.coreclasses.list.abstraction.IComboArrayCtrl;
import com.harrand.coreclasses.list.abstraction.IComboArrayDisplay;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BasicComboArrayCtrl
implements IComboArrayCtrl {
    private Map preSelectedItems_ = new HashMap();
    public static final String COUNTRY = "Country";
    public static final String STATE = "State";
    public static final String USA = "USA";
    public static final String CANADA = "Canada";
    public static final String BC = "BC";

    public BasicComboArrayCtrl() {
        this.preSelectedItems_.put(COUNTRY, CANADA);
        this.preSelectedItems_.put(STATE, BC);
    }

    @Override
    public List getComboItems(String str, IComboArrayDisplay iComboArrayDisplay) {
        ArrayList<String> items = new ArrayList<String>();
        if (str.equals(COUNTRY)) {
            items.add(CANADA);
            items.add(USA);
        } else if (str.equals(STATE)) {
            String country = (String)iComboArrayDisplay.getSelectedItem(COUNTRY);
            if (country.equals(USA)) {
                items.add("California");
                items.add("New York");
                items.add("Texas");
            } else {
                items.add("Alberta");
                items.add(BC);
                items.add("Ontario");
            }
        }
        return items;
    }

    @Override
    public IOrderedMap getComboNames() {
        BasicOrderedMap map = new BasicOrderedMap();
        map.add(new BasicSortable(COUNTRY, 0));
        map.add(new BasicSortable(STATE, 1));
        return map;
    }

    @Override
    public Map getPreSelectedItems() {
        return this.preSelectedItems_;
    }
}

