/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.coreclasses.interfaces.implementation;

import com.harrand.coreclasses.interfaces.IOrderedMap;
import com.harrand.coreclasses.interfaces.ISortable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;

public final class BasicOrderedMap
implements IOrderedMap {
    private TreeMap map = new TreeMap();

    @Override
    public ISortable get(String key) {
        return (ISortable)this.map.get(key);
    }

    @Override
    public Set keySet() {
        return this.map.keySet();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public void add(ISortable sortable) {
        if (sortable.getSortOrder() < 0) {
            sortable.setSortOrder(this.map.size());
        }
        this.map.put(sortable.getName(), sortable);
    }

    @Override
    public void addAtStart(ISortable sortable) {
        for (ISortable existingSortable : this.values()) {
            int newSortOrder = existingSortable.getSortOrder();
            existingSortable.setSortOrder(newSortOrder + 1);
        }
        sortable.setSortOrder(0);
        this.add(sortable);
    }

    @Override
    public void remove(String key) {
        int removedSortOrder = this.get(key).getSortOrder();
        this.map.remove(key);
        List list = this.values();
        for (int i = removedSortOrder; i < this.size(); ++i) {
            ((ISortable)list.get(i)).setSortOrder(i);
        }
    }

    @Override
    public void updateItem(ISortable oldIdf, ISortable newIdf) {
    }

    @Override
    public List values() {
        ArrayList list = new ArrayList(this.map.values());
        Collections.sort(list);
        return list;
    }
}

