/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.coreclasses.interfaces.implementation;

import com.harrand.coreclasses.dataEntry.DataEntryResult;
import com.harrand.coreclasses.interfaces.Collector;
import com.harrand.coreclasses.interfaces.ITestResult;
import com.harrand.coreclasses.interfaces.Identifiable;
import com.harrand.coreclasses.interfaces.implementation.BasicIdentifiable;
import com.harrand.coreclasses.list.NamedComparator;
import com.harrand.coreclasses.notification.BasicObservable;
import com.harrand.coreclasses.notification.INotifyMgr;
import com.harrand.coreclasses.notification.IObservable;
import com.harrand.coreclasses.notification.IObserver;
import com.harrand.coreclasses.notification.UpdateChain;
import com.harrand.coreclasses.notification.dirty.IDirtyTracker;
import com.harrand.util.LogUtil;
import com.harrand.util.ResMgr;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public final class BasicCollector
implements Collector,
IObservable {
    private String name_;
    private Map outerMap_ = new TreeMap();
    private BasicObservable observable_ = new BasicObservable();
    private IDirtyTracker dirtyTracker_ = null;
    private INotifyMgr notifyMgr_ = null;
    public static final String EXISTS_ALREADY = "exists already";

    public BasicCollector(String name) {
        this.name_ = name;
        Comparator comparator = String.CASE_INSENSITIVE_ORDER;
        this.outerMap_.put(BasicIdentifiable.getClassName(), new TreeMap(comparator));
    }

    public void setDirtyTracker(IDirtyTracker tracker) {
        this.dirtyTracker_ = tracker;
    }

    public void setNotifyMgr(INotifyMgr notifyMgr) {
        this.notifyMgr_ = notifyMgr;
    }

    public void notifyDirty(Object src) {
        if (this.dirtyTracker_ != null) {
            this.dirtyTracker_.notifyDirty(this);
        }
    }

    private void notifyDirty() {
        this.notifyDirty(null);
    }

    public void setOuterMap(TreeMap outerMap) {
        this.outerMap_ = outerMap;
    }

    public Map getInnerMap(String mapName) throws IllegalArgumentException {
        Map map = (Map)this.outerMap_.get(mapName);
        if (map == null) {
            throw new IllegalArgumentException("Could not find mapName: " + mapName + ".\n" + "Valid map names are: " + this.outerMap_.keySet().toString() + ".");
        }
        return (Map)this.outerMap_.get(mapName);
    }

    public void addInnerMap(String mapName) {
        this.outerMap_.put(mapName, new TreeMap(String.CASE_INSENSITIVE_ORDER));
    }

    public static String printOutInnerMap() {
        TreeMap innerMap = new TreeMap();
        String mapName = "33";
        StringBuffer sb = new StringBuffer("***** InnerMap: " + mapName + " *******" + "\n");
        for (String key : innerMap.keySet()) {
            Object obj = innerMap.get(key);
            sb.append(key + "\t\t\t" + obj.toString() + "\n");
        }
        sb.append("***** InnerMap: " + mapName + " - END *******" + "\n");
        System.out.println(sb.toString());
        return sb.toString();
    }

    public static void sortByNames(List iNameds) {
        Collections.sort(iNameds, new NamedComparator());
    }

    @Override
    public ITestResult add(Identifiable idf) {
        ITestResult result = this.checkIdfNameValid(idf);
        if (!result.getPassed()) {
            return result;
        }
        result = this.checkDuplicateName(idf.getMapName(), idf.getName());
        if (!result.getPassed()) {
            return result;
        }
        try {
            Map innerMap = this.getInnerMap(idf.getMapName());
            innerMap.put(idf.getName(), idf);
            this.notifyDirty();
            this.notifyIdfChanged(idf);
        }
        catch (Exception e) {
            String msg = "BasicCollector.add() idfName: " + idf.getName() + ", err:" + e.getMessage();
            result = new DataEntryResult(false, msg);
        }
        return result;
    }

    @Override
    public Identifiable get(String mapName, String identifiableName) {
        if (this.getInnerMap(mapName).containsKey(identifiableName)) {
            return (Identifiable)this.getInnerMap(mapName).get(identifiableName);
        }
        String msg = ResMgr.getRes("err.msg.identifiable.not.found") + " (BasicCollector)\n" + "Identifiable: " + identifiableName + "\n" + "MapName:      " + mapName + "\n" + "Collector:     " + this.getName();
        LogUtil.logErr(msg);
        return null;
    }

    @Override
    public boolean contains(String mapName, String identifiableName) {
        boolean contains = false;
        try {
            contains = this.getInnerMap(mapName).containsKey(identifiableName);
        }
        catch (Exception e) {
            LogUtil.logMsg("BasicColl.innerMap: " + mapName + " not found.");
        }
        return contains;
    }

    @Override
    public String getMapName() {
        return "BasicCollector";
    }

    @Override
    public String getDisplayName(String mapName) {
        return mapName;
    }

    @Override
    public String getDisplayPlural(String mapName) {
        return mapName + "s";
    }

    @Override
    public Set getKeys(String mapName) {
        return this.getInnerMap(mapName).keySet();
    }

    @Override
    public String getName() {
        return this.name_;
    }

    @Override
    public void remove(String mapName, String identifiableName) {
        Map innerMap = this.getInnerMap(mapName);
        innerMap.remove(identifiableName);
        this.notifyDirty();
        this.notifyIdfChanged(null);
    }

    @Override
    public void rename(Identifiable idf, String oldName, String newName) {
        Map innerMap = this.getInnerMap(idf.getMapName());
        innerMap.remove(oldName);
        idf.setName(newName);
        innerMap.put(idf.getName(), idf);
        this.notifyDirty();
        this.notifyIdfChanged(idf);
    }

    @Override
    public void setName(String newName) {
        this.name_ = newName;
        this.notifyObservers(null);
    }

    @Override
    public int size(String mapName) {
        return this.getInnerMap(mapName).size();
    }

    @Override
    public ITestResult updateItem(Identifiable oldIdf, Identifiable newIdf) {
        DataEntryResult result = new DataEntryResult(true);
        if (!newIdf.equals(oldIdf)) {
            Map innerMap = this.getInnerMap(oldIdf.getMapName());
            innerMap.put(newIdf.getName(), newIdf);
            if (!oldIdf.getName().equalsIgnoreCase(newIdf.getName())) {
                innerMap.remove(oldIdf.getName());
            }
            this.notifyDirty();
        }
        this.notifyIdfChanged(newIdf);
        return result;
    }

    @Override
    public List values(String mapName) {
        return new ArrayList(this.getInnerMap(mapName).values());
    }

    @Override
    public ITestResult checkDuplicateName(String mapNm, String newNm) {
        Map innerMap = this.getInnerMap(mapNm);
        return this.checkDuplicateNameDisp(innerMap, mapNm, newNm);
    }

    public ITestResult checkIdfNameValid(Identifiable idf) {
        DataEntryResult result = new DataEntryResult(true);
        String idfName = idf.getName();
        if (idfName.length() == 0) {
            String mapDisplay = this.getDisplayName(idf.getMapName());
            String msg = "A " + mapDisplay + " name must be specified.";
            result = new DataEntryResult(false, "Invalid Name", msg);
        }
        return result;
    }

    public ITestResult checkDuplicateNameDisp(Map innerMap, String mapNm, String newNm) {
        DataEntryResult result = new DataEntryResult(true);
        if (innerMap.containsKey(newNm)) {
            String mapDisplay = this.getDisplayName(mapNm).toLowerCase();
            String msg = "A " + mapDisplay + " named '" + newNm + "' " + EXISTS_ALREADY + ".";
            result = new DataEntryResult(false, ResMgr.getRes("duplicate.name.title"), msg);
        }
        return result;
    }

    public static ITestResult checkNotDuplicateAdd(Collector coll, Identifiable idfOld, Identifiable idfNew) {
        ITestResult result = new DataEntryResult(true);
        if (idfOld == null) {
            result = coll.checkDuplicateName(idfNew.getMapName(), idfNew.getName());
        }
        return result;
    }

    public static ITestResult checkNotDuplicateUpdate(Collector coll, Identifiable idfOld, Identifiable idfNew) {
        String newNm;
        ITestResult result = new DataEntryResult(true);
        String oldNm = idfOld != null ? idfOld.getName() : null;
        String string = newNm = idfNew != null ? idfNew.getName() : null;
        if (oldNm != null && newNm != null && !oldNm.equalsIgnoreCase(newNm)) {
            result = coll.checkDuplicateName(idfNew.getMapName(), newNm);
        }
        return result;
    }

    public static void verifyNoDups(Collector coll, Identifiable idfOld, Identifiable idfNew) throws Exception {
        ITestResult result = BasicCollector.verifyNoDupsNoException(coll, idfOld, idfNew);
        if (!result.getPassed()) {
            throw new IllegalArgumentException(result.getDetail());
        }
    }

    public static ITestResult verifyNoDupsNoException(Collector coll, Identifiable idfOld, Identifiable idfNew) {
        ITestResult result = idfOld == null ? BasicCollector.checkNotDuplicateAdd(coll, idfOld, idfNew) : BasicCollector.checkNotDuplicateUpdate(coll, idfOld, idfNew);
        return result;
    }

    private void notifyIdfChanged(Identifiable idf) {
        if (this.notifyMgr_ != null) {
            this.notifyMgr_.idfChanged(this, idf);
        } else {
            this.notifyObservers(new UpdateChain(idf));
        }
    }

    @Override
    public int getObserverCount() {
        return this.observable_.getObserverCount();
    }

    @Override
    public void removeAllObservers() {
        this.observable_.removeAllObservers();
    }

    @Override
    public void addObserver(IObserver observer) {
        this.observable_.addObserver(observer);
    }

    @Override
    public void notifyObservers(UpdateChain chain) {
        if (chain == null) {
            chain = new UpdateChain();
        }
        chain.add(this);
        this.observable_.notifyObservers(chain);
    }

    @Override
    public void removeObserver(IObserver observer) {
        this.observable_.removeObserver(observer);
    }
}

