/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.coreclasses.eula;

import com.harrand.coreclasses.eula.IEulaTextSvr;
import com.harrand.coreclasses.help.StrHelper;
import com.harrand.util.ResMgr;
import java.util.ArrayList;
import java.util.List;

public final class BasicEulaTextSvr
implements IEulaTextSvr {
    private int softwareId_;
    private List paragraphTitles_;
    private List paragraphTexts_;

    public BasicEulaTextSvr(int softwareId) {
        this.softwareId_ = softwareId;
        this.initInfo();
    }

    private void initInfo() {
        this.paragraphTitles_ = new ArrayList();
        this.paragraphTexts_ = new ArrayList();
        switch (this.softwareId_) {
            case 0: {
                this.initDbWrenchText();
                break;
            }
            default: {
                StrHelper.throwProgExcept("Unrecognized softwareId: " + this.softwareId_);
            }
        }
    }

    private void initDbWrenchText() {
        this.paragraphTitles_.add("Definition");
        this.paragraphTexts_.add(this.getDefinitionText());
        this.paragraphTitles_.add("Copying and Distribution");
        this.paragraphTexts_.add("You are granted the right to install and use this software. However, only you are authorized to use the software.  If other users wish to use this software they must download and agree to this agreement themselves and purchase any required license(s).");
        this.paragraphTitles_.add("Copyright Protection");
        this.paragraphTexts_.add("All portions of this software are protected by copyright. This includes, but is not limited to, any graphics, help files and configuration files. This software and portions of it may not be used in other software without prior written approval of the vendor.");
        this.paragraphTitles_.add("Indemnity");
        this.paragraphTexts_.add("You agree to indemnify the vendor, its employees, agents, owners, officers, directors against any and all claims, damages, losses, expenses, liabilities, including reasonable attorneys' fees incurred from using, downloading, or installing this software. You also agree that the vendor is not responsible for any of the consequences incurred by the download of malicious software, such as, but not limited to, viruses, trogan horses and worms.");
        this.paragraphTitles_.add("Warranty and Liability");
        this.paragraphTexts_.add("This software is provided 'as is' and 'with all faults' without any claims to reliability, accuracy, level of quality, and usabilty. It is provided without any warranty, expressed or implicit. It is the user's responsibility to ensure all data and schema from their databases is backed up appropriately during use of this software. You assume all risk and responsibility for loss or corruption of data, schema, hardware failure, other application corruption, operating system failure and system configuration incurred during use of this software.  The vendor is not responsible for any down time or lost production due its use.");
        this.paragraphTitles_.add("SSL Connections");
        this.paragraphTexts_.add("DbWrench provides the option to request a SSL connection. It is the responsibility of the user to ensure that their SSL setup is secure and that communication between their server and DbWrench is in SSL.");
        this.paragraphTitles_.add("Commercial Software");
        this.paragraphTexts_.add("This software is commercial software and is not freeware. It can be used free of charge during a 7 day trial period. Use of this software beyond the 7 day free trial requires the purchase of user license(s).");
    }

    private String getDefinitionText() {
        String defText = "This end user license agreement is between you, your company, its affilliates, its agents (collectively 'you') and Nizana Systems ('vendor') regarding the DbWrench software and accompanying documentation ('software'). By downloading, installing, using, or copying this software you agree to the terms of this agreement.  If you do not agree you are not authorized to download, install or use the software.";
        defText.replaceAll("softwareName", this.getSoftwareName());
        return defText;
    }

    private String getSoftwareName() {
        String softwareName = "???";
        switch (this.softwareId_) {
            case 0: {
                softwareName = ResMgr.getRes("dbwrench.name");
                break;
            }
            default: {
                StrHelper.throwProgExcept("Unrecognized softwareId: " + this.softwareId_);
            }
        }
        return softwareName;
    }

    @Override
    public String getEulaHtml() {
        StringBuffer sb = new StringBuffer("");
        int count = 0;
        for (String paragraphText : this.paragraphTexts_) {
            String paragraphTitle = (String)this.paragraphTitles_.get(count);
            sb.append("<p class=\"eula\">" + ++count + ".&nbsp; <b>" + paragraphTitle + ":</b></br>\n");
            sb.append(StrHelper.processHtml(paragraphText));
            sb.append("</p>\n\n");
        }
        return sb.toString();
    }

    @Override
    public String getEulaTitle() {
        String title = ResMgr.getRes("eula.label") + " " + ResMgr.getRes("for.label") + " " + this.getSoftwareName();
        return title;
    }
}

