/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.coreclasses.element;

import com.harrand.coreclasses.element.IId;
import com.harrand.coreclasses.help.StrHelper;
import com.harrand.coreclasses.xml.abstractions.IXmlable;
import com.harrand.util.XmlHelper;
import java.util.Date;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Version
implements IId,
IXmlable,
Comparable {
    private int id_;
    private Integer build_;
    private Integer level1_;
    private Integer level2_;
    private Integer level3_;
    private Integer level4_;
    private Date releaseDate_;
    public static final String ID_HD = "VersionId";
    public static final String LEVEL1_HD = "Level1";
    public static final String LEVEL2_HD = "Level2";
    public static final String LEVEL3_HD = "Level3";
    public static final String LEVEL4_HD = "Level4";
    public static final String BUILD_HD = "Build";
    public static final String REL_DATE_HD = "ReleaseDate";

    public Version(int id, Integer level1, Integer level2, Integer level3, Integer level4, Integer build, Date releaseDate) {
        this.setValues(id, level1, level2, level3, level4, build, releaseDate);
    }

    public Version(String dotNotation) {
        String[] strs = dotNotation.trim().split("\\.");
        Integer[] intObjs = new Integer[]{new Integer(0), new Integer(0), new Integer(0), new Integer(0)};
        for (int i = 0; i < strs.length; ++i) {
            String str = strs[i];
            if (!StrHelper.isInteger(str)) continue;
            intObjs[i] = new Integer(str);
        }
        this.setValues(0, intObjs[0], intObjs[1], intObjs[2], intObjs[3], null, null);
    }

    public Version(List levels) {
        Integer level1 = this.getIntAtLevel(levels, 1);
        Integer level2 = this.getIntAtLevel(levels, 2);
        Integer level3 = this.getIntAtLevel(levels, 3);
        Integer level4 = this.getIntAtLevel(levels, 4);
        this.setValues(0, level1, level2, level3, level4, null, null);
    }

    private void setValues(int id, Integer level1, Integer level2, Integer level3, Integer level4, Integer build, Date releaseDate) {
        this.id_ = id;
        this.level1_ = this.duplicate(level1);
        this.level2_ = this.duplicate(level2);
        this.level3_ = this.duplicate(level3);
        this.level4_ = this.duplicate(level4);
        this.build_ = this.duplicate(build);
        this.releaseDate_ = this.duplicate(releaseDate);
    }

    private Integer getIntAtLevel(List intObjs, int level) {
        Integer intObj = null;
        int index = level - 1;
        if (intObjs.size() >= level) {
            intObj = (Integer)intObjs.get(index);
        }
        return intObj;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (!(o instanceof Version)) {
            return false;
        }
        Version other = (Version)o;
        return other.getId() == this.getId();
    }

    public int compareTo(Object o) {
        int result = 0;
        try {
            Version other = (Version)o;
            Double otherValue = other.getVersionValue();
            Double thisValue = this.getVersionValue();
            result = thisValue.compareTo(otherValue);
        }
        catch (Exception e) {
            StrHelper.throwProgExcept(e.getMessage());
        }
        return result;
    }

    public Double getVersionValue() {
        double value = (double)(this.getCheckNullInt(this.level1_) * 1000000 + this.getCheckNullInt(this.level2_) * 10000 + this.getCheckNullInt(this.level3_) * 100 + this.getCheckNullInt(this.level4_)) + (double)this.getCheckNullInt(this.build_) * 0.001;
        return new Double(value);
    }

    private Integer duplicate(Integer intObj) {
        Integer retObj = intObj == null ? null : new Integer(intObj);
        return retObj;
    }

    private Date duplicate(Date date) {
        Date retObj = date == null ? null : new Date(date.getTime());
        return retObj;
    }

    private void appendNotNull(Integer intObj, StringBuffer sb) {
        if (intObj != null) {
            sb.append(intObj.toString());
        } else {
            sb.append("0");
        }
    }

    private int getCheckNullInt(Integer nullableInt) {
        if (nullableInt == null) {
            return 0;
        }
        return nullableInt;
    }

    private String getNullIntStr(Integer nullableInt) {
        if (nullableInt == null) {
            return "";
        }
        return nullableInt.toString();
    }

    private static Integer getNullableIntAttr(Element element, String attrName) {
        Integer intObj;
        block2: {
            String str = element.getAttribute(attrName);
            intObj = null;
            try {
                intObj = new Integer(str);
            }
            catch (Exception e) {
                if (str.equals("")) break block2;
                System.out.println("Version could not parse as Integer: " + str);
            }
        }
        return intObj;
    }

    private String removeTrailers(String str) {
        String editStr = new String(str);
        boolean loop = true;
        while (loop && editStr.length() >= 2) {
            int length = editStr.length();
            String lastChar = editStr.substring(length - 1);
            String secondLastCh = editStr.substring(length - 2, length - 1);
            if (editStr.length() > 1) {
                if (lastChar.equals("0") && secondLastCh.equals(".")) {
                    editStr = editStr.substring(0, length - 2);
                    continue;
                }
                loop = false;
                continue;
            }
            loop = false;
        }
        return editStr;
    }

    public String toString() {
        return this.getName();
    }

    public static String clazz() {
        return "Version";
    }

    public Integer getLevel1() {
        return this.duplicate(this.level1_);
    }

    public Integer getLevel2() {
        return this.duplicate(this.level2_);
    }

    public Integer getLevel3() {
        return this.duplicate(this.level3_);
    }

    public Integer getLevel4() {
        return this.duplicate(this.level4_);
    }

    public Integer getBuild() {
        return this.duplicate(this.build_);
    }

    public Date getReleaseDate() {
        return this.duplicate(this.releaseDate_);
    }

    @Override
    public String getDisplayName() {
        return this.getName();
    }

    @Override
    public int getId() {
        return this.id_;
    }

    @Override
    public String getName() {
        StringBuffer sb = new StringBuffer();
        this.appendNotNull(this.level1_, sb);
        sb.append(".");
        this.appendNotNull(this.level2_, sb);
        sb.append(".");
        this.appendNotNull(this.level3_, sb);
        sb.append(".");
        this.appendNotNull(this.level4_, sb);
        String levelPart = this.removeTrailers(sb.toString());
        String name = this.build_ != null ? levelPart + " (" + this.build_.toString() + ")" : levelPart;
        return name;
    }

    @Override
    public Element asXmlElement() {
        Document doc = XmlHelper.getNewDocument();
        Element element = doc.createElement(Version.clazz());
        element.setAttribute(ID_HD, Integer.toString(this.id_));
        element.setAttribute(LEVEL1_HD, this.getNullIntStr(this.level1_));
        element.setAttribute(LEVEL2_HD, this.getNullIntStr(this.level2_));
        element.setAttribute(LEVEL3_HD, this.getNullIntStr(this.level3_));
        element.setAttribute(LEVEL4_HD, this.getNullIntStr(this.level4_));
        element.setAttribute(BUILD_HD, this.getNullIntStr(this.build_));
        element.setAttribute(REL_DATE_HD, "");
        return element;
    }

    public static Version fromXml(Element element) {
        Version version = null;
        try {
            int id = Integer.parseInt(element.getAttribute(ID_HD));
            Integer level1 = Version.getNullableIntAttr(element, LEVEL1_HD);
            Integer level2 = Version.getNullableIntAttr(element, LEVEL2_HD);
            Integer level3 = Version.getNullableIntAttr(element, LEVEL3_HD);
            Integer level4 = Version.getNullableIntAttr(element, LEVEL4_HD);
            Integer build = Version.getNullableIntAttr(element, BUILD_HD);
            version = new Version(id, level1, level2, level3, level4, build, null);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        return version;
    }

    @Override
    public void setName(String newName) {
    }
}

