/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.coreclasses.element;

import com.harrand.coreclasses.element.IUniqueNm;
import com.harrand.coreclasses.help.StrHelper;
import com.harrand.coreclasses.interfaces.Identifiable;
import com.harrand.util.LogUtil;
import java.util.HashMap;

public class IdfIdStore {
    private String storeNm_;
    private int nextId_ = 0;
    private HashMap<Integer, Identifiable> idMap_ = new HashMap();
    private HashMap<String, Integer> objMap_ = new HashMap();

    public IdfIdStore(String storeNm) {
        this.storeNm_ = storeNm;
    }

    public void add(Identifiable idf) {
        Integer intObj = new Integer(this.nextId_);
        ++this.nextId_;
        this.idMap_.put(intObj, idf);
        String nm = this.getUniqueNm(idf);
        this.objMap_.put(nm, intObj);
    }

    public void update(Identifiable oldIdf, Identifiable newIdf) {
        String oldNm = this.getUniqueNm(oldIdf);
        if (this.objMap_.containsKey(oldNm)) {
            Integer idObj = this.objMap_.get(oldNm);
            this.idMap_.put(idObj, newIdf);
            this.objMap_.remove(oldNm);
            String newNm = this.getUniqueNm(newIdf);
            this.objMap_.put(newNm, idObj);
        } else {
            this.logError("update()", oldNm);
        }
    }

    public void remove(Identifiable idf) {
        String nm = this.getUniqueNm(idf);
        if (this.objMap_.containsKey(nm)) {
            Integer idObj = this.objMap_.get(nm);
            this.idMap_.remove(idObj);
            this.objMap_.remove(nm);
        } else {
            this.logError("remove", nm);
        }
    }

    public int getId(Identifiable idf) {
        int id = -1;
        String nm = this.getUniqueNm(idf);
        if (this.objMap_.containsKey(nm)) {
            Integer idObj = this.objMap_.get(nm);
            id = idObj;
        } else {
            this.logError("getId", nm);
        }
        return id;
    }

    public Identifiable getIdf(int id) {
        Identifiable idf = null;
        Integer intObj = new Integer(id);
        if (this.idMap_.containsKey(intObj)) {
            idf = this.idMap_.get(intObj);
        } else {
            this.logError("getIdf", Integer.toString(id));
        }
        return idf;
    }

    public boolean contains(int id) {
        boolean found = false;
        Integer intObj = new Integer(id);
        if (this.idMap_.containsKey(intObj)) {
            found = true;
        }
        return found;
    }

    public String getName() {
        return this.storeNm_;
    }

    private String getUniqueNm(Identifiable idf) {
        String uniqueNm = idf.getName();
        if (idf instanceof IUniqueNm) {
            uniqueNm = ((IUniqueNm)((Object)idf)).getUniqueNm();
        }
        return uniqueNm;
    }

    private void logError(String functionNm, String unfoundNm) {
        LogUtil.logErr("IdfIdStore: " + this.getName() + ", " + functionNm + ", could not find object: " + unfoundNm);
        LogUtil.logErr("  key values: " + StrHelper.getCsvSet(this.objMap_.keySet()));
    }
}

