/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.coreclasses.element;

import com.harrand.coreclasses.element.IIdfPair;
import com.harrand.coreclasses.help.StrHelper;
import com.harrand.coreclasses.interfaces.Identifiable;
import com.harrand.util.LogUtil;

public class BasicIdfPair
implements IIdfPair {
    private Identifiable svrIdf_;
    private Identifiable designIdf_;
    private String nmPrefix_;

    public BasicIdfPair(Identifiable svrIdf, Identifiable designIdf, String nmPrefix) {
        this.svrIdf_ = svrIdf;
        this.designIdf_ = designIdf;
        if (this.svrIdf_ == null && this.designIdf_ == null) {
            LogUtil.logErr("BasicIdfPair.err: Both Idfs are null");
            StrHelper.throwProgExcept("");
        }
        this.nmPrefix_ = nmPrefix;
    }

    @Override
    public Identifiable getDesignIdf() {
        return this.designIdf_;
    }

    @Override
    public Identifiable getSvrIdf() {
        return this.svrIdf_;
    }

    @Override
    public boolean getWasRenamed(boolean caseSens) {
        if (this.svrIdf_ == null || this.designIdf_ == null) {
            return false;
        }
        boolean sameNm = caseSens ? this.svrIdf_.getName().equals(this.designIdf_.getName()) : this.svrIdf_.getName().equalsIgnoreCase(this.designIdf_.getName());
        return !sameNm;
    }

    @Override
    public boolean getHasNull() {
        return this.svrIdf_ == null || this.designIdf_ == null;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.getClz() + "Pair: ");
        sb.append("<");
        if (this.svrIdf_ != null) {
            sb.append(this.svrIdf_.getName());
        } else {
            sb.append(StrHelper.NULL_STR);
        }
        sb.append(">/");
        sb.append("<");
        if (this.designIdf_ != null) {
            sb.append(this.designIdf_.getName());
        } else {
            sb.append(StrHelper.NULL_STR);
        }
        sb.append(">");
        return sb.toString();
    }

    @Override
    public String getClz() {
        return this.getNotNullIdf().getMapName();
    }

    @Override
    public String getDisplayClzNm() {
        return this.getNotNullIdf().getDisplayClzNm();
    }

    @Override
    public String getDisplayClzPlural() {
        return this.getNotNullIdf().getDisplayClzPlural();
    }

    @Override
    public boolean getWasTransferred() {
        return false;
    }

    @Override
    public String getName() {
        if (this.nmPrefix_ != null && this.nmPrefix_.length() > 0) {
            return this.nmPrefix_ + "." + this.getNotNullIdf().getName();
        }
        return this.getNotNullIdf().getName();
    }

    private Identifiable getNotNullIdf() {
        if (this.designIdf_ != null) {
            return this.designIdf_;
        }
        return this.svrIdf_;
    }
}

