/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.coreclasses.display;

import com.harrand.coreclasses.interfaces.INamed;
import com.harrand.util.XmlHelper;
import java.awt.Rectangle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class PanelState
implements INamed {
    private String nm_;
    private Rectangle bounds_;
    private int state_;
    public static final int STATE_REG = 0;
    public static final int STATE_MAX = 1;
    public static final String CLZ_XML = "PanSt";
    public static final String ITEM_XML = "Item";
    public static final String X_XML = "X";
    public static final String Y_XML = "Y";
    public static final String H_XML = "H";
    public static final String W_XML = "W";
    public static final String STATE_XML = "st";

    public PanelState(String nm, Rectangle bounds, int state) {
        this.setName(nm);
        this.setBounds(bounds);
        this.setState(state);
    }

    @Override
    public void setName(String nm) {
        this.nm_ = nm;
    }

    public void setBounds(Rectangle bounds) {
        this.bounds_ = bounds;
    }

    public void setState(int state) {
        this.state_ = state;
    }

    @Override
    public String getName() {
        return this.nm_;
    }

    public Rectangle getBounds() {
        return this.bounds_;
    }

    public int getState() {
        return this.state_;
    }

    public boolean getIsMaximized() {
        return this.getState() == 1;
    }

    public Element asXmlElement(Document doc) {
        Element elm = doc.createElement(CLZ_XML);
        elm.setAttribute("nm", this.nm_);
        XmlHelper.setAttr(elm, X_XML, this.bounds_.x);
        XmlHelper.setAttr(elm, Y_XML, this.bounds_.y);
        XmlHelper.setAttr(elm, W_XML, this.bounds_.width);
        XmlHelper.setAttr(elm, H_XML, this.bounds_.height);
        XmlHelper.setAttr(elm, STATE_XML, this.getState());
        return elm;
    }

    public static PanelState fromXml(Element elm) {
        String nm = elm.getAttribute("nm");
        Rectangle rect = new Rectangle(XmlHelper.getAttrInt(elm, X_XML), XmlHelper.getAttrInt(elm, Y_XML), XmlHelper.getAttrInt(elm, W_XML), XmlHelper.getAttrInt(elm, H_XML));
        int state = XmlHelper.getAttrInt(elm, STATE_XML);
        PanelState panState = new PanelState(nm, rect, state);
        return panState;
    }
}

