/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.coreclasses.db.joint;

import com.harrand.coreclasses.db.joint.EJointType;
import com.harrand.coreclasses.element.Cardinality;
import com.harrand.dbwrench.object.Column;
import com.harrand.dbwrench.object.ForeignKey;
import java.util.List;

public final class CardinalityFactory {
    public static Cardinality createCardinality(ForeignKey fk, EJointType jointType) {
        switch (jointType) {
            case CHILD: {
                return new Cardinality(true, true, true);
            }
            case PARENT: {
                return CardinalityFactory.createParentCardinality(fk);
            }
        }
        return null;
    }

    private static Cardinality createParentCardinality(ForeignKey fk) {
        if (CardinalityFactory.areAnyNullable(fk.getChildColumns())) {
            return new Cardinality(true, true, false);
        }
        return new Cardinality(false, true, false);
    }

    private static boolean areAnyNullable(List<Column> parentColumns) {
        for (Column column : parentColumns) {
            if (!column.getIsNullable()) continue;
            return true;
        }
        return false;
    }
}

