/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.coreclasses.db;

import com.harrand.coreclasses.element.IId;
import com.harrand.coreclasses.element.IdGroup;
import com.harrand.coreclasses.help.StrHelper;
import com.harrand.coreclasses.query.IDataOrder;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

public final class SqlHelper
implements IDataOrder {
    public static final String NULL_STR = "null";

    private SqlHelper() {
    }

    public static String getTimeStampSql(int dbmsId) {
        String sql = "";
        switch (dbmsId) {
            case 3: {
                sql = "GETDATE()";
                break;
            }
            case 0: {
                sql = "NOW()";
                break;
            }
            case 1: {
                sql = "now()";
                break;
            }
            case 4: {
                sql = "SYSDATE";
                break;
            }
            default: {
                StrHelper.throwProgExcept("Unsupported DbmsId: " + dbmsId);
            }
        }
        return sql;
    }

    public static String getUpdateLine(String fieldName, Object newValue) {
        return SqlHelper.getUpdateLine(fieldName, newValue, true, false);
    }

    public static Object[][] getEmptyDataMatrix() {
        return new Object[][]{{" "}};
    }

    public static String getUpdateLine(String fieldName, Object newValue, boolean addComma, boolean isFunction) {
        StringBuffer sb = new StringBuffer("\n\t" + fieldName + " = ");
        if (newValue == null) {
            sb.append(NULL_STR);
        } else if (newValue instanceof String) {
            if (isFunction) {
                sb.append(newValue);
            } else {
                sb.append(StrHelper.encloseDblQuotes(newValue.toString()));
            }
        } else if (newValue instanceof IId) {
            int i = ((IId)newValue).getId();
            sb.append(Integer.toString(i));
        } else if (newValue instanceof Integer) {
            sb.append(newValue.toString());
        } else if (newValue instanceof Double) {
            sb.append(newValue.toString());
        } else if (newValue instanceof Float) {
            sb.append(newValue.toString());
        } else if (newValue instanceof Date) {
            sb.append(newValue.toString());
        } else {
            StrHelper.throwProgExcept("Unsupported newValue object type: " + newValue.getClass().getName());
        }
        if (addComma) {
            sb.append(", ");
        }
        return sb.toString();
    }

    public static String getSelectAllSql(String tableName, int orderByField, int orderByDirection) {
        String orderByStr = SqlHelper.getOrderByFieldSql(tableName, orderByField);
        String directionStr = SqlHelper.getOrderByDirectionSql(orderByDirection);
        String sql = "SELECT * FROM " + tableName + "\nORDER BY " + orderByStr + " " + directionStr;
        return sql;
    }

    public static String getOrderByFieldSql(String tableName, int orderByField) {
        String fieldStr = "";
        switch (orderByField) {
            case 0: {
                fieldStr = tableName + "Id";
                break;
            }
            case 1: {
                fieldStr = tableName + "Name";
                break;
            }
            case 2: {
                fieldStr = "Value";
                break;
            }
            default: {
                StrHelper.throwProgExcept("Unsupported orderByField: " + orderByField);
            }
        }
        return fieldStr;
    }

    public static String getOrderByDirectionSql(int orderByDirection) {
        String directionStr = orderByDirection == 1 ? "DESC" : "";
        return directionStr;
    }

    public static String getInSql(IdGroup idGroup) {
        String inSql = "";
        if (idGroup.getIdCount() > 0) {
            String name = idGroup.getName();
            String abbr = idGroup.getAbbr();
            StringBuffer sb = new StringBuffer(abbr + "." + name + "Id IN (");
            boolean addComma = false;
            Iterator it = idGroup.getIds().iterator();
            while (it.hasNext()) {
                if (addComma) {
                    sb.append(", ");
                } else {
                    addComma = true;
                }
                IId id = (IId)it.next();
                sb.append(id.getId());
            }
            sb.append(")");
            inSql = sb.toString();
        }
        return inSql;
    }

    public static String getWhereSql(List groupIncludes) {
        StringBuffer sb = new StringBuffer("");
        if (groupIncludes.size() > 0) {
            sb.append("WHERE ");
            boolean addAnd = false;
            for (IdGroup groupId : groupIncludes) {
                if (addAnd) {
                    sb.append("\nAND ");
                } else {
                    addAnd = true;
                }
                sb.append(SqlHelper.getInSql(groupId));
            }
        }
        return sb.toString();
    }

    public static String getIdOrNullStr(IId iId) {
        if (iId == null) {
            return NULL_STR;
        }
        return Integer.toString(iId.getId());
    }

    public static String getDoubleOrNullStr(Double dbl) {
        if (dbl == null) {
            return NULL_STR;
        }
        return dbl.toString();
    }
}

