/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.coreclasses.dataEntry;

import com.harrand.coreclasses.interfaces.ITestResult;
import com.harrand.util.FileHelper;
import java.util.List;

public final class DataEntryResult
implements ITestResult {
    private boolean passed_;
    private String summary_;
    private String detail_;

    public DataEntryResult(boolean passed) {
        this(passed, DataEntryResult.getDefaultSummary(passed), DataEntryResult.getDefaultDetail(passed));
    }

    public DataEntryResult() {
        this(true);
    }

    public DataEntryResult(boolean passed, String detail) {
        this(passed, DataEntryResult.getDefaultSummary(passed), detail);
    }

    public DataEntryResult(boolean passed, String summary, String detail) {
        this.passed_ = passed;
        this.summary_ = summary;
        this.detail_ = detail;
    }

    public static String getDefaultSummary(boolean passed) {
        String summary = passed ? FileHelper.getResource("data.entry.valid.title") : FileHelper.getResource("err.data.entry.invalid.title");
        return summary;
    }

    public static String getDefaultDetail(boolean passed) {
        String detail = passed ? FileHelper.getResource("data.entry.valid.msg") : FileHelper.getResource("err.data.entry.invalid.msg");
        return detail;
    }

    @Override
    public String getDetail() {
        return this.detail_;
    }

    @Override
    public boolean getPassed() {
        return this.passed_;
    }

    @Override
    public String getSummary() {
        return this.summary_;
    }

    @Override
    public void setSummary(String summary) {
        this.summary_ = summary;
    }

    @Override
    public void setDetail(String detail) {
        this.detail_ = detail;
    }

    public String toString() {
        return "DataEntryResult: " + this.getPassed() + ", " + this.getSummary() + ", " + this.getDetail();
    }

    public static ITestResult aggregateResults(List<ITestResult> results, String titlePassText, String titleFailText) {
        boolean passed = true;
        StringBuilder sb = new StringBuilder();
        for (ITestResult result : results) {
            if (result.getPassed()) continue;
            passed = false;
            if (sb.length() > 0) {
                sb.append("\n");
            }
            sb.append(result.getDetail());
        }
        String title = passed ? titlePassText : titleFailText;
        String detail = passed ? "Aggregated results passed" : sb.toString();
        DataEntryResult finalResult = new DataEntryResult(passed, title, detail);
        return finalResult;
    }
}

