/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.coreclasses.auth.lic;

import com.harrand.coreclasses.auth.lic.AppInfo;
import com.harrand.coreclasses.auth.lic.License;
import com.harrand.coreclasses.auth.lic.type.ExtendedTrialExpiredLicenseType;
import com.harrand.coreclasses.auth.lic.type.ExtendedTrialLicenseType;
import com.harrand.coreclasses.auth.lic.type.ILicenseType;
import com.harrand.coreclasses.auth.lic.type.PreviousVersionOldLicenseType;
import com.harrand.coreclasses.auth.lic.type.PreviousVersionRecentLicenseType;
import com.harrand.coreclasses.auth.lic.type.StandardLicenceType;
import com.harrand.coreclasses.auth.lic.type.TrialExpiredType;
import com.harrand.coreclasses.auth.lic.type.TrialType;
import com.harrand.coreclasses.auth.lic.type.UpgradedLicenseType;
import com.harrand.coreclasses.dataEntry.DataEntryResult;
import com.harrand.coreclasses.interfaces.ITestResult;
import java.util.GregorianCalendar;

public class LicensePolicy {
    private static final LicensePolicy instance = new LicensePolicy();
    public static final String EXPIRED_TITLE = "Trial License Expired";

    public static LicensePolicy getInstance() {
        return instance;
    }

    public void refreshLicenseType() {
        License license = this.getLicense();
        ILicenseType licenseType = this.calcLicenseTypeId(license);
        license.setLicenseType(licenseType);
    }

    public ITestResult hasOperableLicense() {
        ILicenseType licenseType = this.getLicenseType();
        boolean isOperable = licenseType.isOperableLicense();
        if (isOperable) {
            return new DataEntryResult(isOperable);
        }
        DataEntryResult result = new DataEntryResult(false, EXPIRED_TITLE, this.getLicenseType().getFullDescr(this.getToday()));
        return result;
    }

    boolean getNeedsUpgradeLicense() {
        return this.getLicenseType().getUsesUpgradeLicense();
    }

    public String getWarningMsg() {
        return this.getLicenseType().getWarningMsg(this.getToday());
    }

    private ILicenseType calcLicenseTypeId(License license) {
        boolean hasPreviousVersionLicense;
        boolean hasV1License = license.hasStandardPIN1x();
        boolean hasV2License = license.hasStandardPIN2x();
        boolean bl = hasPreviousVersionLicense = hasV1License || hasV2License;
        if (license.hasStandardPIN3x()) {
            return new StandardLicenceType();
        }
        if (hasPreviousVersionLicense && license.hasUpgradePIN3x()) {
            return new UpgradedLicenseType();
        }
        if (hasPreviousVersionLicense && !license.hasUpgradePIN3x()) {
            return this.selectPreviousLicenseType(license);
        }
        if (license.hasExtendedTrialPIN()) {
            return this.selectExtendedLicenseType();
        }
        if (this.hasDaysRemaining(10)) {
            return new TrialType();
        }
        return new TrialExpiredType();
    }

    private ILicenseType selectPreviousLicenseType(License license) {
        if (license.isThisUpgradeFree()) {
            return new PreviousVersionRecentLicenseType();
        }
        return new PreviousVersionOldLicenseType();
    }

    private ILicenseType selectExtendedLicenseType() {
        if (this.hasDaysRemaining(17)) {
            return new ExtendedTrialLicenseType();
        }
        return new ExtendedTrialExpiredLicenseType();
    }

    private GregorianCalendar getToday() {
        return new GregorianCalendar();
    }

    private int getDaysRemaining(int daysAllowed) {
        int installDays = AppInfo.getInstance().getDaysInstalled();
        int daysRemaining = daysAllowed - installDays;
        return daysRemaining;
    }

    private boolean hasDaysRemaining(int daysAllowed) {
        return this.getDaysRemaining(daysAllowed) > 0;
    }

    private License getLicense() {
        return License.getIntance();
    }

    private ILicenseType getLicenseType() {
        return this.getLicense().getLicenseType();
    }
}

