/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.dataview.table.celleditor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.KeyEvent;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;
import javax.swing.text.JTextComponent;
import org.jdesktop.swingx.JXButton;
import org.jdesktop.swingx.JXPanel;
import org.netbeans.modules.db.dataview.table.ResultSetTableCellEditor;
import org.openide.windows.WindowManager;

public class StringTableCellEditor
extends ResultSetTableCellEditor
implements TableCellEditor,
ActionListener {
    private JXButton customEditorButton = new JXButton("...");
    private int row;
    private int column;

    public StringTableCellEditor(JTextField textField) {
        super(textField);
        this.customEditorButton.addActionListener((ActionListener)this);
        this.customEditorButton.setFocusable(false);
        this.customEditorButton.setFocusPainted(false);
        this.customEditorButton.setMargin(new Insets(0, 0, 0, 0));
        this.customEditorButton.setPreferredSize(new Dimension(20, 10));
    }

    @Override
    public Component getTableCellEditorComponent(final JTable table, Object value, boolean isSelected, final int row, final int column) {
        this.table = table;
        final JComponent c = (JComponent)super.getTableCellEditorComponent(table, value, isSelected, row, column);
        final JTextComponent tc = c instanceof JTextComponent ? (JTextComponent)c : null;
        JXPanel panel = new JXPanel(new BorderLayout()){

            public void addNotify() {
                super.addNotify();
                c.requestFocus();
            }

            protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
                InputMap map = c.getInputMap(condition);
                ActionMap am = c.getActionMap();
                if (tc != null && ks.isOnKeyRelease()) {
                    table.getModel().setValueAt(tc.getText(), table.convertRowIndexToModel(row), table.convertColumnIndexToModel(column));
                }
                if (map != null && am != null && this.isEnabled()) {
                    Action action;
                    Object binding = map.get(ks);
                    Action action2 = action = binding == null ? null : am.get(binding);
                    if (action != null) {
                        return SwingUtilities.notifyAction(action, ks, e, c, e.getModifiers());
                    }
                }
                return false;
            }
        };
        panel.add((Component)c);
        if (suppressEditorBorder) {
            c.setBorder(BorderFactory.createEmptyBorder());
        }
        panel.add((Component)this.customEditorButton, (Object)"East");
        panel.revalidate();
        panel.repaint();
        this.row = row;
        this.column = column;
        return panel;
    }

    @Override
    public final void actionPerformed(ActionEvent e) {
        assert (this.table != null);
        super.cancelCellEditing();
        this.editCell(this.table, this.row, this.column);
    }

    protected void editCell(JTable table, int row, int column) {
        JTextArea textArea = new JTextArea(20, 80);
        textArea.setDropTarget(null);
        TableModel tm = table.getModel();
        int modelRow = table.convertRowIndexToModel(row);
        int modelColumn = table.convertColumnIndexToModel(column);
        boolean editable = tm.isCellEditable(modelRow, modelColumn);
        Object value = tm.getValueAt(modelRow, modelColumn);
        if (value != null) {
            textArea.setText(value.toString());
            textArea.setCaretPosition(0);
            textArea.setEditable(editable);
        }
        JScrollPane pane = new JScrollPane(textArea);
        pane.addHierarchyListener(new MakeResizableListener(pane));
        Frame parent = WindowManager.getDefault().getMainWindow();
        if (editable) {
            int result = JOptionPane.showOptionDialog(parent, pane, table.getColumnName(column), 2, -1, null, null, null);
            if (result == 0) {
                tm.setValueAt(textArea.getText(), modelRow, modelColumn);
            }
        } else {
            JOptionPane.showMessageDialog(parent, pane, table.getColumnName(column), -1, null);
        }
    }

    static class MakeResizableListener
    implements HierarchyListener {
        private Component pane;

        public MakeResizableListener(Component pane) {
            this.pane = pane;
        }

        @Override
        public void hierarchyChanged(HierarchyEvent e) {
            Dialog dialog;
            Window window = SwingUtilities.getWindowAncestor(this.pane);
            if (window instanceof Dialog && !(dialog = (Dialog)window).isResizable()) {
                dialog.setResizable(true);
            }
        }
    }
}

