/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.dataview.output;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.print.PrinterException;
import java.sql.Blob;
import java.sql.Clob;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.RowFilter;
import javax.swing.UIManager;
import javax.swing.border.LineBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.jdesktop.swingx.renderer.JRendererCheckBox;
import org.netbeans.modules.db.dataview.meta.DBColumn;
import org.netbeans.modules.db.dataview.meta.DBException;
import org.netbeans.modules.db.dataview.meta.DBTable;
import org.netbeans.modules.db.dataview.output.DataView;
import org.netbeans.modules.db.dataview.output.DataViewActionHandler;
import org.netbeans.modules.db.dataview.output.DataViewPageContext;
import org.netbeans.modules.db.dataview.output.DataViewTableUIModel;
import org.netbeans.modules.db.dataview.output.DataViewUI;
import org.netbeans.modules.db.dataview.output.SQLStatementGenerator;
import org.netbeans.modules.db.dataview.output.ShowSQLDialog;
import org.netbeans.modules.db.dataview.table.ResultSetCellRenderer;
import org.netbeans.modules.db.dataview.table.ResultSetJXTable;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.datatransfer.ExClipboard;
import org.openide.windows.WindowManager;

final class DataViewTableUI
extends ResultSetJXTable {
    private JPopupMenu tablePopupMenu;
    private final DataViewUI dataviewUI;
    private DataViewActionHandler handler;
    private int selectedRow = -1;
    private int selectedColumn = -1;
    private TableModelListener dataChangedListener = new TableModelListener(){

        @Override
        public void tableChanged(TableModelEvent e) {
            DataViewTableUI.this.dataviewUI.handleColumnUpdated();
        }
    };

    public DataViewTableUI(DataViewUI dataviewUI, DataViewActionHandler handler, DataView dataView, DataViewPageContext pageContext) {
        this.dataviewUI = dataviewUI;
        this.handler = handler;
        TableSelectionListener listener = new TableSelectionListener((JTable)((Object)this));
        this.getSelectionModel().addListSelectionListener(listener);
        this.getColumnModel().getSelectionModel().addListSelectionListener(listener);
        this.addKeyListener(this.createControKeyListener());
        this.createPopupMenu(handler, dataView, pageContext);
    }

    @Override
    public void setModel(TableModel dataModel) {
        if (!(dataModel instanceof DataViewTableUIModel)) {
            throw new IllegalArgumentException("DataViewTableUI only supports instances of DataViewTableUIModel");
        }
        RowFilter oldFilter = this.getRowFilter();
        if (this.getModel() != null) {
            this.getModel().removeTableModelListener(this.dataChangedListener);
        }
        super.setModel(dataModel);
        dataModel.addTableModelListener(this.dataChangedListener);
        this.setRowFilter(oldFilter);
        if (this.dataviewUI != null) {
            this.dataviewUI.handleColumnUpdated();
        }
    }

    @Override
    public DataViewTableUIModel getModel() {
        return (DataViewTableUIModel)super.getModel();
    }

    @Override
    protected TableModel createDefaultDataModel() {
        return new DataViewTableUIModel(new DBColumn[0]);
    }

    public TableCellRenderer getCellRenderer(int row, int column) {
        try {
            if (this.getModel().hasUpdates(this.convertRowIndexToModel(row), this.convertColumnIndexToModel(column))) {
                return new UpdatedResultSetCellRenderer();
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        return super.getCellRenderer(row, column);
    }

    @Override
    protected KeyListener createControKeyListener() {
        return new Control0KeyListener();
    }

    private void setCellToNull(int row, int col) {
        int modelColumn = this.convertColumnIndexToModel(col);
        DBColumn dbcol = this.getModel().getColumn(modelColumn);
        if (dbcol.isGenerated() || !dbcol.isNullable()) {
            Toolkit.getDefaultToolkit().beep();
        } else {
            Class<? extends Object> modelClass = this.getModel().getColumnClass(modelColumn);
            if (Blob.class.isAssignableFrom(modelClass) || Clob.class.isAssignableFrom(modelClass)) {
                this.setValueAt(null, row, col);
            } else {
                this.setValueAt("<NULL>", row, col);
            }
        }
    }

    private void setCellToDefault(int row, int col) {
        int modelColumn = this.convertColumnIndexToModel(col);
        DBColumn dbcol = this.getModel().getColumn(modelColumn);
        Object val = this.getValueAt(row, col);
        if (dbcol.isGenerated() || !dbcol.hasDefault()) {
            Toolkit.getDefaultToolkit().beep();
        } else if (val != null && val instanceof String && ((String)val).equals("<DEFAULT>")) {
            this.setValueAt(null, row, col);
        } else {
            this.setValueAt("<DEFAULT>", row, col);
        }
        this.setRowSelectionInterval(row, row);
    }

    private void createPopupMenu(final DataViewActionHandler handler, final DataView dataView, final DataViewPageContext pageContext) {
        this.tablePopupMenu = new JPopupMenu();
        final JMenuItem miInsertAction = new JMenuItem(NbBundle.getMessage(DataViewTableUI.class, (String)"TOOLTIP_insert"));
        miInsertAction.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                handler.insertActionPerformed();
            }
        });
        this.tablePopupMenu.add(miInsertAction);
        final JMenuItem miDeleteAction = new JMenuItem(NbBundle.getMessage(DataViewTableUI.class, (String)"TOOLTIP_deleterow"));
        miDeleteAction.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                handler.deleteRecordActionPerformed();
            }
        });
        this.tablePopupMenu.add(miDeleteAction);
        final JMenuItem miCommitAction = new JMenuItem(NbBundle.getMessage(DataViewTableUI.class, (String)"TOOLTIP_commit"));
        miCommitAction.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                handler.commitActionPerformed(true);
            }
        });
        this.tablePopupMenu.add(miCommitAction);
        final JMenuItem miCancelEdits = new JMenuItem(NbBundle.getMessage(DataViewTableUI.class, (String)"TOOLTIP_cancel_edits"));
        miCancelEdits.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                handler.cancelEditPerformed(true);
            }
        });
        this.tablePopupMenu.add(miCancelEdits);
        final JMenuItem miTruncateRecord = new JMenuItem(NbBundle.getMessage(DataViewTableUI.class, (String)"TOOLTIP_truncate_table"));
        miTruncateRecord.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                handler.truncateActionPerformed();
            }
        });
        this.tablePopupMenu.add(miTruncateRecord);
        this.tablePopupMenu.addSeparator();
        final JMenuItem miCopyValue = new JMenuItem(NbBundle.getMessage(DataViewTableUI.class, (String)"TOOLTIP_copy_cell_value"));
        miCopyValue.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Object o = DataViewTableUI.this.getValueAt(DataViewTableUI.this.selectedRow, DataViewTableUI.this.selectedColumn);
                    String output = DataViewTableUI.this.convertToClipboardString(o, 0x100000);
                    ExClipboard clipboard = (ExClipboard)Lookup.getDefault().lookup(ExClipboard.class);
                    StringSelection strSel = new StringSelection(output);
                    clipboard.setContents((Transferable)strSel, (ClipboardOwner)strSel);
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    // empty catch block
                }
            }
        });
        this.tablePopupMenu.add(miCopyValue);
        final JMenuItem miCopyRowValues = new JMenuItem(NbBundle.getMessage(DataViewTableUI.class, (String)"TOOLTIP_copy_row_value"));
        miCopyRowValues.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataViewTableUI.this.copyRowValues(false);
            }
        });
        this.tablePopupMenu.add(miCopyRowValues);
        final JMenuItem miCopyRowValuesH = new JMenuItem(NbBundle.getMessage(DataViewTableUI.class, (String)"TOOLTIP_copy_row_header"));
        miCopyRowValuesH.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataViewTableUI.this.copyRowValues(true);
            }
        });
        this.tablePopupMenu.add(miCopyRowValuesH);
        this.tablePopupMenu.addSeparator();
        final JMenuItem miCreateSQLScript = new JMenuItem(NbBundle.getMessage(DataViewTableUI.class, (String)"TOOLTIP_show_create_sql"));
        miCreateSQLScript.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    DBTable table = pageContext.getTableMetaData().getTable(0);
                    String createSQL = dataView.getSQLStatementGenerator().generateCreateStatement(table);
                    ShowSQLDialog dialog = new ShowSQLDialog();
                    dialog.setLocationRelativeTo(WindowManager.getDefault().getMainWindow());
                    dialog.setText(createSQL + ";\n");
                    dialog.setVisible(true);
                }
                catch (Exception ex) {
                    NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)ex.getMessage());
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
                }
            }
        });
        this.tablePopupMenu.add(miCreateSQLScript);
        final JMenuItem miInsertSQLScript = new JMenuItem(NbBundle.getMessage(DataViewTableUI.class, (String)"TOOLTIP_show_insert_sql"));
        miInsertSQLScript.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    int[] rows = DataViewTableUI.this.getSelectedRows();
                    String insertSQL = "";
                    for (int j = 0; j < rows.length; ++j) {
                        int modelIndex = DataViewTableUI.this.convertRowIndexToModel(rows[j]);
                        Object[] insertRow = DataViewTableUI.this.getModel().getRowData(modelIndex);
                        DBTable table = pageContext.getTableMetaData().getTable(0);
                        String sql = dataView.getSQLStatementGenerator().generateRawInsertStatement(table, insertRow);
                        insertSQL = insertSQL + sql + ";\n";
                    }
                    ShowSQLDialog dialog = new ShowSQLDialog();
                    dialog.setLocationRelativeTo(WindowManager.getDefault().getMainWindow());
                    dialog.setText(insertSQL);
                    dialog.setVisible(true);
                }
                catch (DBException ex) {
                    NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)ex.getMessage());
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
                }
            }
        });
        this.tablePopupMenu.add(miInsertSQLScript);
        final JMenuItem miDeleteSQLScript = new JMenuItem(NbBundle.getMessage(DataViewTableUI.class, (String)"TOOLTIP_show_delete_sql"));
        miDeleteSQLScript.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] rows = DataViewTableUI.this.getSelectedRows();
                String rawDeleteStmt = "";
                for (int j = 0; j < rows.length; ++j) {
                    SQLStatementGenerator generator = dataView.getSQLStatementGenerator();
                    int modelIndex = DataViewTableUI.this.convertRowIndexToModel(rows[j]);
                    DBTable table = pageContext.getTableMetaData().getTable(0);
                    String deleteStmt = generator.generateDeleteStatement(table, modelIndex, DataViewTableUI.this.getModel());
                    rawDeleteStmt = rawDeleteStmt + deleteStmt + ";\n";
                }
                ShowSQLDialog dialog = new ShowSQLDialog();
                dialog.setLocationRelativeTo(WindowManager.getDefault().getMainWindow());
                dialog.setText(rawDeleteStmt);
                dialog.setVisible(true);
            }
        });
        this.tablePopupMenu.add(miDeleteSQLScript);
        final JMenuItem miCommitSQLScript = new JMenuItem(NbBundle.getMessage(DataViewTableUI.class, (String)"TOOLTIP_show_update_sql"));
        miCommitSQLScript.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String rawUpdateStmt = "";
                SQLStatementGenerator generator = dataView.getSQLStatementGenerator();
                DBTable table = pageContext.getTableMetaData().getTable(0);
                try {
                    for (Integer row : DataViewTableUI.this.getModel().getUpdateKeys()) {
                        Map<Integer, Object> changedData = DataViewTableUI.this.getModel().getChangedData(row);
                        rawUpdateStmt = rawUpdateStmt + generator.generateUpdateStatement(table, row, changedData, DataViewTableUI.this.getModel()) + ";\n";
                    }
                    ShowSQLDialog dialog = new ShowSQLDialog();
                    dialog.setLocationRelativeTo(WindowManager.getDefault().getMainWindow());
                    dialog.setText(rawUpdateStmt);
                    dialog.setVisible(true);
                }
                catch (DBException ex) {
                    NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)ex.getMessage());
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
                }
            }
        });
        this.tablePopupMenu.add(miCommitSQLScript);
        this.tablePopupMenu.addSeparator();
        JMenuItem printTable = new JMenuItem(NbBundle.getMessage(DataViewTableUI.class, (String)"TOOLTIP_print_data"));
        printTable.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Logger mLogger = Logger.getLogger(DataViewTableUI.class.getName());
                try {
                    if (!DataViewTableUI.this.print()) {
                        mLogger.log(Level.INFO, NbBundle.getMessage(DataViewTableUI.class, (String)"MSG_cancel_printing"));
                    }
                }
                catch (PrinterException ex) {
                    mLogger.log(Level.INFO, NbBundle.getMessage(DataViewTableUI.class, (String)("MSG_failure_to_print" + ex.getMessage())));
                }
            }
        });
        this.tablePopupMenu.add(printTable);
        JMenuItem miRefreshAction = new JMenuItem(NbBundle.getMessage(DataViewTableUI.class, (String)"TOOLTIP_refresh"));
        miRefreshAction.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                handler.refreshActionPerformed();
            }
        });
        this.tablePopupMenu.add(miRefreshAction);
        this.tablePopupMenu.addSeparator();
        final JMenuItem miSetNull = new JMenuItem(NbBundle.getMessage(DataViewTableUI.class, (String)"TOOLTIP_set_cell_to_null"));
        miSetNull.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (int col : DataViewTableUI.this.getSelectedColumns()) {
                    int modelColumn = DataViewTableUI.this.convertColumnIndexToModel(col);
                    DBColumn dbcol = DataViewTableUI.this.getModel().getColumn(modelColumn);
                    for (int row : DataViewTableUI.this.getSelectedRows()) {
                        if (dbcol.isGenerated() || !dbcol.isNullable()) continue;
                        DataViewTableUI.this.setCellToNull(row, col);
                    }
                }
            }
        });
        this.tablePopupMenu.add(miSetNull);
        final JMenuItem miSetDefault = new JMenuItem(NbBundle.getMessage(DataViewTableUI.class, (String)"TOOLTIP_set_cell_to_default"));
        miSetDefault.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (int col : DataViewTableUI.this.getSelectedColumns()) {
                    int modelColumn = DataViewTableUI.this.convertColumnIndexToModel(col);
                    DBColumn dbcol = DataViewTableUI.this.getModel().getColumn(modelColumn);
                    for (int row : DataViewTableUI.this.getSelectedRows()) {
                        if (dbcol.isGenerated() || !dbcol.hasDefault()) continue;
                        DataViewTableUI.this.setCellToDefault(row, col);
                    }
                }
            }
        });
        this.tablePopupMenu.add(miSetDefault);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.getButton() == 3) {
                    DataViewTableUI.this.selectedRow = DataViewTableUI.this.rowAtPoint(e.getPoint());
                    DataViewTableUI.this.selectedColumn = DataViewTableUI.this.columnAtPoint(e.getPoint());
                    boolean inSelection = false;
                    int[] rows = DataViewTableUI.this.getSelectedRows();
                    for (int a = 0; a < rows.length; ++a) {
                        if (rows[a] != DataViewTableUI.this.selectedRow) continue;
                        inSelection = true;
                        break;
                    }
                    if (!DataViewTableUI.this.getRowSelectionAllowed()) {
                        inSelection = false;
                        int[] columns = DataViewTableUI.this.getSelectedColumns();
                        for (int a = 0; a < columns.length; ++a) {
                            if (columns[a] != DataViewTableUI.this.selectedColumn) continue;
                            inSelection = true;
                            break;
                        }
                    }
                    if (!inSelection) {
                        DataViewTableUI.this.changeSelection(DataViewTableUI.this.selectedRow, DataViewTableUI.this.selectedColumn, false, false);
                    }
                    if (!DataViewTableUI.this.getModel().isEditable()) {
                        miInsertAction.setEnabled(false);
                        miDeleteAction.setEnabled(false);
                        miTruncateRecord.setEnabled(false);
                        miInsertSQLScript.setEnabled(false);
                        miCreateSQLScript.setEnabled(false);
                        miDeleteSQLScript.setEnabled(false);
                    }
                    if (!DataViewTableUI.this.dataviewUI.isCommitEnabled()) {
                        miCommitAction.setEnabled(false);
                        miCancelEdits.setEnabled(false);
                        miCommitSQLScript.setEnabled(false);
                    } else {
                        miCommitAction.setEnabled(true);
                        miCancelEdits.setEnabled(true);
                        miCommitSQLScript.setEnabled(true);
                    }
                    if (DataViewTableUI.this.getSelectedRows().length > 0) {
                        miCopyRowValues.setEnabled(true);
                        miCopyRowValuesH.setEnabled(true);
                        miInsertSQLScript.setEnabled(true);
                        miDeleteSQLScript.setEnabled(true);
                        miDeleteAction.setEnabled(true);
                        boolean enableSetToNull = false;
                        boolean enableSetToDefault = false;
                        for (int col : DataViewTableUI.this.getSelectedColumns()) {
                            int modelColumn = DataViewTableUI.this.convertColumnIndexToModel(col);
                            DBColumn dbcol = DataViewTableUI.this.getModel().getColumn(modelColumn);
                            if (dbcol.isGenerated()) continue;
                            if (dbcol.isNullable()) {
                                enableSetToNull = true;
                            }
                            if (!dbcol.hasDefault()) continue;
                            enableSetToDefault = true;
                        }
                        miSetDefault.setEnabled(enableSetToDefault);
                        miSetNull.setEnabled(enableSetToNull);
                    } else {
                        miCopyRowValues.setEnabled(false);
                        miCopyRowValuesH.setEnabled(false);
                        miInsertSQLScript.setEnabled(false);
                        miDeleteSQLScript.setEnabled(false);
                        miDeleteAction.setEnabled(false);
                        miSetDefault.setEnabled(false);
                        miSetNull.setEnabled(false);
                    }
                    if (DataViewTableUI.this.selectedColumn >= 0 && DataViewTableUI.this.selectedRow >= 0) {
                        miCopyValue.setEnabled(true);
                    } else {
                        miCopyValue.setEnabled(false);
                    }
                    DataViewTableUI.this.tablePopupMenu.show((Component)((Object)DataViewTableUI.this), e.getX(), e.getY());
                }
            }
        });
    }

    private class TableSelectionListener
    implements ListSelectionListener {
        JTable table;

        TableSelectionListener(JTable table) {
            this.table = table;
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (DataViewTableUI.this.dataviewUI == null) {
                return;
            }
            if (e.getSource() == this.table.getSelectionModel() && this.table.getRowSelectionAllowed()) {
                boolean rowSelected;
                boolean bl = rowSelected = this.table.getSelectedRows().length > 0;
                if (rowSelected && DataViewTableUI.this.getModel().isEditable()) {
                    DataViewTableUI.this.dataviewUI.enableDeleteBtn(!DataViewTableUI.this.dataviewUI.isDirty());
                } else {
                    DataViewTableUI.this.dataviewUI.enableDeleteBtn(false);
                }
            }
        }
    }

    private class Control0KeyListener
    implements KeyListener {
        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.isControlDown() && e.getKeyCode() == 127) {
                TableCellEditor editor = DataViewTableUI.this.getCellEditor();
                if (editor != null) {
                    editor.stopCellEditing();
                }
                DataViewTableUI.this.handler.deleteRecordActionPerformed();
                e.consume();
            } else if (e.isControlDown() && e.getKeyChar() == '0') {
                int row = DataViewTableUI.this.getSelectedRow();
                int col = DataViewTableUI.this.getSelectedColumn();
                if (row == -1) {
                    return;
                }
                DataViewTableUI.this.setCellToNull(row, col);
                DataViewTableUI.this.setRowSelectionInterval(row, row);
                e.consume();
            } else if (e.isControlDown() && e.getKeyChar() == '1') {
                int row = DataViewTableUI.this.getSelectedRow();
                int col = DataViewTableUI.this.getSelectedColumn();
                if (row == -1) {
                    return;
                }
                DataViewTableUI.this.setCellToDefault(row, col);
                DataViewTableUI.this.setRowSelectionInterval(row, row);
                e.consume();
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }
    }

    private static class UpdatedResultSetCellRenderer
    extends ResultSetCellRenderer {
        static int borderThickness = 1;
        static Color selectedForeground;
        static Color unselectedForeground;
        private JComponent holder = new JComponent(){};

        public UpdatedResultSetCellRenderer() {
            this.holder.setLayout(new BorderLayout());
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Color color;
            Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            assert (table.getModel() instanceof DataViewTableUIModel) : "Assuming usage with DataViewTableUIModel";
            Color color2 = color = isSelected ? selectedForeground : unselectedForeground;
            if (c instanceof JRendererCheckBox) {
                this.holder.removeAll();
                this.holder.setBorder(new LineBorder(color, borderThickness));
                this.holder.add(c);
                return this.holder;
            }
            c.setForeground(color);
            return c;
        }

        static {
            Color selectedFgFromMngr = UIManager.getColor("nb.dataview.tablecell.edited.selected.foreground");
            selectedForeground = selectedFgFromMngr != null ? selectedFgFromMngr : new Color(229, 148, 0);
            Color unselectedFgFromMngr = UIManager.getColor("nb.dataview.tablecell.edited.unselected.foreground");
            unselectedForeground = unselectedFgFromMngr != null ? unselectedFgFromMngr : new Color(0, 128, 0);
        }
    }
}

