/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.util;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFileAttributes;
import java.nio.file.attribute.PosixFilePermission;
import java.text.Normalizer;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.FileUtils;
import org.eclipse.jgit.util.SystemReader;

class FileUtil {
    FileUtil() {
    }

    static String readSymlink(File path) throws IOException {
        Path nioPath = path.toPath();
        Path target = Files.readSymbolicLink(nioPath);
        String targetString = target.toString();
        if (SystemReader.getInstance().isWindows()) {
            targetString = targetString.replace('\\', '/');
        } else if (SystemReader.getInstance().isMacOS()) {
            targetString = Normalizer.normalize(targetString, Normalizer.Form.NFC);
        }
        return targetString;
    }

    public static void createSymLink(File path, String target) throws IOException {
        Path nioPath = path.toPath();
        if (Files.exists(nioPath, LinkOption.NOFOLLOW_LINKS)) {
            Files.delete(nioPath);
        }
        if (SystemReader.getInstance().isWindows()) {
            target = target.replace('/', '\\');
        }
        Path nioTarget = new File(target).toPath();
        Files.createSymbolicLink(nioPath, nioTarget, new FileAttribute[0]);
    }

    public static boolean isSymlink(File path) {
        Path nioPath = path.toPath();
        return Files.isSymbolicLink(nioPath);
    }

    public static long lastModified(File path) throws IOException {
        Path nioPath = path.toPath();
        return Files.getLastModifiedTime(nioPath, LinkOption.NOFOLLOW_LINKS).toMillis();
    }

    public static void setLastModified(File path, long time) throws IOException {
        Path nioPath = path.toPath();
        Files.setLastModifiedTime(nioPath, FileTime.fromMillis(time));
    }

    public static boolean exists(File path) {
        Path nioPath = path.toPath();
        return Files.exists(nioPath, LinkOption.NOFOLLOW_LINKS);
    }

    public static boolean isHidden(File path) throws IOException {
        Path nioPath = path.toPath();
        return Files.isHidden(nioPath);
    }

    public static void setHidden(File path, boolean hidden) throws IOException {
        Path nioPath = path.toPath();
        Files.setAttribute(nioPath, "dos:hidden", hidden, LinkOption.NOFOLLOW_LINKS);
    }

    public static long getLength(File path) throws IOException {
        Path nioPath = path.toPath();
        if (Files.isSymbolicLink(nioPath)) {
            return Files.readSymbolicLink(nioPath).toString().getBytes(Constants.CHARSET).length;
        }
        return Files.size(nioPath);
    }

    public static boolean isDirectory(File path) {
        Path nioPath = path.toPath();
        return Files.isDirectory(nioPath, LinkOption.NOFOLLOW_LINKS);
    }

    public static boolean isFile(File path) {
        Path nioPath = path.toPath();
        return Files.isRegularFile(nioPath, LinkOption.NOFOLLOW_LINKS);
    }

    public static boolean canExecute(File path) {
        if (!FileUtil.isFile(path)) {
            return false;
        }
        return path.canExecute();
    }

    public static boolean setExecute(File path, boolean executable) {
        if (!FileUtil.isFile(path)) {
            return false;
        }
        return path.setExecutable(executable);
    }

    public static void delete(File path) throws IOException {
        Path nioPath = path.toPath();
        Files.delete(nioPath);
    }

    static FS.Attributes getFileAttributesBasic(FS fs, File path) {
        try {
            Path nioPath = path.toPath();
            BasicFileAttributes readAttributes = nioPath.getFileSystem().provider().getFileAttributeView(nioPath, BasicFileAttributeView.class, LinkOption.NOFOLLOW_LINKS).readAttributes();
            Java7BasicAttributes attributes = new Java7BasicAttributes(fs, path, true, readAttributes.isDirectory(), fs.supportsExecute() ? path.canExecute() : false, readAttributes.isSymbolicLink(), readAttributes.isRegularFile(), readAttributes.creationTime().toMillis(), readAttributes.lastModifiedTime().toMillis(), readAttributes.isSymbolicLink() ? (long)Constants.encode((String)FileUtils.readSymLink((File)path)).length : readAttributes.size());
            return attributes;
        }
        catch (NoSuchFileException e) {
            return new Java7BasicAttributes(fs, path, false, false, false, false, false, 0L, 0L, 0L);
        }
        catch (IOException e) {
            return new FS.Attributes(path, fs);
        }
    }

    static FS.Attributes getFileAttributesPosix(FS fs, File path) {
        try {
            Path nioPath = path.toPath();
            PosixFileAttributes readAttributes = nioPath.getFileSystem().provider().getFileAttributeView(nioPath, PosixFileAttributeView.class, LinkOption.NOFOLLOW_LINKS).readAttributes();
            Java7BasicAttributes attributes = new Java7BasicAttributes(fs, path, true, readAttributes.isDirectory(), readAttributes.permissions().contains((Object)PosixFilePermission.OWNER_EXECUTE), readAttributes.isSymbolicLink(), readAttributes.isRegularFile(), readAttributes.creationTime().toMillis(), readAttributes.lastModifiedTime().toMillis(), readAttributes.size());
            return attributes;
        }
        catch (NoSuchFileException e) {
            return new Java7BasicAttributes(fs, path, false, false, false, false, false, 0L, 0L, 0L);
        }
        catch (IOException e) {
            return new FS.Attributes(path, fs);
        }
    }

    public static File normalize(File file) {
        if (SystemReader.getInstance().isMacOS()) {
            String normalized = Normalizer.normalize(file.getPath(), Normalizer.Form.NFC);
            return new File(normalized);
        }
        return file;
    }

    public static String normalize(String name) {
        if (SystemReader.getInstance().isMacOS()) {
            if (name == null) {
                return null;
            }
            return Normalizer.normalize(name, Normalizer.Form.NFC);
        }
        return name;
    }

    static class Java7BasicAttributes
    extends FS.Attributes {
        Java7BasicAttributes(FS fs, File fPath, boolean exists, boolean isDirectory, boolean isExecutable, boolean isSymbolicLink, boolean isRegularFile, long creationTime, long lastModifiedTime, long length) {
            super(fs, fPath, exists, isDirectory, isExecutable, isSymbolicLink, isRegularFile, creationTime, lastModifiedTime, length);
        }
    }
}

