/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript2.prototypejs.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.javascript2.editor.api.lexer.JsTokenId;
import org.netbeans.modules.javascript2.editor.api.lexer.LexUtilities;
import org.netbeans.modules.javascript2.editor.model.DeclarationScope;
import org.netbeans.modules.javascript2.editor.model.Identifier;
import org.netbeans.modules.javascript2.editor.model.JsFunction;
import org.netbeans.modules.javascript2.editor.model.JsObject;
import org.netbeans.modules.javascript2.editor.model.Occurrence;
import org.netbeans.modules.javascript2.editor.model.TypeUsage;
import org.netbeans.modules.javascript2.editor.spi.model.FunctionArgument;
import org.netbeans.modules.javascript2.editor.spi.model.FunctionInterceptor;
import org.netbeans.modules.javascript2.editor.spi.model.ModelElementFactory;
import org.netbeans.modules.parsing.api.Source;
import org.openide.filesystems.FileObject;

public class CreateInterceptor
implements FunctionInterceptor {
    private static final Pattern PATTERN = Pattern.compile("Class\\.create");
    private static final String CLASS = "Class";
    private static final String INITIALIZE_METHOD_NAME = "initialize";

    public Pattern getNamePattern() {
        return PATTERN;
    }

    public void intercept(String name, JsObject globalObject, DeclarationScope scope, ModelElementFactory factory, Collection<FunctionArgument> args) {
        JsObject newObject;
        JsObject configObject;
        String objectName;
        FunctionArgument fArg = null;
        for (FunctionArgument farg : args) {
            if (farg.getKind() != FunctionArgument.Kind.ANONYMOUS_OBJECT) continue;
            fArg = farg;
            break;
        }
        if (fArg != null && fArg.getValue() instanceof JsObject && (objectName = this.findTheName(configObject = (JsObject)fArg.getValue())) != null && !objectName.isEmpty() && (newObject = ((JsObject)scope).getProperty(objectName)) != null) {
            JsObject constructor = configObject.getProperty(INITIALIZE_METHOD_NAME);
            if (constructor != null && constructor instanceof JsFunction) {
                ArrayList<Identifier> paramNames = new ArrayList<Identifier>();
                for (JsObject param : ((JsFunction)constructor).getParameters()) {
                    paramNames.add(param.getDeclarationName());
                }
                JsFunction newConstructor = factory.newFunction(scope, newObject.getParent(), newObject.getDeclarationName(), paramNames, constructor.getOffsetRange());
                for (JsObject param : ((JsFunction)constructor).getParameters()) {
                    JsObject newParam = newConstructor.getParameter(param.getName());
                    for (TypeUsage type : param.getAssignments()) {
                        newParam.addAssignment(type, type.getOffset());
                    }
                    for (Occurrence occurrence : param.getOccurrences()) {
                        newParam.addOccurrence(occurrence.getOffsetRange());
                    }
                }
                for (JsObject property : constructor.getProperties().values()) {
                    String propertyName = property.getName();
                    JsObject reference = factory.newReference((JsObject)newConstructor, propertyName, property.getOffsetRange(), property, property.isDeprecated(), property.getModifiers());
                    newConstructor.addProperty(propertyName, reference);
                    if (newObject.getProperty(propertyName) == null) continue;
                    for (Occurrence occurrence : newObject.getProperty(propertyName).getOccurrences()) {
                        reference.addOccurrence(occurrence.getOffsetRange());
                    }
                }
                newObject.getParent().addProperty(objectName, (JsObject)newConstructor);
                for (Occurrence occurrence : newObject.getOccurrences()) {
                    newConstructor.addOccurrence(occurrence.getOffsetRange());
                }
                newObject = newConstructor;
            }
            for (JsObject property : configObject.getProperties().values()) {
                String propertyName = property.getName();
                if (INITIALIZE_METHOD_NAME.equals(propertyName)) continue;
                JsObject reference = factory.newReference(newObject, propertyName, property.getDeclarationName().getOffsetRange(), property, true, property.getModifiers());
                newObject.addProperty(propertyName, reference);
            }
        }
    }

    private String findTheName(JsObject configObject) {
        List<JsTokenId> skipTokens;
        String name = null;
        FileObject fo = configObject.getFileObject();
        Source source = Source.create((FileObject)fo);
        TokenHierarchy th = source.createSnapshot().getTokenHierarchy();
        if (th == null) {
            return null;
        }
        TokenSequence ts = LexUtilities.getJsTokenSequence((TokenHierarchy)th, (int)configObject.getOffset());
        if (ts == null) {
            return null;
        }
        ts.move(configObject.getOffset());
        if (!ts.moveNext()) {
            return null;
        }
        Token token = LexUtilities.findPreviousToken((TokenSequence)ts, Arrays.asList(JsTokenId.IDENTIFIER));
        while ((token.id() != JsTokenId.IDENTIFIER || !CLASS.equals(token.text().toString())) && ts.movePrevious()) {
            token = ts.token();
        }
        if (token.id() == JsTokenId.IDENTIFIER && CLASS.equals(token.text().toString()) && ts.movePrevious() && (token = LexUtilities.findPrevious((TokenSequence)ts, skipTokens = Arrays.asList(JsTokenId.WHITESPACE, JsTokenId.EOL, JsTokenId.BLOCK_COMMENT, JsTokenId.LINE_COMMENT))).id() == JsTokenId.OPERATOR_ASSIGNMENT && ts.movePrevious() && (token = LexUtilities.findPrevious((TokenSequence)ts, skipTokens)).id() == JsTokenId.IDENTIFIER) {
            name = token.text().toString();
        }
        return name;
    }
}

