/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor.refactoring;

import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.ListCellRenderer;
import javax.swing.text.BadLocationException;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.css.refactoring.api.CssRefactoring;
import org.netbeans.modules.html.editor.HtmlPreferences;
import org.netbeans.modules.html.editor.indexing.HtmlLinkEntry;
import org.netbeans.modules.html.editor.refactoring.RefactoringContext;
import org.netbeans.modules.html.editor.refactoring.ResolveDeclarationItem;
import org.netbeans.modules.html.editor.refactoring.ResolveDeclarationsPanel;
import org.netbeans.modules.html.editor.refactoring.api.ExtractInlinedStyleRefactoring;
import org.netbeans.modules.html.editor.refactoring.api.SelectorType;
import org.netbeans.modules.refactoring.spi.ui.CustomRefactoringPanel;
import org.netbeans.modules.web.common.spi.ProjectWebRootQuery;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class ExtractInlinedStylePanel
extends JPanel
implements CustomRefactoringPanel {
    private List<FileObject> allStylesheets;
    private RefactoringContext context;
    private ExtractInlinedStyleRefactoring.Mode selection;
    private SelectorType selectorType;
    private ResolveDeclarationsPanel resolveIdsPanel;
    private ResolveDeclarationsPanel resolveClassesPanel;
    private ResolveDeclarationsPanel current;
    private JRadioButton classSelectorTypeRB;
    private JRadioButton embeddedSectionRB;
    private JComboBox existingEmbeddedSectionsComboBox;
    private JRadioButton externalSheetRB;
    private JComboBox externalSheetsComboBox;
    private JLabel generatedSelectorTypeLabel;
    private JRadioButton idSelectorTypeRB;
    private JScrollPane jScrollPane1;
    private JLabel label;
    private ButtonGroup refactorToTypeButtonGroup;
    private JLabel resolveDeclarationsLabel;
    private ButtonGroup selectorTypeButtonGroup;

    public ExtractInlinedStylePanel(RefactoringContext context) {
        this.context = context;
        this.allStylesheets = new ArrayList<FileObject>(CssRefactoring.findAllStyleSheets((FileObject)context.getFile()));
        Collection<ResolveDeclarationItem> idItems = context.getIdSelectorsToResolve().values();
        this.resolveIdsPanel = idItems.isEmpty() ? null : new ResolveDeclarationsPanel(idItems);
        Collection<ResolveDeclarationItem> classItems = context.getClassSelectorsToResolve().values();
        this.resolveClassesPanel = classItems.isEmpty() ? null : new ResolveDeclarationsPanel(classItems);
        this.initComponents();
        this.initUI();
    }

    private void initUI() {
        ExtractInlinedStyleRefactoring.Mode mode = HtmlPreferences.extractInlinedStylePanelSectionMode();
        if (mode == ExtractInlinedStyleRefactoring.Mode.refactorToExistingEmbeddedSection) {
            if (this.context.getExistingEmbeddedCssSections().isEmpty()) {
                mode = ExtractInlinedStyleRefactoring.Mode.refactorToNewEmbeddedSection;
            }
        } else if (mode == ExtractInlinedStyleRefactoring.Mode.refactorToReferedExternalSheet) {
            if (this.context.getLinkedExternalStylesheets().isEmpty()) {
                mode = ExtractInlinedStyleRefactoring.Mode.refactorToNewExternalSheet;
            }
            if (this.externalSheetsComboBox.getModel().getSize() == 0) {
                mode = ExtractInlinedStyleRefactoring.Mode.refactorToNewEmbeddedSection;
            }
        } else if (mode == ExtractInlinedStyleRefactoring.Mode.refactorToExistingExternalSheet) {
            if (!this.context.getLinkedExternalStylesheets().isEmpty()) {
                mode = ExtractInlinedStyleRefactoring.Mode.refactorToReferedExternalSheet;
            }
            if (this.externalSheetsComboBox.getModel().getSize() == 0) {
                mode = ExtractInlinedStyleRefactoring.Mode.refactorToNewEmbeddedSection;
            }
        }
        this.setSectionMode(mode);
        ItemListener embeddedSectionsItemListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                EmbeddedSectionItem selected = (EmbeddedSectionItem)ExtractInlinedStylePanel.this.existingEmbeddedSectionsComboBox.getSelectedItem();
                if (selected instanceof CreateNewEmbeddedSectionItem) {
                    ExtractInlinedStylePanel.this.selection = ExtractInlinedStyleRefactoring.Mode.refactorToNewEmbeddedSection;
                } else {
                    ExtractInlinedStylePanel.this.selection = ExtractInlinedStyleRefactoring.Mode.refactorToExistingEmbeddedSection;
                }
                HtmlPreferences.setExtractInlinedStylePanelSectionMode(ExtractInlinedStylePanel.this.selection);
            }
        };
        this.embeddedSectionRB.addItemListener(embeddedSectionsItemListener);
        this.existingEmbeddedSectionsComboBox.addItemListener(embeddedSectionsItemListener);
        ItemListener externalStylesheetsItemListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ExternalStyleSheetItem selected = (ExternalStyleSheetItem)ExtractInlinedStylePanel.this.externalSheetsComboBox.getSelectedItem();
                if (selected instanceof ReferedExternalStyleSheetItem) {
                    ExtractInlinedStylePanel.this.selection = ExtractInlinedStyleRefactoring.Mode.refactorToReferedExternalSheet;
                } else {
                    ExtractInlinedStylePanel.this.selection = ExtractInlinedStyleRefactoring.Mode.refactorToExistingExternalSheet;
                }
                HtmlPreferences.setExtractInlinedStylePanelSectionMode(ExtractInlinedStylePanel.this.selection);
            }
        };
        this.externalSheetRB.addItemListener(externalStylesheetsItemListener);
        this.externalSheetsComboBox.addItemListener(externalStylesheetsItemListener);
        ItemListener refactorToSelectorTypeItemListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                Object s = e.getSource();
                if (e.getStateChange() == 1) {
                    if (s == ExtractInlinedStylePanel.this.classSelectorTypeRB) {
                        ExtractInlinedStylePanel.this.selectorType = SelectorType.CLASS;
                    } else if (s == ExtractInlinedStylePanel.this.idSelectorTypeRB) {
                        ExtractInlinedStylePanel.this.selectorType = SelectorType.ID;
                    } else assert (false);
                    ExtractInlinedStylePanel.this.setResolveDeclarationsPanel(ExtractInlinedStylePanel.this.selectorType);
                    HtmlPreferences.setExtractInlinedStylePanelSelectorType(ExtractInlinedStylePanel.this.selectorType);
                }
            }
        };
        this.idSelectorTypeRB.addItemListener(refactorToSelectorTypeItemListener);
        this.classSelectorTypeRB.addItemListener(refactorToSelectorTypeItemListener);
        this.setSelectorType(HtmlPreferences.extractInlinedStylePanelSelectorType());
    }

    private void setResolveDeclarationsPanel(SelectorType type) {
        ResolveDeclarationsPanel panel;
        ResolveDeclarationsPanel resolveDeclarationsPanel = panel = type == SelectorType.CLASS ? this.resolveClassesPanel : this.resolveIdsPanel;
        if (this.current != null) {
            this.jScrollPane1.setViewportView(null);
            this.jScrollPane1.setEnabled(false);
        }
        this.current = panel;
        if (this.current != null) {
            this.resolveDeclarationsLabel.setEnabled(true);
            this.jScrollPane1.setEnabled(true);
            this.jScrollPane1.setViewportView(panel);
        } else {
            this.resolveDeclarationsLabel.setEnabled(false);
            this.jScrollPane1.setEnabled(false);
        }
        this.revalidate();
        this.repaint();
    }

    private void setSectionMode(ExtractInlinedStyleRefactoring.Mode mode) {
        JRadioButton select;
        this.selection = mode;
        switch (this.selection) {
            case refactorToExistingEmbeddedSection: {
                if (this.existingEmbeddedSectionsComboBox.getModel().getSize() > 1) {
                    this.existingEmbeddedSectionsComboBox.setSelectedIndex(1);
                }
            }
            case refactorToNewEmbeddedSection: {
                select = this.embeddedSectionRB;
                break;
            }
            case refactorToExistingExternalSheet: 
            case refactorToReferedExternalSheet: 
            case refactorToNewExternalSheet: {
                select = this.externalSheetRB;
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        select.setSelected(true);
    }

    private void setSelectorType(SelectorType type) {
        if (type == SelectorType.ID) {
            this.idSelectorTypeRB.setSelected(true);
        } else if (type == SelectorType.CLASS) {
            this.classSelectorTypeRB.setSelected(true);
        } else assert (false);
    }

    ExtractInlinedStyleRefactoring.Mode getSelectedMode() {
        return this.selection;
    }

    SelectorType getSelectorType() {
        return this.selectorType;
    }

    private void initComponents() {
        this.refactorToTypeButtonGroup = new ButtonGroup();
        this.selectorTypeButtonGroup = new ButtonGroup();
        this.label = new JLabel();
        this.embeddedSectionRB = new JRadioButton();
        this.externalSheetRB = new JRadioButton();
        this.existingEmbeddedSectionsComboBox = new JComboBox();
        this.externalSheetsComboBox = new JComboBox();
        this.generatedSelectorTypeLabel = new JLabel();
        this.idSelectorTypeRB = new JRadioButton();
        this.classSelectorTypeRB = new JRadioButton();
        this.resolveDeclarationsLabel = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.setBorder(BorderFactory.createEmptyBorder(12, 12, 11, 11));
        this.setRequestFocusEnabled(false);
        this.label.setHorizontalAlignment(2);
        Mnemonics.setLocalizedText((JLabel)this.label, (String)NbBundle.getMessage(ExtractInlinedStylePanel.class, (String)"LBL_ExtractInlinedStyleToLabel"));
        this.refactorToTypeButtonGroup.add(this.embeddedSectionRB);
        Mnemonics.setLocalizedText((AbstractButton)this.embeddedSectionRB, (String)NbBundle.getMessage(ExtractInlinedStylePanel.class, (String)"MSG_ExtractToEmbeddedSection"));
        this.refactorToTypeButtonGroup.add(this.externalSheetRB);
        Mnemonics.setLocalizedText((AbstractButton)this.externalSheetRB, (String)NbBundle.getMessage(ExtractInlinedStylePanel.class, (String)"MSG_ExternalStyleSheet"));
        this.externalSheetRB.setEnabled(!this.allStylesheets.isEmpty());
        this.existingEmbeddedSectionsComboBox.setModel(this.createEmbeddedCssSectionsModel());
        this.existingEmbeddedSectionsComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExtractInlinedStylePanel.this.existingEmbeddedSectionsComboBoxActionPerformed(evt);
            }
        });
        this.externalSheetsComboBox.setModel(this.createExternalStylesheetsModel());
        this.externalSheetsComboBox.setEnabled(!this.allStylesheets.isEmpty());
        this.externalSheetsComboBox.setRenderer(new ExternalStylesheetsListCellRenderer(this.externalSheetsComboBox.getRenderer()));
        this.externalSheetsComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExtractInlinedStylePanel.this.externalSheetsComboBoxActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.generatedSelectorTypeLabel, (String)NbBundle.getMessage(ExtractInlinedStylePanel.class, (String)"MSG_GenerateSelectorType"));
        this.selectorTypeButtonGroup.add(this.idSelectorTypeRB);
        Mnemonics.setLocalizedText((AbstractButton)this.idSelectorTypeRB, (String)NbBundle.getMessage(ExtractInlinedStylePanel.class, (String)"MSG_IdType"));
        this.selectorTypeButtonGroup.add(this.classSelectorTypeRB);
        Mnemonics.setLocalizedText((AbstractButton)this.classSelectorTypeRB, (String)NbBundle.getMessage(ExtractInlinedStylePanel.class, (String)"MSG_ClassType"));
        this.resolveDeclarationsLabel.setLabelFor(this.jScrollPane1);
        Mnemonics.setLocalizedText((JLabel)this.resolveDeclarationsLabel, (String)NbBundle.getMessage(ExtractInlinedStylePanel.class, (String)"MSG_UnresolvedDeclarationsLabel"));
        this.resolveDeclarationsLabel.setToolTipText(NbBundle.getMessage(ExtractInlinedStylePanel.class, (String)"TT_UnresolvedDeclarationsLabel"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.label).addGroup(layout.createSequentialGroup().addComponent(this.generatedSelectorTypeLabel).addGap(18, 18, 18).addComponent(this.idSelectorTypeRB).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.classSelectorTypeRB)).addComponent(this.resolveDeclarationsLabel).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.externalSheetRB).addComponent(this.embeddedSectionRB)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.externalSheetsComboBox, 0, 345, Short.MAX_VALUE).addComponent(this.existingEmbeddedSectionsComboBox, 0, 345, Short.MAX_VALUE))).addComponent(this.jScrollPane1, -1, 502, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.label).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.embeddedSectionRB).addComponent(this.existingEmbeddedSectionsComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.externalSheetRB).addComponent(this.externalSheetsComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.generatedSelectorTypeLabel).addComponent(this.idSelectorTypeRB).addComponent(this.classSelectorTypeRB)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.resolveDeclarationsLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 137, Short.MAX_VALUE)));
        this.embeddedSectionRB.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ExtractInlinedStylePanel.class, (String)"ACSD_EmbeddedSection"));
        this.externalSheetRB.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ExtractInlinedStylePanel.class, (String)"ACSD_ExternalStylesheet"));
        this.existingEmbeddedSectionsComboBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ExtractInlinedStylePanel.class, (String)"ACSD_EmbeddedSectionComboBoxName"));
        this.existingEmbeddedSectionsComboBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ExtractInlinedStylePanel.class, (String)"ACSD_EmbeddedSectionComboBoxDescription"));
        this.externalSheetsComboBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ExtractInlinedStylePanel.class, (String)"ASCD_ExternalStylesheetName"));
        this.externalSheetsComboBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ExtractInlinedStylePanel.class, (String)"ACSD_ExternalStylesheetDescr"));
        this.idSelectorTypeRB.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ExtractInlinedStylePanel.class, (String)"ASCD_GenerateIdSelectors"));
        this.classSelectorTypeRB.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ExtractInlinedStylePanel.class, (String)"ASCD_GenerateClassSelectors"));
    }

    private void existingEmbeddedSectionsComboBoxActionPerformed(ActionEvent evt) {
        this.embeddedSectionRB.setSelected(true);
    }

    private void externalSheetsComboBoxActionPerformed(ActionEvent evt) {
        this.externalSheetRB.setSelected(true);
    }

    private ComboBoxModel createEmbeddedCssSectionsModel() {
        List<OffsetRange> ranges = this.context.getExistingEmbeddedCssSections();
        EmbeddedSectionItem[] values = new EmbeddedSectionItem[ranges.size() + 1];
        values[0] = new CreateNewEmbeddedSectionItem();
        for (int i = 0; i < values.length - 1; ++i) {
            OffsetRange astRange = ranges.get(i);
            OffsetRange range = this.context.getDocumentRange(astRange);
            values[i + 1] = new EmbeddedSectionItem(range, this.getRenderStringFromOffsetRange(range));
        }
        return new DefaultComboBoxModel<EmbeddedSectionItem>(values);
    }

    private ComboBoxModel createExternalStylesheetsModel() {
        List<HtmlLinkEntry> links = this.context.getLinkedExternalStylesheets();
        HashSet<FileObject> linkedObjects = new HashSet<FileObject>();
        for (HtmlLinkEntry entry : links) {
            linkedObjects.add(entry.getFileReference().target());
        }
        TreeSet<ExternalStyleSheetItem> items = new TreeSet<ExternalStyleSheetItem>(new Comparator<ExternalStyleSheetItem>(){

            @Override
            public int compare(ExternalStyleSheetItem o1, ExternalStyleSheetItem o2) {
                if (o1 instanceof ReferedExternalStyleSheetItem && !(o2 instanceof ReferedExternalStyleSheetItem)) {
                    return -1;
                }
                if (!(o1 instanceof ReferedExternalStyleSheetItem) && o2 instanceof ReferedExternalStyleSheetItem) {
                    return 1;
                }
                return o1.getFile().getPath().compareTo(o2.getFile().getPath());
            }
        });
        for (FileObject stylesheet : this.allStylesheets) {
            if (linkedObjects.contains(stylesheet)) {
                items.add(new ReferedExternalStyleSheetItem(stylesheet));
                continue;
            }
            items.add(new ExternalStyleSheetItem(stylesheet));
        }
        return new DefaultComboBoxModel<ExternalStyleSheetItem>(items.toArray(new ExternalStyleSheetItem[0]));
    }

    OffsetRange getSelectedEmbeddedSection() {
        EmbeddedSectionItem selected = (EmbeddedSectionItem)this.existingEmbeddedSectionsComboBox.getSelectedItem();
        return selected.range;
    }

    FileObject getSelectedExternalStyleSheet() {
        ExternalStyleSheetItem selected = (ExternalStyleSheetItem)this.externalSheetsComboBox.getSelectedItem();
        return selected.getFile();
    }

    String getRenderStringFromOffsetRange(final OffsetRange range) {
        if (range == null) {
            return NbBundle.getMessage(ExtractInlinedStylePanel.class, (String)"MSG_SectionCannotDetermineLines");
        }
        final AtomicReference ret = new AtomicReference();
        this.context.getDocument().render(new Runnable(){

            @Override
            public void run() {
                try {
                    int firstLine = Utilities.getLineOffset((BaseDocument)((BaseDocument)ExtractInlinedStylePanel.this.context.getDocument()), (int)range.getStart());
                    int lastLine = Utilities.getLineOffset((BaseDocument)((BaseDocument)ExtractInlinedStylePanel.this.context.getDocument()), (int)range.getEnd());
                    ret.set(new OffsetRange(firstLine, lastLine));
                }
                catch (BadLocationException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        });
        OffsetRange line = (OffsetRange)ret.get();
        return NbBundle.getMessage(ExtractInlinedStylePanel.class, (String)"MSG_SectionFromTo", (Object)(line.getStart() + 1), (Object)(line.getEnd() + 1));
    }

    public Component getComponent() {
        return this;
    }

    public void initialize() {
    }

    private static class CreateNewEmbeddedSectionItem
    extends EmbeddedSectionItem {
        private static final String TEXT = NbBundle.getMessage(ExtractInlinedStylePanel.class, (String)"MSG_createNewEmbeddedSection");

        public CreateNewEmbeddedSectionItem() {
            super(null, TEXT);
        }
    }

    private static class EmbeddedSectionItem {
        public OffsetRange range;
        public String displayName;

        public EmbeddedSectionItem(OffsetRange range, String displayName) {
            this.range = range;
            this.displayName = displayName;
        }

        public String toString() {
            return this.displayName;
        }
    }

    private static class ExternalStyleSheetItem
    implements Comparable {
        private FileObject file;
        private String displayName;

        public ExternalStyleSheetItem(FileObject file) {
            this.file = file;
            FileObject webRoot = ProjectWebRootQuery.getWebRoot((FileObject)file);
            this.displayName = FileUtil.getRelativePath((FileObject)webRoot, (FileObject)file);
        }

        public FileObject getFile() {
            return this.file;
        }

        public String toString() {
            return this.displayName;
        }

        public int compareTo(Object o) {
            if (!(o instanceof ExternalStyleSheetItem)) {
                throw new ClassCastException();
            }
            ExternalStyleSheetItem esi = (ExternalStyleSheetItem)o;
            return this.getFile().getPath().compareTo(esi.getFile().getPath());
        }
    }

    private class ExternalStylesheetsListCellRenderer
    implements ListCellRenderer {
        private ListCellRenderer orig;

        public ExternalStylesheetsListCellRenderer(ListCellRenderer orig) {
            this.orig = orig;
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Font font;
            Component res = this.orig.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            if (value instanceof ReferedExternalStyleSheetItem && res instanceof JLabel && !(font = res.getFont()).isBold()) {
                res.setFont(font.deriveFont(1));
            }
            return res;
        }
    }

    private static class ReferedExternalStyleSheetItem
    extends ExternalStyleSheetItem {
        public ReferedExternalStyleSheetItem(FileObject file) {
            super(file);
        }

        @Override
        public int compareTo(Object o) {
            if (o instanceof ReferedExternalStyleSheetItem) {
                return super.compareTo(o);
            }
            if (o instanceof ExternalStyleSheetItem) {
                return 1;
            }
            throw new ClassCastException();
        }
    }
}

