/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor.options.ui;

import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.AbstractPreferences;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.editor.indent.api.Reformat;
import org.netbeans.modules.options.editor.spi.PreferencesCustomizer;
import org.netbeans.modules.options.editor.spi.PreviewProvider;
import org.openide.text.CloneableEditorSupport;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class FmtOptions {
    private static final Logger LOGGER = Logger.getLogger(FmtOptions.class.getName());
    public static final String expandTabToSpaces = "expand-tabs";
    public static final String tabSize = "tab-size";
    public static final String spacesPerTab = "spaces-per-tab";
    public static final String indentSize = "indent-shift-width";
    public static final String continuationIndentSize = "continuationIndentSize";
    public static final String itemsInArrayDeclarationIndentSize = "itemsInArrayDeclarationIndentSize";
    public static final String reformatComments = "reformatComments";
    public static final String indentHtml = "indentHtml";
    public static final String rightMargin = "text-limit-width";
    public static final String initialIndent = "init.indent";
    public static final String classDeclBracePlacement = "classDeclBracePlacement";
    public static final String methodDeclBracePlacement = "methodDeclBracePlacement";
    public static final String ifBracePlacement = "ifBracePlacement";
    public static final String forBracePlacement = "forBracePlacement";
    public static final String whileBracePlacement = "whileBracePlacement";
    public static final String switchBracePlacement = "switchBracePlacement";
    public static final String catchBracePlacement = "catchBracePlacement";
    public static final String useTraitBodyBracePlacement = "useTraitBodyBracePlacement";
    public static final String otherBracePlacement = "otherBracePlacement";
    public static final String blankLinesBeforeNamespace = "blankLinesBeforeNamespace";
    public static final String blankLinesAfterNamespace = "blankLinesAfterNamespace";
    public static final String blankLinesBeforeUse = "blankLinesBeforeUse";
    public static final String blankLinesBeforeUseTrait = "blankLinesBeforeUseTrait";
    public static final String blankLinesAfterUse = "blankLinesAfterUse";
    public static final String blankLinesBeforeClass = "blankLinesBeforeClass";
    public static final String blankLinesBeforeClassEnd = "blankLinesBeforeClassEnd";
    public static final String blankLinesAfterClass = "blankLinesAfterClass";
    public static final String blankLinesAfterClassHeader = "blankLinesAfterClassHeader";
    public static final String blankLinesBeforeFields = "blankLinesBeforeField";
    public static final String blankLinesBetweenFields = "blankLinesBetweenField";
    public static final String blankLinesAfterFields = "blankLinesAfterField";
    public static final String blankLinesGroupFieldsWithoutDoc = "blankLinesGroupFieldsWithoutDoc";
    public static final String blankLinesBeforeFunction = "blankLinesBeforeFunction";
    public static final String blankLinesAfterFunction = "blankLinesAfterFunction";
    public static final String blankLinesBeforeFunctionEnd = "blankLinesBeforeFunctionEnd";
    public static final String blankLinesAfterOpenPHPTag = "blankLinesAfterOpenPHPTag";
    public static final String blankLinesAfterOpenPHPTagInHTML = "blankLinesAfterOpenPHPTagInHTML";
    public static final String blankLinesBeforeClosePHPTag = "blankLinesBeforeClosePHPTag";
    public static final String spaceBeforeWhile = "spaceBeforeWhile";
    public static final String spaceBeforeElse = "spaceBeforeElse";
    public static final String spaceBeforeCatch = "spaceBeforeCatch";
    public static final String spaceBeforeFinally = "spaceBeforeFinally";
    public static final String spaceBeforeMethodDeclParen = "spaceBeforeMethodDeclParen";
    public static final String spaceBeforeMethodCallParen = "spaceBeforeMethodCallParen";
    public static final String spaceBeforeIfParen = "spaceBeforeIfParen";
    public static final String spaceBeforeForParen = "spaceBeforeForParen";
    public static final String spaceBeforeWhileParen = "spaceBeforeWhileParen";
    public static final String spaceBeforeCatchParen = "spaceBeforeCatchParen";
    public static final String spaceBeforeSwitchParen = "spaceBeforeSwitchParen";
    public static final String spaceBeforeWithParen = "spaceBeforeWithParen";
    public static final String spaceAroundUnaryOps = "spaceAroundUnaryOps";
    public static final String spaceAroundBinaryOps = "spaceAroundBinaryOps";
    public static final String spaceAroundTernaryOps = "spaceAroundTernaryOps";
    public static final String spaceAroundStringConcatOps = "spaceAroundStringConcatOps";
    public static final String spaceAroundAssignOps = "spaceAroundAssignOps";
    public static final String spaceAroundKeyValueOps = "spaceAroundKeyValueOps";
    public static final String spaceAroundObjectOps = "spaceAroundObjectOps";
    public static final String spaceBeforeClassDeclLeftBrace = "spaceBeforeClassDeclLeftBrace";
    public static final String spaceBeforeMethodDeclLeftBrace = "spaceBeforeMethodDeclLeftBrace";
    public static final String spaceBeforeIfLeftBrace = "spaceBeforeIfLeftBrace";
    public static final String spaceBeforeElseLeftBrace = "spaceBeforeElseLeftBrace";
    public static final String spaceBeforeWhileLeftBrace = "spaceBeforeWhileLeftBrace";
    public static final String spaceBeforeForLeftBrace = "spaceBeforeForLeftBrace";
    public static final String spaceBeforeDoLeftBrace = "spaceBeforeDoLeftBrace";
    public static final String spaceBeforeSwitchLeftBrace = "spaceBeforeSwitchLeftBrace";
    public static final String spaceBeforeTryLeftBrace = "spaceBeforeTryLeftBrace";
    public static final String spaceBeforeCatchLeftBrace = "spaceBeforeCatchLeftBrace";
    public static final String spaceBeforeFinallyLeftBrace = "spaceBeforeFinallyLeftBrace";
    public static final String spaceBeforeWithLeftBrace = "spaceBeforeWithLeftBrace";
    public static final String spaceWithinParens = "spaceWithinParens";
    public static final String spaceWithinArrayDeclParens = "spaceWithinArrayDeclParens";
    public static final String spaceWithinMethodDeclParens = "spaceWithinMethodDeclParens";
    public static final String spaceWithinMethodCallParens = "spaceWithinMethodCallParens";
    public static final String spaceWithinIfParens = "spaceWithinIfParens";
    public static final String spaceWithinForParens = "spaceWithinForParens";
    public static final String spaceWithinWhileParens = "spaceWithinWhileParens";
    public static final String spaceWithinSwitchParens = "spaceWithinSwitchParens";
    public static final String spaceWithinCatchParens = "spaceWithinCatchParens";
    public static final String spaceWithinWithParens = "spaceWithinWithParens";
    public static final String spaceWithinTypeCastParens = "spaceWithinTypeCastParens";
    public static final String spaceWithinBraces = "spaceWithinBraces";
    public static final String spaceWithinArrayBrackets = "spaceWithinArrayBrackets";
    public static final String spaceBeforeComma = "spaceBeforeComma";
    public static final String spaceAfterComma = "spaceAfterComma";
    public static final String spaceBeforeSemi = "spaceBeforeSemi";
    public static final String spaceAfterSemi = "spaceAfterSemi";
    public static final String spaceBeforeColon = "spaceBeforeColon";
    public static final String spaceAfterColon = "spaceAfterColon";
    public static final String placeElseOnNewLine = "placeElseOnNewLine";
    public static final String placeWhileOnNewLine = "placeWhileOnNewLine";
    public static final String placeCatchOnNewLine = "placeCatchOnNewLine";
    public static final String placeNewLineAfterModifiers = "placeNewLineAfterModifiers";
    public static final String alignMultilineMethodParams = "alignMultilineMethodParams";
    public static final String alignMultilineCallArgs = "alignMultilineCallArgs";
    public static final String alignMultilineImplements = "alignMultilineImplements";
    public static final String alignMultilineParenthesized = "alignMultilineParenthesized";
    public static final String alignMultilineBinaryOp = "alignMultilineBinaryOp";
    public static final String alignMultilineTernaryOp = "alignMultilineTernaryOp";
    public static final String alignMultilineAssignment = "alignMultilineAssignment";
    public static final String alignMultilineFor = "alignMultilineFor";
    public static final String alignMultilineArrayInit = "alignMultilineArrayInit";
    public static final String groupAlignmentAssignment = "groupAlignmentAssignment";
    public static final String groupAlignmentArrayInit = "groupAlignmentArrayInit";
    public static final String wrapStatement = "wrapStatement";
    public static final String wrapVariables = "wrapVariables";
    public static final String wrapMethodParams = "wrapMethodParams";
    public static final String wrapMethodCallArgs = "wrapMethodCallArgs";
    public static final String wrapChainedMethodCalls = "wrapChainedMethodCalls";
    public static final String wrapAfterDotInChainedMethodCalls = "wrapAfterDotInChainedMethodCalls";
    public static final String wrapArrayInit = "wrapArrayInit";
    public static final String wrapArrayInitItems = "wrapArrayInitItems";
    public static final String wrapFor = "wrapFor";
    public static final String wrapForStatement = "wrapForStatement";
    public static final String wrapIfStatement = "wrapIfStatement";
    public static final String wrapWhileStatement = "wrapWhileStatement";
    public static final String wrapDoWhileStatement = "wrapDoWhileStatement";
    public static final String wrapWithStatement = "wrapWithStatement";
    public static final String wrapBinaryOps = "wrapBinaryOps";
    public static final String wrapAfterBinaryOps = "wrapAfterBinaryOps";
    public static final String wrapTernaryOps = "wrapTernaryOps";
    public static final String wrapAfterTernaryOps = "wrapAfterTernaryOps";
    public static final String wrapAssignOps = "wrapAssignOps";
    public static final String wrapBlockBraces = "wrapBlockBraces";
    public static final String wrapStatementsOnTheLine = "wrapStateMentsOnTheLine";
    public static final String wrapObjects = "wrapObjects";
    public static final String wrapProperties = "wrapProperties";
    public static final String preferFullyQualifiedNames = "preferFullyQualifiedNames";
    public static final String preferMultipleUseStatementsCombined = "preferMultipleUseStatementsCombined";
    public static final String startUseWithNamespaceSeparator = "startUseWithNamespaceSeparator";
    private static final String TRUE = "true";
    private static final String FALSE = "false";
    public static final String OBRACE_NEWLINE = BracePlacement.NEW_LINE.name();
    public static final String OBRACE_SAMELINE = BracePlacement.SAME_LINE.name();
    public static final String OBRACE_PRESERVE = BracePlacement.PRESERVE_EXISTING.name();
    public static final String OBRACE_NEWLINE_INDENTED = BracePlacement.NEW_LINE_INDENTED.name();
    public static final String WRAP_ALWAYS = WrapStyle.WRAP_ALWAYS.name();
    public static final String WRAP_IF_LONG = WrapStyle.WRAP_IF_LONG.name();
    public static final String WRAP_NEVER = WrapStyle.WRAP_NEVER.name();
    private static Map<String, String> defaults;

    private FmtOptions() {
    }

    public static int getDefaultAsInt(String key) {
        return Integer.parseInt(defaults.get(key));
    }

    public static boolean getDefaultAsBoolean(String key) {
        return Boolean.parseBoolean(defaults.get(key));
    }

    public static String getDefaultAsString(String key) {
        return defaults.get(key);
    }

    private static void createDefaults() {
        String[][] defaultValues = new String[][]{{expandTabToSpaces, TRUE}, {tabSize, "8"}, {indentSize, "4"}, {continuationIndentSize, "8"}, {itemsInArrayDeclarationIndentSize, "4"}, {reformatComments, FALSE}, {indentHtml, TRUE}, {rightMargin, "80"}, {initialIndent, "0"}, {classDeclBracePlacement, OBRACE_SAMELINE}, {methodDeclBracePlacement, OBRACE_SAMELINE}, {ifBracePlacement, OBRACE_SAMELINE}, {forBracePlacement, OBRACE_SAMELINE}, {whileBracePlacement, OBRACE_SAMELINE}, {switchBracePlacement, OBRACE_SAMELINE}, {catchBracePlacement, OBRACE_SAMELINE}, {useTraitBodyBracePlacement, OBRACE_SAMELINE}, {otherBracePlacement, OBRACE_SAMELINE}, {blankLinesBeforeNamespace, "1"}, {blankLinesAfterNamespace, "1"}, {blankLinesBeforeUse, "1"}, {blankLinesBeforeUseTrait, "1"}, {blankLinesAfterUse, "1"}, {blankLinesBeforeClass, "1"}, {blankLinesAfterClass, "1"}, {blankLinesAfterClassHeader, "0"}, {blankLinesBeforeClassEnd, "0"}, {blankLinesBeforeFields, "1"}, {blankLinesGroupFieldsWithoutDoc, TRUE}, {blankLinesBetweenFields, "1"}, {blankLinesAfterFields, "1"}, {blankLinesBeforeFunction, "1"}, {blankLinesAfterFunction, "1"}, {blankLinesBeforeFunctionEnd, "0"}, {blankLinesAfterOpenPHPTag, "1"}, {blankLinesAfterOpenPHPTagInHTML, "0"}, {blankLinesBeforeClosePHPTag, "0"}, {spaceBeforeWhile, TRUE}, {spaceBeforeElse, TRUE}, {spaceBeforeCatch, TRUE}, {spaceBeforeFinally, TRUE}, {spaceBeforeMethodDeclParen, FALSE}, {spaceBeforeMethodCallParen, FALSE}, {spaceBeforeIfParen, TRUE}, {spaceBeforeForParen, TRUE}, {spaceBeforeWhileParen, TRUE}, {spaceBeforeCatchParen, TRUE}, {spaceBeforeSwitchParen, TRUE}, {spaceBeforeWithParen, TRUE}, {spaceAroundUnaryOps, FALSE}, {spaceAroundBinaryOps, TRUE}, {spaceAroundTernaryOps, TRUE}, {spaceAroundStringConcatOps, TRUE}, {spaceAroundKeyValueOps, TRUE}, {spaceAroundAssignOps, TRUE}, {spaceAroundObjectOps, FALSE}, {spaceBeforeClassDeclLeftBrace, TRUE}, {spaceBeforeMethodDeclLeftBrace, TRUE}, {spaceBeforeIfLeftBrace, TRUE}, {spaceBeforeElseLeftBrace, TRUE}, {spaceBeforeWhileLeftBrace, TRUE}, {spaceBeforeForLeftBrace, TRUE}, {spaceBeforeDoLeftBrace, TRUE}, {spaceBeforeSwitchLeftBrace, TRUE}, {spaceBeforeTryLeftBrace, TRUE}, {spaceBeforeCatchLeftBrace, TRUE}, {spaceBeforeFinallyLeftBrace, TRUE}, {spaceBeforeWithLeftBrace, TRUE}, {spaceWithinParens, FALSE}, {spaceWithinArrayDeclParens, FALSE}, {spaceWithinMethodDeclParens, FALSE}, {spaceWithinMethodCallParens, FALSE}, {spaceWithinIfParens, FALSE}, {spaceWithinForParens, FALSE}, {spaceWithinWhileParens, FALSE}, {spaceWithinSwitchParens, FALSE}, {spaceWithinCatchParens, FALSE}, {spaceWithinWithParens, FALSE}, {spaceWithinTypeCastParens, FALSE}, {spaceWithinBraces, FALSE}, {spaceWithinArrayBrackets, FALSE}, {spaceBeforeComma, FALSE}, {spaceAfterComma, TRUE}, {spaceBeforeSemi, FALSE}, {spaceAfterSemi, TRUE}, {spaceBeforeColon, FALSE}, {spaceAfterColon, TRUE}, {alignMultilineMethodParams, FALSE}, {alignMultilineCallArgs, FALSE}, {alignMultilineImplements, FALSE}, {alignMultilineParenthesized, FALSE}, {alignMultilineBinaryOp, FALSE}, {alignMultilineTernaryOp, FALSE}, {alignMultilineAssignment, FALSE}, {alignMultilineFor, FALSE}, {alignMultilineArrayInit, FALSE}, {placeElseOnNewLine, FALSE}, {placeWhileOnNewLine, FALSE}, {placeCatchOnNewLine, FALSE}, {placeNewLineAfterModifiers, FALSE}, {groupAlignmentArrayInit, FALSE}, {groupAlignmentAssignment, FALSE}, {wrapStatement, WRAP_ALWAYS}, {wrapVariables, WRAP_NEVER}, {wrapMethodParams, WRAP_NEVER}, {wrapMethodCallArgs, WRAP_NEVER}, {wrapChainedMethodCalls, WRAP_NEVER}, {wrapAfterDotInChainedMethodCalls, TRUE}, {wrapArrayInit, WRAP_NEVER}, {wrapArrayInitItems, WRAP_NEVER}, {wrapFor, WRAP_NEVER}, {wrapForStatement, WRAP_ALWAYS}, {wrapIfStatement, WRAP_ALWAYS}, {wrapWhileStatement, WRAP_ALWAYS}, {wrapDoWhileStatement, WRAP_ALWAYS}, {wrapWithStatement, WRAP_ALWAYS}, {wrapBinaryOps, WRAP_NEVER}, {wrapAfterBinaryOps, FALSE}, {wrapTernaryOps, WRAP_NEVER}, {wrapAfterTernaryOps, FALSE}, {wrapAssignOps, WRAP_NEVER}, {wrapBlockBraces, TRUE}, {wrapStatementsOnTheLine, TRUE}, {wrapObjects, WRAP_NEVER}, {wrapProperties, WRAP_NEVER}, {preferFullyQualifiedNames, FALSE}, {preferMultipleUseStatementsCombined, FALSE}, {startUseWithNamespaceSeparator, FALSE}};
        defaults = new HashMap<String, String>();
        for (String[] strings : defaultValues) {
            defaults.put(strings[0], strings[1]);
        }
    }

    protected static Map<String, String> getDefaults() {
        return defaults;
    }

    public static boolean isInteger(String optionID) {
        String value = defaults.get(optionID);
        try {
            Integer.parseInt(value);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    static {
        FmtOptions.createDefaults();
    }

    public static enum BracePlacement {
        SAME_LINE,
        NEW_LINE,
        NEW_LINE_INDENTED,
        PRESERVE_EXISTING;

    }

    public static class CategorySupport
    implements ActionListener,
    DocumentListener,
    PreviewProvider,
    PreferencesCustomizer {
        private final String previewText;
        private final String id;
        protected final JPanel panel;
        private JEditorPane previewPane;
        private final Preferences preferences;
        private final Preferences previewPrefs;
        private final String mimeType;

        protected CategorySupport(String mimeType, Preferences preferences, String id, JPanel panel, String previewText, String[] ... forcedOptions) {
            this.mimeType = mimeType;
            this.preferences = preferences;
            this.id = id;
            this.panel = panel;
            this.previewText = previewText != null ? previewText : NbBundle.getMessage(FmtOptions.class, (String)"SAMPLE_Default");
            PreviewPreferences forcedPrefs = new PreviewPreferences();
            for (String[] option : forcedOptions) {
                ((Preferences)forcedPrefs).put(option[0], option[1]);
            }
            this.previewPrefs = new ProxyPreferences(preferences, forcedPrefs);
        }

        protected void addListeners() {
        }

        protected void loadFrom(Preferences preferences) {
        }

        protected void storeTo(Preferences p) {
        }

        public void notifyChanged() {
            this.storeTo(this.preferences);
            this.refreshPreview();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.notifyChanged();
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.notifyChanged();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.notifyChanged();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.notifyChanged();
        }

        public JComponent getPreviewComponent() {
            if (this.previewPane == null) {
                this.previewPane = new JEditorPane();
                this.previewPane.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FmtOptions.class, (String)"AN_Preview"));
                this.previewPane.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FmtOptions.class, (String)"AD_Preview"));
                this.previewPane.setEditorKit(CloneableEditorSupport.getEditorKit((String)this.mimeType));
                this.previewPane.setEditable(false);
            }
            return this.previewPane;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void refreshPreview() {
            JEditorPane pane = (JEditorPane)this.getPreviewComponent();
            try {
                int rm = this.previewPrefs.getInt(FmtOptions.rightMargin, FmtOptions.getDefaultAsInt(FmtOptions.rightMargin));
                pane.putClientProperty("TextLimitLine", rm);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            Rectangle visibleRectangle = pane.getVisibleRect();
            pane.setText(this.previewText);
            pane.setIgnoreRepaint(true);
            final Document doc = pane.getDocument();
            if (doc instanceof BaseDocument) {
                final Reformat reformat = Reformat.get((Document)doc);
                reformat.lock();
                try {
                    ((BaseDocument)doc).runAtomic(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                reformat.reformat(0, doc.getLength());
                            }
                            catch (BadLocationException ble) {
                                LOGGER.log(Level.WARNING, null, ble);
                            }
                        }
                    });
                }
                finally {
                    reformat.unlock();
                }
            } else {
                LOGGER.warning(String.format("Can't format %s; it's not BaseDocument.", doc));
            }
            pane.setIgnoreRepaint(false);
            pane.scrollRectToVisible(visibleRectangle);
            pane.repaint(100L);
        }

        public JComponent getComponent() {
            return this.panel;
        }

        public String getDisplayName() {
            return this.panel.getName();
        }

        public String getId() {
            return this.id;
        }

        public HelpCtx getHelpCtx() {
            return null;
        }

        public static final class Factory
        implements PreferencesCustomizer.Factory {
            private final String mimeType;
            private final String id;
            private final Class<? extends JPanel> panelClass;
            private final String previewText;
            private final String[][] forcedOptions;

            public Factory(String mimeType, String id, Class<? extends JPanel> panelClass, String previewText, String[] ... forcedOptions) {
                this.mimeType = mimeType;
                this.id = id;
                this.panelClass = panelClass;
                this.previewText = previewText;
                this.forcedOptions = forcedOptions;
            }

            public PreferencesCustomizer create(Preferences preferences) {
                try {
                    return new CategorySupport(this.mimeType, preferences, this.id, this.panelClass.newInstance(), this.previewText, this.forcedOptions);
                }
                catch (IllegalAccessException | InstantiationException e) {
                    LOGGER.log(Level.WARNING, "Exception during creating formatter customiezer", e);
                    return null;
                }
            }
        }
    }

    public static class PreviewPreferences
    extends AbstractPreferences {
        private Map<String, Object> map = new HashMap<String, Object>();

        public PreviewPreferences() {
            super(null, "");
        }

        @Override
        protected void putSpi(String key, String value) {
            this.map.put(key, value);
        }

        @Override
        protected String getSpi(String key) {
            return (String)this.map.get(key);
        }

        @Override
        protected void removeSpi(String key) {
            this.map.remove(key);
        }

        @Override
        protected void removeNodeSpi() throws BackingStoreException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        protected String[] keysSpi() throws BackingStoreException {
            String[] array = new String[this.map.keySet().size()];
            return this.map.keySet().toArray(array);
        }

        @Override
        protected String[] childrenNamesSpi() throws BackingStoreException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        protected AbstractPreferences childSpi(String name) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        protected void syncSpi() throws BackingStoreException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        protected void flushSpi() throws BackingStoreException {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    public static final class ProxyPreferences
    extends AbstractPreferences {
        private final Preferences[] delegates;

        public ProxyPreferences(Preferences ... delegates) {
            super(null, "");
            this.delegates = delegates;
        }

        @Override
        protected void putSpi(String key, String value) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        protected String getSpi(String key) {
            for (Preferences p : this.delegates) {
                String value = p.get(key, null);
                if (value == null) continue;
                return value;
            }
            return null;
        }

        @Override
        protected void removeSpi(String key) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        protected void removeNodeSpi() throws BackingStoreException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        protected String[] keysSpi() throws BackingStoreException {
            HashSet<String> keys = new HashSet<String>();
            for (Preferences p : this.delegates) {
                keys.addAll(Arrays.asList(p.keys()));
            }
            return keys.toArray(new String[keys.size()]);
        }

        @Override
        protected String[] childrenNamesSpi() throws BackingStoreException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        protected AbstractPreferences childSpi(String name) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        protected void syncSpi() throws BackingStoreException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        protected void flushSpi() throws BackingStoreException {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    public static enum WrapStyle {
        WRAP_ALWAYS,
        WRAP_IF_LONG,
        WRAP_NEVER;

    }
}

