/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.nb8.topComponent.view;

import com.harrand.coreclasses.nb.CentralLookup;
import com.harrand.coreclasses.notification.IObserver;
import com.harrand.coreclasses.notification.UpdateChain;
import com.harrand.coregui.naming.RenameMgrPanel;
import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrench.object.LookupUtil;
import com.harrand.dbwrenchnb.panel.EmptyPanel;
import com.harrand.nb8.topComponent.view.Bundle;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.util.Properties;
import javax.swing.GroupLayout;
import org.openide.windows.TopComponent;

@TopComponent.Description(preferredID="RenameHistoryTopComponent", persistenceType=0)
public final class RenameHistoryTopComponent
extends TopComponent
implements IObserver {
    private RenameMgrPanel renamePanel_;
    private Database db_ = null;
    private EmptyPanel emptyPanel_ = new EmptyPanel("No Database Open");

    public RenameHistoryTopComponent() {
        this.initComponents();
        this.setName(Bundle.CTL_RenameHistoryTopComponent());
        this.setToolTipText(Bundle.HINT_RenameHistoryTopComponent());
        this.setupGui();
        this.checkDbChanged();
        CentralLookup.getDefault().addObserver((IObserver)this);
    }

    private void checkDbChanged() {
        Database newDb = this.getLookupDb();
        if (LookupUtil.isNewDbSet((Database)this.db_, (Database)newDb)) {
            this.db_ = newDb;
            this.checkRenamePanelCreated();
            this.renamePanel_.setRenameMgr(this.db_.getRenameMgr());
        }
    }

    private void checkRenamePanelCreated() {
        if (this.db_ != null && this.renamePanel_ == null) {
            this.removeAll();
            this.renamePanel_ = new RenameMgrPanel(this.db_.getRenameMgr());
            this.add((Component)this.renamePanel_, "Center");
            this.invalidate();
            this.revalidate();
            this.repaint();
        }
    }

    private Database getLookupDb() {
        return (Database)CentralLookup.getDefault().lookup(Database.class);
    }

    public void update(UpdateChain chain) {
        if (LookupUtil.isDbLookupUpdate((UpdateChain)chain)) {
            this.checkDbChanged();
        }
    }

    private void setupGui() {
        this.layoutComponents();
    }

    private void layoutComponents() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.emptyPanel_, "Center");
    }

    private void initComponents() {
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 400, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 300, Short.MAX_VALUE));
    }

    public void componentOpened() {
    }

    public void componentClosed() {
    }

    void writeProperties(Properties p) {
        p.setProperty("version", "1.0");
    }

    void readProperties(Properties p) {
        String version = p.getProperty("version");
    }
}

