/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.nb8.topComponent.tools;

import com.harrand.coreclasses.db.DbDataResult;
import com.harrand.coreclasses.help.StrHelper;
import com.harrand.coreclasses.option.IOptionMgrSvr;
import com.harrand.coregui.helper.GuiHelper;
import com.harrand.coregui.jdesktop.swingworker.IProcessObserver;
import com.harrand.coregui.table.ResultsGridPanel;
import com.harrand.dbwrench.security.App;
import com.harrand.dbwrench.security.DbUser;
import com.harrand.dbwrenchgui.panel.TableDetailsPanel;
import com.harrand.dbwrenchnb.panel.EmptyPanel;
import com.harrand.nb8.topComponent.tools.Bundle;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.swing.GroupLayout;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import org.openide.windows.TopComponent;

@TopComponent.Description(preferredID="QueryResultsTopComponent", persistenceType=0)
public final class QueryResultsTopComponent
extends TopComponent
implements IProcessObserver {
    private List<ResultsGridPanel> gridPanels = new ArrayList<ResultsGridPanel>();
    private final JTabbedPane tabPane_ = new JTabbedPane(1);
    private final JPanel singleResultPanel_ = new JPanel(new BorderLayout());
    private final EmptyPanel emptyPanel_ = new EmptyPanel("No Query Run");
    private int cmdCount_ = 0;
    private boolean tabPaneAdded_ = false;
    private static final int TAB_MAX_CHARS = 30;

    public QueryResultsTopComponent() {
        this.initComponents();
        this.setName(Bundle.CTL_QueryResultsTopComponent());
        this.setToolTipText(Bundle.HINT_QueryResultsTopComponent());
        this.setLayout(new BorderLayout());
        this.add((Component)TableDetailsPanel.getInstance(), "Center");
    }

    public void clear() {
        this.gridPanels = new ArrayList<ResultsGridPanel>();
        GuiHelper.clearTabs((JTabbedPane)this.tabPane_);
        this.singleResultPanel_.removeAll();
    }

    public void setCmdCount(int cmdCount) {
        this.cmdCount_ = cmdCount;
        this.setContainerPanel();
    }

    private boolean useTabPanel() {
        return this.cmdCount_ > 1;
    }

    private void setContainerPanel() {
        this.removeAll();
        if (this.useTabPanel()) {
            this.add(this.tabPane_, "Center");
        } else {
            this.add(this.singleResultPanel_, "Center");
        }
        this.invalidate();
        this.revalidate();
        this.repaint();
    }

    private void addToContainer(int resultIdx, String tabStr, ResultsGridPanel resultsGridPanel) {
        if (this.useTabPanel()) {
            this.tabPane_.addTab(tabStr, (Component)resultsGridPanel);
        } else {
            this.singleResultPanel_.add((Component)resultsGridPanel, "Center");
        }
        resultsGridPanel.refresh();
        this.invalidate();
        this.revalidate();
        this.repaint();
    }

    public void process(List dataResults) {
        DbUser dbUser = App.getUser();
        this.setCmdCount(dataResults.size());
        for (int i = 0; i < dataResults.size(); ++i) {
            DbDataResult result = (DbDataResult)dataResults.get(i);
            int resultIdx = result.getCmdIndex();
            String tabStr = StrHelper.getTruncated((String)result.getCmdText(), (int)30);
            if (resultIdx < this.gridPanels.size()) continue;
            ResultsGridPanel resultsGridPanel = new ResultsGridPanel((IOptionMgrSvr)dbUser, result);
            this.gridPanels.add(resultsGridPanel);
            this.addToContainer(resultIdx, tabStr, resultsGridPanel);
            if (!this.useTabPanel()) continue;
            this.tabPane_.setIconAt(resultIdx, resultsGridPanel.getIcon());
        }
    }

    private void initComponents() {
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 400, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 300, Short.MAX_VALUE));
    }

    public void componentOpened() {
    }

    public void componentClosed() {
    }

    void writeProperties(Properties p) {
        p.setProperty("version", "1.0");
    }

    void readProperties(Properties p) {
        String version = p.getProperty("version");
    }
}

