/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.nb8.topComponent.tools;

import com.harrand.coreclasses.dataEntry.DataEntryResult;
import com.harrand.coreclasses.file.IFileUseMgr;
import com.harrand.coreclasses.help.StrHelper;
import com.harrand.coreclasses.interfaces.IScript;
import com.harrand.coreclasses.interfaces.IScriptCtrl;
import com.harrand.coreclasses.interfaces.ISortable;
import com.harrand.coreclasses.interfaces.IStep;
import com.harrand.coreclasses.interfaces.ITestResult;
import com.harrand.coreclasses.interfaces.implementation.BasicScript;
import com.harrand.coreclasses.interfaces.implementation.BasicStep;
import com.harrand.coreclasses.nb.CentralLookup;
import com.harrand.coreclasses.notification.IObserver;
import com.harrand.coreclasses.notification.UpdateChain;
import com.harrand.coreclasses.notification.structure.IStructureTracker;
import com.harrand.coreclasses.option.IOptionMgr;
import com.harrand.coreclasses.system.OsUtil;
import com.harrand.coregui.Icons;
import com.harrand.coregui.dialog.CloseDialog;
import com.harrand.coregui.display.status.IStatusDisplayer;
import com.harrand.coregui.helper.GuiMessageHelper;
import com.harrand.coregui.jdesktop.swingworker.IThreadObserver;
import com.harrand.coregui.jdesktop.swingworker.SwingWorker;
import com.harrand.coregui.panel.XpHeaderPanel;
import com.harrand.dbwrench.jdbc.ConnMgr;
import com.harrand.dbwrench.jdbc.JdbcConfig;
import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrench.object.LookupUtil;
import com.harrand.dbwrench.script.JdbcScriptCtrl;
import com.harrand.dbwrench.script.ScriptMgr;
import com.harrand.dbwrench.script.TransactionCtrl;
import com.harrand.dbwrench.script.builder.DatabaseScriptBuilder;
import com.harrand.dbwrench.security.App;
import com.harrand.dbwrench.security.DbUser;
import com.harrand.dbwrenchgui.db.TransactionErrorPanel;
import com.harrand.dbwrenchgui.db.worker.meta.SqlScriptWorker;
import com.harrand.dbwrenchgui.sub.editor.DbwEditor;
import com.harrand.dbwrenchnb.server.display.FadingStatusPanel;
import com.harrand.dbwrenchnb.server.forward.ForEngCtrl;
import com.harrand.dbwrenchnb.server.forward.ForEngLogger;
import com.harrand.dbwrenchnb.server.forward.IScriptClient;
import com.harrand.nb8.topComponent.tools.Bundle;
import com.harrand.util.FileHelper;
import com.harrand.util.MathUtil;
import com.harrand.util.ResMgr;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.MissingResourceException;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.border.Border;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

@TopComponent.Description(preferredID="ForwardEngineerTopComponent", iconBase="com/harrand/nb8/topComponent/tools/ForEngEc16.gif", persistenceType=0)
public final class ForwardEngineerTopComponent
extends TopComponent
implements IObserver,
IScriptClient,
IThreadObserver {
    private final DbwEditor editor = new DbwEditor();
    private final ForEngCtrl forEngCtrl_ = ForEngCtrl.getInstance();
    private final ScriptMgr scriptMgr_ = ScriptMgr.getInstance();
    private final JdbcScriptCtrl scriptCtrl_ = new JdbcScriptCtrl();
    private final ForEngLogger forEngLogger_;
    private final IScript emptyScript_ = DatabaseScriptBuilder.getEmptyScript();
    private IStep displayStep_ = this.emptyScript_;
    private final FadingStatusPanel statusDisplayer = new FadingStatusPanel(0);
    private final JButton btnRecalcScript_ = new JButton(ResMgr.getRes((String)"recalculate.script.label"));
    private final JButton btnRun_ = new JButton("Run Script");
    private final JButton btnToFile_ = new JButton(ResMgr.getRes((String)"save.to.file"));
    private Database db_ = null;
    private final JdbcConfig lastCfg_ = null;
    private final DbUser user_ = App.getUser();
    private final IFileUseMgr fileUseMgr_ = App.getFileUseMgr();
    private final IOptionMgr forEngOptMgr_;
    private final CentralLookup centralLookup_ = CentralLookup.getDefault();
    private final ConnMgr connMgr_ = ConnMgr.getInstance();
    private File lastExportFile_;
    public static final String TITLE = "Script Viewer";
    public static final String RECALC_STR = "Recalculate";
    public static final String RUN_SCRIPT_STR = "Run Script";
    public static final String CANCEL_STR = "Cancel";
    public static final int RECALC_ID = 0;
    public static final int RUN_SCRIPT_ID = 1;
    public static final int CANCEL_ID = 2;

    public ForwardEngineerTopComponent() {
        this.initComponents();
        this.setName(Bundle.CTL_ForwardEngineerTopComponent());
        this.setToolTipText(Bundle.HINT_ForwardEngineerTopComponent());
        this.buildControls();
        this.buildPanel();
        this.addListeners();
        this.setCosmetics();
        this.forEngLogger_ = ForEngLogger.getInstance();
        this.connMgr_.addObserver((IObserver)this);
        this.centralLookup_.addObserver((IObserver)this);
        this.scriptMgr_.addObserver((IObserver)this);
        this.forEngCtrl_.addObserver((IObserver)this);
        this.scriptCtrl_.addObserver((IObserver)this);
        this.forEngLogger_.setScriptCtrl(this.scriptCtrl_);
        this.forEngOptMgr_ = this.user_.getOptionMgr("forward.engineer.option.mgr");
        this.forEngCtrl_.setStatusDisplayer((IStatusDisplayer)this.statusDisplayer);
        this.forEngCtrl_.setDisabledButton(this.btnRecalcScript_);
        this.editor.setEditable(false);
    }

    public void setDisplayStep(IStep step) {
        this.displayStep_ = step;
        String text = this.getStepText(step);
        this.editor.setText(text);
    }

    public void setSingleStep(IStep step) {
        BasicStep newStep = new BasicStep(step.getName(), step.getExecuteObject().toString());
        if (step.getComment() != null) {
            newStep.setComment(step.getComment());
        }
        BasicScript wrapScript = new BasicScript(newStep.getName());
        wrapScript.add((ISortable)newStep);
        this.setDisplayStep((IStep)wrapScript);
    }

    public static String getTitle() throws MissingResourceException {
        return NbBundle.getMessage(ForwardEngineerTopComponent.class, (String)"CTL_ForwardEngineerTopComponent");
    }

    private void checkConfigChanged() {
        JdbcConfig currentCfg = this.getConfig();
        if (!MathUtil.isEquivalent((Object)currentCfg, (Object)this.lastCfg_)) {
            this.clear();
        }
    }

    private void checkDisplayStepChanged() {
        IStep newStep = this.scriptMgr_.getSelectedStep();
        if (!newStep.equals(this.displayStep_)) {
            this.setDisplayStep(newStep);
        }
    }

    private void checkDbChanged() {
        if (LookupUtil.hasDbChanged((Database)this.db_)) {
            if (this.db_ != null) {
                this.db_.removeStructureTracker((IStructureTracker)this.scriptCtrl_);
            }
            this.clear();
        }
    }

    private void displayResultMsg(ITestResult calcResult) {
        if (!calcResult.getPassed()) {
            GuiMessageHelper.showInputErrMsg(null, (ITestResult)calcResult);
        }
    }

    private IScript getExecutableScript() {
        IScript script;
        if (this.displayStep_ instanceof IScript) {
            script = (IScript)this.displayStep_;
        } else {
            script = new BasicScript("containing script");
            script.setLogEntry("");
            script.add((ISortable)this.displayStep_);
        }
        return script;
    }

    private String getStepText(IStep step) {
        String text = step instanceof IScript ? this.scriptCtrl_.asRunnableText((IScript)step) : step.getExecuteObject().toString() + ";";
        return text;
    }

    private void addListeners() {
        this.btnRecalcScript_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ForwardEngineerTopComponent.this.recalculate();
            }
        });
        this.btnRun_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ForwardEngineerTopComponent.this.execScript();
            }
        });
        this.btnToFile_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ForwardEngineerTopComponent.this.saveAsFile();
            }
        });
    }

    private void clear() {
        this.scriptMgr_.setFullScript(this.emptyScript_);
        this.scriptMgr_.setSelectedStep((IStep)this.emptyScript_);
    }

    private JdbcConfig getConfig() {
        return this.connMgr_.getCurrentCfg();
    }

    public void recalculate() {
        JdbcConfig config = this.getConfig();
        IScript comparingScript = DatabaseScriptBuilder.getComparingScript();
        this.scriptMgr_.setFullScript(comparingScript);
        this.scriptMgr_.setSelectedStep((IStep)comparingScript);
        this.db_ = this.getLookupDb();
        if (this.db_ != null) {
            this.db_.addStructureTracker((IStructureTracker)this.scriptCtrl_);
            this.forEngCtrl_.setDisabledButton(this.btnRecalcScript_);
            this.forEngCtrl_.startRecalculate(config, (IScriptClient)this, this.db_);
        } else {
            GuiMessageHelper.showWarningMsg(null, (String)"No Database Design Open", (String)"Please open or create a database design before recalculating a script");
        }
    }

    private void buildControls() {
        this.editor.setEditable(false);
    }

    private void buildPanel() {
        this.layoutPanel();
    }

    private void layoutPanel() {
        this.setLayout(new BorderLayout());
        int gap = 5;
        this.add(this.getHeaderPanel(), "North");
        this.add(this.getCenterPanel(), "Center");
    }

    private JPanel getHeaderPanel() {
        XpHeaderPanel header = new XpHeaderPanel("Forward Engineer Script", "Forward engineer database design changes to a server");
        return header;
    }

    private JPanel getCenterPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)this.editor, "Center");
        panel.add((Component)this.getSouthPanel(), "South");
        return panel;
    }

    private JPanel getSouthPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.add(new JSeparator());
        panel.add(this.getBtnPanel());
        return panel;
    }

    private JPanel getBtnPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        panel.add((Component)this.statusDisplayer);
        panel.add(Box.createGlue());
        panel.add(this.btnRecalcScript_);
        panel.add(Box.createHorizontalStrut(5));
        panel.add(this.btnRun_);
        panel.add(Box.createHorizontalStrut(5));
        panel.add(this.btnToFile_);
        Border border = BorderFactory.createEmptyBorder(5, 10, 5, 10);
        panel.setBorder(border);
        return panel;
    }

    private Database getLookupDb() {
        return (Database)this.centralLookup_.lookup(Database.class);
    }

    private void setCosmetics() {
        this.setIcon(Icons.TO_SERVER.getImage());
        this.btnRun_.setToolTipText(ResMgr.getRes((String)"tooltip.script.start"));
        this.btnToFile_.setToolTipText(ResMgr.getRes((String)"save.script.to.file.tooltip"));
        this.btnRecalcScript_.setToolTipText(this.btnRecalcScript_.getText());
        this.btnRecalcScript_.setMnemonic(82);
        this.btnRun_.setMnemonic(83);
        this.btnToFile_.setMnemonic(65);
        if (!OsUtil.isMacOs()) {
            this.btnRecalcScript_.setIcon(Icons.SCRIPT_CALC);
            this.btnRun_.setIcon(Icons.START);
            this.btnToFile_.setIcon(Icons.SAVE_AS);
        }
    }

    private void execScript() {
        JdbcConfig config = this.getConfig();
        if (config != null && config.isGeneric()) {
            String msg = StrHelper.getGenericCfgMsg((String)"execute a script");
            GuiMessageHelper.showWarningMsg(null, (String)"Forward Engineer", (String)msg);
            return;
        }
        if (this.confirmStart()) {
            this.forEngLogger_.clear();
            config = ConnMgr.getInstance().getCurrentCfg();
            boolean useTxn = this.forEngOptMgr_ != null ? this.forEngOptMgr_.getBoolValue("forward.engineer.z.use.transactions") : false;
            this.scriptCtrl_.setUseTransaction(useTxn);
            IScript executableScript = this.getExecutableScript();
            SqlScriptWorker scriptWorker = new SqlScriptWorker();
            scriptWorker.setSvrStatusBar((IStatusDisplayer)this.statusDisplayer);
            scriptWorker.setDisabledButton(this.btnRun_);
            scriptWorker.startScript(config, (IScriptCtrl)this.scriptCtrl_, executableScript, (IThreadObserver)this);
        }
    }

    private ITestResult checkRollback() {
        DataEntryResult result = new DataEntryResult(true, "Transaction Check OK");
        TransactionCtrl txnCtrl = this.scriptCtrl_.getTransactionCtrl();
        if (txnCtrl.getIsInRollback()) {
            this.showRollbackMsg(txnCtrl);
            result = new DataEntryResult(false, "Rollback Occured", "Rollback Occured");
        }
        return result;
    }

    private void showRollbackMsg(TransactionCtrl txnCtrl) {
        if (txnCtrl.getIsInRollback() && !txnCtrl.getUserAlerted()) {
            TransactionErrorPanel errPanel = new TransactionErrorPanel(txnCtrl.getErrMsg(), txnCtrl.getSqlStr());
            CloseDialog dlg = new CloseDialog(null, true, (JPanel)errPanel);
            dlg.setVisible(true);
            txnCtrl.setUserAlerted(true);
        }
    }

    private boolean confirmStart() {
        boolean yesHit;
        if (this.displayStep_.getName().equals(this.emptyScript_.getName())) {
            GuiMessageHelper.showWarningMsg(null, (String)"No Script to Run", (String)"No script has been generated. \nUse the Recalculate button to generate a script.");
            return false;
        }
        boolean wasExecOk = true;
        IScript script = this.getExecutableScript();
        ITestResult wasExecResult = this.forEngCtrl_.getWasExecuted(this.displayStep_);
        if (wasExecResult.getPassed() && !(yesHit = GuiMessageHelper.showYesNoMsgDefaultNo(null, (String)wasExecResult.getSummary(), (String)wasExecResult.getDetail()))) {
            wasExecOk = false;
        }
        if (!wasExecOk) {
            return false;
        }
        boolean dbModifiedOk = true;
        ITestResult dbModifiedResult = this.scriptCtrl_.getDbStuctureModified();
        if (dbModifiedResult.getPassed()) {
            int dbModifiedResponse = this.promptRecalc(dbModifiedResult);
            if (dbModifiedResponse == 0) {
                dbModifiedOk = false;
                this.recalculate();
            } else if (dbModifiedResponse == 2) {
                dbModifiedOk = false;
            }
        }
        if (!dbModifiedOk) {
            return false;
        }
        String warnBackupStr = this.forEngCtrl_.getBackupWarningStr(this.getConfig(), this.getExecutableScript(), this.db_.getName());
        String title = App.getRes((String)"engineer.forward.confirm.title");
        boolean warnBackupOk = GuiMessageHelper.showYesNoMsg(null, (String)title, (String)warnBackupStr);
        return warnBackupOk;
    }

    private int promptRecalc(ITestResult inputResult) {
        Frame parentFrame = GuiMessageHelper.getDefaultParent();
        Object[] options = new Object[]{RECALC_STR, RUN_SCRIPT_STR, CANCEL_STR};
        int response = 2;
        try {
            response = JOptionPane.showOptionDialog(parentFrame, inputResult.getDetail(), inputResult.getSummary(), 1, 3, null, options, RECALC_STR);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return response;
    }

    private void saveAsFile() {
        File defaultFile = null;
        defaultFile = this.lastExportFile_ != null ? this.lastExportFile_ : (this.fileUseMgr_ != null ? this.fileUseMgr_.getDefaultFile("SqlScript", null) : new File(""));
        File destFile = GuiMessageHelper.promptForSaveFile((File)defaultFile);
        if (destFile != null) {
            this.exportFile(destFile);
        }
    }

    public void exportFile(File destFile) {
        FileHelper.saveStringToFile((String)this.editor.getText(), (File)destFile);
        this.lastExportFile_ = destFile;
        this.fileUseMgr_.addRecentFile("SqlScript", this.lastExportFile_, true);
    }

    public void update(UpdateChain chain) {
        if (chain.hasClassName(ConnMgr.class.getName())) {
            this.checkConfigChanged();
        }
        if (LookupUtil.isDbLookupUpdate((UpdateChain)chain)) {
            this.checkDbChanged();
        }
        if (chain.hasClassName(ScriptMgr.class.getName())) {
            this.checkDisplayStepChanged();
        }
    }

    public void threadDone(SwingWorker threadWorker) {
        if (this.checkRollback().getPassed()) {
            this.forEngCtrl_.checkDbSynced(this.getConfig(), this.db_);
            this.recalculate();
        }
        this.displayStep_.setWasExecuted(true);
    }

    public void setForEngScript(IScript newScript) {
        ITestResult calcResult = this.forEngCtrl_.getRecalculateResult();
        this.displayResultMsg(calcResult);
        this.scriptMgr_.setFullScript(newScript);
        this.scriptMgr_.setSelectedStep((IStep)newScript);
        this.scriptCtrl_.setDbStructureModified(false);
    }

    private void initComponents() {
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 400, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 300, Short.MAX_VALUE));
    }

    public void componentOpened() {
    }

    public void componentClosed() {
    }

    void writeProperties(Properties p) {
        p.setProperty("version", "1.0");
    }

    void readProperties(Properties p) {
        String version = p.getProperty("version");
    }
}

