/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.nb8.topComponent.tools;

import com.harrand.coreclasses.dataEntry.IChildComponent;
import com.harrand.coreclasses.doc.IDocCtrl;
import com.harrand.coreclasses.interfaces.IStorable;
import com.harrand.coreclasses.nb.CentralLookup;
import com.harrand.coreclasses.notification.IObserver;
import com.harrand.coreclasses.notification.UpdateChain;
import com.harrand.coreclasses.option.BooleanOption;
import com.harrand.coreclasses.option.IOption;
import com.harrand.coreclasses.option.IOptionMgr;
import com.harrand.coregui.display.SwingThemeCtrl;
import com.harrand.coregui.display.status.IStatusDisplayer;
import com.harrand.coregui.helper.GuiHelper;
import com.harrand.coregui.helper.GuiMessageHelper;
import com.harrand.coregui.jdesktop.swingworker.IThreadObserver;
import com.harrand.coregui.jdesktop.swingworker.SwingWorker;
import com.harrand.coregui.panel.XpHeaderPanel;
import com.harrand.dbwrench.doc.DbDocCtrl;
import com.harrand.dbwrench.doc.DbDocOptionMgr;
import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrench.object.LookupUtil;
import com.harrand.dbwrenchgui.doc.DocGenWorker;
import com.harrand.dbwrenchnb.server.display.FadingStatusPanel;
import com.harrand.nb8.topComponent.tools.Bundle;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;
import org.openide.windows.TopComponent;

@TopComponent.Description(preferredID="DbDocTopComponent", iconBase="com/harrand/nb8/topComponent/tools/DbDocEc16.gif", persistenceType=0)
public final class DbDocTopComponent
extends TopComponent
implements IObserver,
IChildComponent,
IStorable,
IThreadObserver {
    private DbDocCtrl docCtrl_;
    private RootPaneContainer parentContainer_;
    private IOptionMgr optionMgr_;
    private String lastMileStone_ = "";
    private Database db_ = null;
    private String boolName_ = BooleanOption.clazz();
    private JButton btnCreate_ = new JButton("Create Documentation");
    private JButton btnFolder_ = new JButton("...");
    private JButton btnClear_ = new JButton("Clear");
    private JTextField txtFolder_ = new JTextField();
    private Map chkBoxesMap_ = new TreeMap();
    private DefaultListModel listModel_ = new DefaultListModel();
    private CentralLookup centralLookup_ = CentralLookup.getDefault();
    private JList lstProgress_ = new JList(this.listModel_);
    private FadingStatusPanel statusDisplayer = new FadingStatusPanel(0);
    private JLabel lblFolder_;
    private JScrollPane scrList_;
    private ActionListener lisOptionChk_;
    private SwingThemeCtrl themeCtrl_;
    public static final String CLAZZ = "DocCtrlPanel";
    public static final String TITLE = "Documentation";

    public DbDocTopComponent() {
        this.initComponents();
        this.setName(Bundle.CTL_DbDocTopComponent());
        this.setToolTipText(Bundle.HINT_DbDocTopComponent());
        this.buildControls();
        this.themeCtrl_ = SwingThemeCtrl.getDefaultCtrlInstance();
        this.setupGui();
        this.lookupDb();
        this.initDocCtrl();
        this.centralLookup_.addObserver((IObserver)this);
    }

    private void setupGui() {
        this.setLayout(new BoxLayout((Container)((Object)this), 1));
        this.add(this.getHeaderPanel());
        this.add(this.getMainPanel());
        this.buildListeners();
        this.setCosmetics();
        this.setNames();
        this.addListeners();
    }

    private JPanel getMainPanel() {
        JPanel mainPanel = new JPanel(new BorderLayout(4, 4));
        mainPanel.add((Component)this.getNorthPanel(), "North");
        mainPanel.add((Component)this.getProgressPanel(), "Center");
        mainPanel.add((Component)this.getCreateBtnPanel(), "South");
        GuiHelper.addEmptyBorder((JComponent)mainPanel);
        return mainPanel;
    }

    private JPanel getHeaderPanel() {
        XpHeaderPanel header = new XpHeaderPanel("Database Documentaion", this.getToolTipText());
        return header;
    }

    private void initDocCtrl() {
        this.docCtrl_ = new DbDocCtrl(this.db_);
        this.docCtrl_.addObserver((IObserver)this);
        this.loadOptionMgr();
        this.refreshFolderText();
        this.loadChkBoxData();
    }

    private void enableBtns() {
        boolean dbSet = this.isDbSet();
        this.btnFolder_.setEnabled(dbSet);
        this.btnCreate_.setEnabled(dbSet);
        if (dbSet) {
            this.btnFolder_.setToolTipText("Specify Folder for Documentation Files");
            this.btnCreate_.setToolTipText("Create Documentation HTML Files");
        } else {
            this.btnFolder_.setToolTipText("No Database Open");
            this.btnCreate_.setToolTipText("No Database Open");
        }
    }

    private boolean isDbSet() {
        return this.db_ != null;
    }

    private void loadOptionMgr() {
        this.optionMgr_ = this.isDbSet() ? this.db_.getDocOptionMgr() : null;
    }

    private void refreshCtrlMsgs() {
        String newMileStone = this.docCtrl_.getMilestone();
        if (!newMileStone.equals(this.lastMileStone_)) {
            this.lastMileStone_ = newMileStone;
            this.listModel_.addElement(this.lastMileStone_);
        }
        this.statusDisplayer.setStatusMsg(this.docCtrl_.getStatus());
        this.scrollLast();
    }

    private void refreshFolderText() {
        File folder = this.docCtrl_.getFolder();
        String text = folder != null ? folder.getAbsolutePath() : "<no database open>";
        this.txtFolder_.setText(text);
    }

    private void buildControls() {
        String div = "";
        this.lblFolder_ = new JLabel("Folder" + div);
        this.scrList_ = new JScrollPane(this.lstProgress_);
    }

    private void buildListeners() {
        this.lisOptionChk_ = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JCheckBox chkBox = (JCheckBox)e.getSource();
                String optionName = chkBox.getName();
                DbDocTopComponent.this.docCtrl_.setFolder(new File(DbDocTopComponent.this.txtFolder_.getText()));
                if (DbDocTopComponent.this.optionMgr_ != null) {
                    DbDocTopComponent.this.optionMgr_.setBoolValue(optionName, chkBox.isSelected());
                }
            }
        };
    }

    private void loadChkBoxData() {
        for (JCheckBox chkBox : this.chkBoxesMap_.values()) {
            chkBox.removeActionListener(this.lisOptionChk_);
            boolean selected = this.optionMgr_ != null ? this.optionMgr_.getBoolValue(chkBox.getName()) : true;
            chkBox.setSelected(selected);
            chkBox.addActionListener(this.lisOptionChk_);
        }
    }

    private JPanel getNorthPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.add(this.getFolderPanel());
        panel.add(Box.createVerticalStrut(4));
        panel.add(this.getEntitesPanel());
        return panel;
    }

    private JPanel getFolderPanel() {
        JPanel panel = new JPanel();
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        panel.setLayout(gbl);
        int row = 0;
        GuiHelper.buildGridBagConstraints((GridBagConstraints)gbc, (int)0, (int)row, (int)1, (int)1, (double)10.0, (double)0.0);
        gbc.fill = 0;
        gbc.anchor = 17;
        panel.add((Component)this.lblFolder_, gbc);
        GuiHelper.buildGridBagConstraints((GridBagConstraints)gbc, (int)1, (int)row, (int)1, (int)1, (double)80.0, (double)0.0);
        gbc.fill = 2;
        panel.add((Component)this.txtFolder_, gbc);
        GuiHelper.buildGridBagConstraints((GridBagConstraints)gbc, (int)2, (int)row, (int)1, (int)1, (double)10.0, (double)0.0);
        gbc.fill = 0;
        panel.add((Component)this.btnFolder_, gbc);
        GuiHelper.buildGridBagConstraints((GridBagConstraints)gbc, (int)1, (int)(++row), (int)1, (int)1, (double)10.0, (double)0.0);
        gbc.fill = 0;
        this.createCheckBox("doc.overwrite.css");
        JCheckBox chkCss = (JCheckBox)this.chkBoxesMap_.get("doc.overwrite.css");
        panel.add((Component)chkCss, gbc);
        GuiHelper.setTitledBorderBuffered((JComponent)panel, (String)"Destination Folder");
        return panel;
    }

    private JPanel getEntitesPanel() {
        JPanel panel = new JPanel(new GridLayout(3, 3));
        this.addCheckBox(panel, "doc.tables");
        this.addCheckBox(panel, "doc.schemas");
        this.addCheckBox(panel, "doc.fks");
        this.addCheckBox(panel, "doc.procs");
        this.addCheckBox(panel, "doc.indexes");
        this.addCheckBox(panel, "doc.triggers");
        this.addCheckBox(panel, "doc.diagrams");
        this.addCheckBox(panel, "doc.views");
        this.addCheckBox(panel, "doc.sequences");
        int stdThick = 5;
        Border emptyBorder = BorderFactory.createEmptyBorder(2, 25, stdThick, stdThick);
        TitledBorder titledBorder = BorderFactory.createTitledBorder("Entities To Document");
        CompoundBorder compBorder = BorderFactory.createCompoundBorder(titledBorder, emptyBorder);
        panel.setBorder(compBorder);
        return panel;
    }

    private void addCheckBox(JPanel panel, String optionNm) {
        this.createCheckBox(optionNm);
        JCheckBox chkBox = (JCheckBox)this.chkBoxesMap_.get(optionNm);
        panel.add(chkBox);
    }

    private String createCheckBox(String optionName) {
        DbDocOptionMgr optionMgrLocal = new DbDocOptionMgr(null);
        IOption option = optionMgrLocal.getOption(this.boolName_, optionName);
        String display = option.getLabel();
        JCheckBox chk = new JCheckBox(display);
        chk.setName(optionName);
        chk.addActionListener(this.lisOptionChk_);
        this.chkBoxesMap_.put(optionName, chk);
        return display;
    }

    private JPanel getProgressPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout(4, 4));
        panel.add((Component)this.scrList_, "Center");
        GuiHelper.setTitledBorderBuffered((JComponent)panel, (String)"Log");
        return panel;
    }

    private JPanel getCreateBtnPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        panel.add((Component)this.statusDisplayer);
        panel.add(Box.createHorizontalGlue());
        panel.add(this.btnCreate_);
        return panel;
    }

    private void setCosmetics() {
        this.setMinimumSize(new Dimension(200, 200));
    }

    private void setNames() {
        this.setName(TITLE);
        this.btnFolder_.setName("btnFolder");
        this.btnCreate_.setName("btnCreate");
        this.btnClear_.setName("btnClear");
        this.txtFolder_.setName("txtFolder");
        this.lstProgress_.setName("lstProgress");
        this.btnCreate_.setMnemonic('D');
        this.btnClear_.setMnemonic('L');
    }

    private void addListeners() {
        this.btnFolder_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DbDocTopComponent.this.promptFolder();
            }
        });
        this.btnCreate_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DbDocTopComponent.this.createDocs();
            }
        });
    }

    private void clear() {
        this.listModel_.clear();
    }

    private void promptFolder() {
        File file;
        JFileChooser chooser = new JFileChooser();
        chooser.setCurrentDirectory(new File(this.txtFolder_.getText()));
        chooser.setDialogTitle("Select Documentation Folder");
        chooser.setFileSelectionMode(1);
        int state = chooser.showDialog(GuiMessageHelper.getDefaultParent(), "Select Folder");
        File file2 = file = state == 0 ? chooser.getSelectedFile() : null;
        if (file != null) {
            this.txtFolder_.setText(file.getAbsolutePath());
        }
    }

    private void scrollLast() {
        JScrollBar vBar = this.scrList_.getVerticalScrollBar();
        vBar.setValue(vBar.getMaximum());
    }

    private void scrollLastDisp() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DbDocTopComponent.this.scrollLast();
            }
        });
    }

    private void createDocs() {
        this.clear();
        this.docCtrl_.setFolder(new File(this.txtFolder_.getText()));
        DocGenWorker worker = new DocGenWorker();
        worker.setDisabledButton(this.btnCreate_);
        worker.setStatusDisplayer((IStatusDisplayer)this.statusDisplayer);
        worker.startDocCreation(this.docCtrl_, (IThreadObserver)this);
    }

    public void update(UpdateChain chain) {
        if (chain.hasInteface(IDocCtrl.class.getName())) {
            this.refreshCtrlMsgs();
        }
        if (chain.hasClassName(CentralLookup.class.getName()) || chain.hasClassName(Database.class.getName())) {
            this.updateDb();
        }
    }

    private void updateDb() {
        this.lookupDb();
        this.clear();
        this.docCtrl_.setDatabase(this.db_);
        this.loadOptionMgr();
        this.refreshFolderText();
        this.enableBtns();
        this.loadChkBoxData();
    }

    private void lookupDb() {
        this.db_ = LookupUtil.findDb();
    }

    public String getTitle() {
        return TITLE;
    }

    public String getToolTip() {
        return "Create Database Documentation";
    }

    private void addParentListeners() {
        if (this.parentContainer_ != null) {
            GuiHelper.addContainerCancelAction((RootPaneContainer)this.parentContainer_);
        }
    }

    public void setParentContainer(RootPaneContainer parentContainer) {
        this.parentContainer_ = parentContainer;
        this.addParentListeners();
    }

    public String getStorageName() {
        return CLAZZ;
    }

    public void threadDone(SwingWorker threadWorker) {
        this.scrollLastDisp();
    }

    private void initComponents() {
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 400, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 300, Short.MAX_VALUE));
    }

    public void componentOpened() {
    }

    public void componentClosed() {
    }

    void writeProperties(Properties p) {
        p.setProperty("version", "1.0");
    }

    void readProperties(Properties p) {
        String version = p.getProperty("version");
    }
}

