/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.nb8.topComponent.test;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.text.AttributeSet;
import javax.swing.text.Element;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.text.StyledEditorKit;

class ForegroundAction
extends StyledEditorKit.StyledTextAction {
    private static final long serialVersionUID = 6384632651737400352L;
    JColorChooser colorChooser = new JColorChooser();
    JDialog dialog = new JDialog();
    boolean noChange = false;
    boolean cancelled = false;
    private Color fg;

    public ForegroundAction() {
        super("foreground");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JTextPane editor = (JTextPane)this.getEditor(e);
        if (editor == null) {
            JOptionPane.showMessageDialog(null, "You need to select the editor pane before you can change the color.", "Error", 0);
            return;
        }
        int p0 = editor.getSelectionStart();
        StyledDocument doc = this.getStyledDocument(editor);
        Element paragraph = doc.getCharacterElement(p0);
        AttributeSet as = paragraph.getAttributes();
        this.fg = StyleConstants.getForeground(as);
        if (this.fg == null) {
            this.fg = Color.BLACK;
        }
        this.colorChooser.setColor(this.fg);
        JButton accept = new JButton("OK");
        accept.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                ForegroundAction.this.fg = ForegroundAction.this.colorChooser.getColor();
                ForegroundAction.this.dialog.dispose();
            }
        });
        JButton cancel = new JButton("Cancel");
        cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                ForegroundAction.this.cancelled = true;
                ForegroundAction.this.dialog.dispose();
            }
        });
        JButton none = new JButton("None");
        none.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                ForegroundAction.this.noChange = true;
                ForegroundAction.this.dialog.dispose();
            }
        });
        JPanel buttons = new JPanel();
        buttons.add(accept);
        buttons.add(none);
        buttons.add(cancel);
        this.dialog.getContentPane().setLayout(new BorderLayout());
        this.dialog.getContentPane().add((Component)this.colorChooser, "Center");
        this.dialog.getContentPane().add((Component)buttons, "South");
        this.dialog.setModal(true);
        this.dialog.pack();
        this.dialog.setVisible(true);
        if (!this.cancelled) {
            SimpleAttributeSet attr = null;
            if (editor != null && this.fg != null && !this.noChange) {
                attr = new SimpleAttributeSet();
                StyleConstants.setForeground(attr, this.fg);
                this.setCharacterAttributes(editor, attr, false);
            }
        }
        this.noChange = false;
        this.cancelled = false;
    }
}

