/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.nb8.topComponent.explorer;

import com.harrand.coreclasses.interfaces.IScript;
import com.harrand.coreclasses.interfaces.IStep;
import com.harrand.coreclasses.interfaces.implementation.BasicScript;
import com.harrand.coreclasses.interfaces.implementation.BasicStep;
import com.harrand.coreclasses.nb.CentralLookup;
import com.harrand.coreclasses.notification.IObserver;
import com.harrand.coreclasses.notification.UpdateChain;
import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrench.object.LookupUtil;
import com.harrand.dbwrench.script.ScriptMgr;
import com.harrand.dbwrench.script.builder.DatabaseScriptBuilder;
import com.harrand.dbwrenchnb.nb.NodeExpansionMgr;
import com.harrand.dbwrenchnb.server.forward.tree.ScriptNbNode;
import com.harrand.nb8.topComponent.explorer.Bundle;
import com.harrand.util.ResMgr;
import java.awt.Color;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.Properties;
import javax.swing.ActionMap;
import javax.swing.GroupLayout;
import javax.swing.JScrollPane;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerUtils;
import org.openide.explorer.view.BeanTreeView;
import org.openide.explorer.view.TreeView;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.Utilities;
import org.openide.windows.TopComponent;

@TopComponent.Description(preferredID="ScriptExplorerTopComponent", iconBase="com/harrand/nb8/topComponent/explorer/ScriptCalcEc15.gif", persistenceType=0)
public final class ScriptExplorerTopComponent
extends TopComponent
implements ExplorerManager.Provider,
IObserver,
LookupListener {
    private ExplorerManager mgr_ = new ExplorerManager();
    private ScriptMgr scriptMgr_ = ScriptMgr.getInstance();
    private CentralLookup centralLookup_ = CentralLookup.getDefault();
    private Database db_ = null;
    private IScript fullScript_ = null;
    private NodeExpansionMgr expansionMgr_;
    private Lookup.Result lookupResultStep_ = null;
    private Lookup.Result lookupResultScript_ = null;
    public static final String PREFERRED_ID = "ScriptExplorerTopComponent";
    private JScrollPane jScrollPane1;

    public ScriptExplorerTopComponent() {
        this.initComponents();
        this.setName(Bundle.CTL_ScriptExplorerTopComponent());
        this.setToolTipText(Bundle.HINT_ScriptExplorerTopComponent());
        this.expansionMgr_ = new NodeExpansionMgr((TreeView)this.jScrollPane1);
        this.setFullScript(DatabaseScriptBuilder.getEmptyScript());
        this.scriptMgr_.addObserver((IObserver)this);
        this.centralLookup_.addObserver((IObserver)this);
        this.associateLookup(ExplorerUtils.createLookup((ExplorerManager)this.mgr_, (ActionMap)this.getActionMap()));
        this.addLookupListeners();
        this.jScrollPane1.setBackground(Color.WHITE);
    }

    public void paintComponent(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        g2d.setPaint(Color.WHITE);
        g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
    }

    public void setFullScript(IScript script) {
        this.fullScript_ = script;
        this.storeExpanded();
        this.storeSelectedNode();
        this.mgr_.setRootContext((Node)new ScriptNbNode(this.fullScript_));
        this.reExpand();
        if (!this.isEmptyScript(script)) {
            this.requestActive();
        }
        this.selectLastNode();
    }

    public ExplorerManager getExplorerManager() {
        return this.mgr_;
    }

    public void update(UpdateChain chain) {
        if (chain.hasClassName(ScriptMgr.class.getName())) {
            this.checkFullScript();
        }
        if (LookupUtil.isDbLookupUpdate((UpdateChain)chain)) {
            this.checkDbChanged();
            this.db_ = LookupUtil.getLookupDb();
        }
    }

    private void addLookupListeners() {
        this.addScriptLookupListener();
        this.addStepLookupListener();
    }

    private void addStepLookupListener() {
        Lookup.Template tplStep = new Lookup.Template(BasicStep.class);
        this.lookupResultStep_ = Utilities.actionsGlobalContext().lookup(tplStep);
        this.lookupResultStep_.addLookupListener(new LookupListener(){

            public void resultChanged(LookupEvent ev) {
                Object obj = LookupUtil.getFirstInstance((LookupEvent)ev);
                if (obj instanceof IStep) {
                    IStep step = (IStep)obj;
                    ScriptExplorerTopComponent.this.scriptMgr_.setSelectedStep(step);
                }
            }
        });
    }

    private void addScriptLookupListener() {
        Lookup.Template tplScript = new Lookup.Template(BasicScript.class);
        this.lookupResultScript_ = Utilities.actionsGlobalContext().lookup(tplScript);
        this.lookupResultScript_.addLookupListener(new LookupListener(){

            public void resultChanged(LookupEvent ev) {
                Object obj = LookupUtil.getFirstInstance((LookupEvent)ev);
                if (obj instanceof IScript) {
                    IScript script = (IScript)obj;
                    ScriptExplorerTopComponent.this.scriptMgr_.setSelectedStep((IStep)script);
                }
            }
        });
    }

    public void resultChanged(LookupEvent ev) {
        Object obj = LookupUtil.getFirstInstance((LookupEvent)ev);
        if (obj instanceof IStep) {
            IStep step = (IStep)obj;
            this.scriptMgr_.setSelectedStep(step);
        }
    }

    private void checkDbChanged() {
        if (LookupUtil.hasDbChanged((Database)this.db_)) {
            this.clear();
        }
    }

    private void checkFullScript() {
        IScript mgrScript = this.scriptMgr_.getFullScript();
        if (!this.fullScript_.equals(mgrScript)) {
            this.setFullScript(mgrScript);
        }
    }

    private void clear() {
        this.setFullScript(DatabaseScriptBuilder.getEmptyScript());
    }

    private boolean isEmptyScript(IScript script) {
        String scpNm = script.getName();
        String emptyNm = ResMgr.getRes((String)"script.empty.label");
        return emptyNm.equals(scpNm);
    }

    private void reExpand() {
        Node root = this.mgr_.getRootContext();
        if (root != null && this.expansionMgr_ != null) {
            this.expansionMgr_.expandNodes(root);
        }
    }

    private void storeExpanded() {
        Node root = this.mgr_.getRootContext();
        if (root != null && this.expansionMgr_ != null && !this.isComparing()) {
            this.expansionMgr_.storeExpanded(root);
        }
    }

    private void storeSelectedNode() {
        if (!this.isComparing()) {
            Node[] selectedNodes = this.mgr_.getSelectedNodes();
            Node selectedNode = null;
            if (selectedNodes.length > 0) {
                selectedNode = selectedNodes[0];
            }
            this.expansionMgr_.storeLastSelectedPath(selectedNode);
        }
    }

    private void selectLastNode() {
        this.expansionMgr_.selectLastSelectedNode(this.mgr_);
    }

    private boolean isComparing() {
        Node root = this.mgr_.getRootContext();
        String comparingStr = "Comparing Databases...";
        boolean isComparing = root.getDisplayName().equals(comparingStr);
        return isComparing;
    }

    private void initComponents() {
        this.jScrollPane1 = new BeanTreeView();
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, GroupLayout.Alignment.TRAILING, -1, 400, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 300, Short.MAX_VALUE));
    }

    public void componentOpened() {
    }

    public void componentClosed() {
    }

    void writeProperties(Properties p) {
        p.setProperty("version", "1.0");
    }

    void readProperties(Properties p) {
        String version = p.getProperty("version");
    }
}

