/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.nb8.topComponent.explorer;

import com.harrand.coreclasses.dataEntry.DataEditor;
import com.harrand.coregui.display.ISpaceConservable;
import com.harrand.coregui.helper.GuiHelper;
import com.harrand.dbwrench.object.ForeignKey;
import com.harrand.dbwrench.object.Table;
import com.harrand.dbwrenchgui.panel.ForeignKeyPanel;
import com.harrand.dbwrenchgui.panel.TableDetailsPanel;
import com.harrand.dbwrenchnb.panel.EmptyPanel;
import com.harrand.dbwrenchnb.panel.detail.DetailLookupCtrl;
import com.harrand.dbwrenchnb.panel.detail.IDetailLookupPanel;
import com.harrand.nb8.topComponent.explorer.Bundle;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.util.Properties;
import javax.swing.GroupLayout;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.openide.awt.StatusDisplayer;
import org.openide.windows.TopComponent;

@TopComponent.Description(preferredID="ObjectDetailsTopComponent", persistenceType=0)
public final class ObjectDetailsTopComponent
extends TopComponent
implements IDetailLookupPanel {
    private static com.harrand.dbwrenchnb.panel.detail.ObjectDetailsTopComponent instance;
    private JPanel detailsPanel_;
    private JPanel lastPanel_;
    private final EmptyPanel emptyPanel_ = new EmptyPanel("No Details to View");
    private final DetailLookupCtrl lookupCtrl_;
    private static final String TITLE_PREFIX = "Object Details";

    public ObjectDetailsTopComponent() {
        this.initComponents();
        this.setName(Bundle.CTL_ObjectDetailsTopComponent());
        this.setToolTipText(Bundle.HINT_ObjectDetailsTopComponent());
        this.layoutPanel();
        this.lookupCtrl_ = new DetailLookupCtrl((IDetailLookupPanel)this);
    }

    public void setTitleSuffix(String suffix) {
        String fullStr;
        String string = fullStr = suffix != null ? "Object Details: " + suffix : TITLE_PREFIX;
        if (SwingUtilities.isEventDispatchThread()) {
            this.setName(fullStr);
        }
    }

    public void setDetailsPanel(JPanel panel) {
        this.detailsPanel_ = panel != null ? panel : this.emptyPanel_;
        this.loadDetailsPanel();
        this.redraw();
        this.lastPanel_ = this.detailsPanel_;
        if (SwingUtilities.isEventDispatchThread()) {
            this.requestVisible();
        }
    }

    public void setTblDetailsTab(String classNm, String cmdDisplayText) {
        if (this.lastPanel_ instanceof TableDetailsPanel) {
            this.lookupCtrl_.setTblDetailsTab(classNm);
            this.requestActive();
        } else {
            this.showTableSelectionReqMsg(cmdDisplayText);
        }
    }

    private void showTableSelectionReqMsg(String cmdDisplayText) {
        StatusDisplayer.getDefault().setStatusText("The " + cmdDisplayText + " command needs a table node or table glyph selected.");
    }

    private void layoutPanel() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.emptyPanel_, "Center");
    }

    private void loadDetailsPanel() {
        if (this.detailsPanel_ instanceof TableDetailsPanel && this.lastPanel_ instanceof TableDetailsPanel) {
            TableDetailsPanel oldTableDetailsPanel = (TableDetailsPanel)this.lastPanel_;
            TableDetailsPanel newTableDetailsPanel = (TableDetailsPanel)this.detailsPanel_;
            Table newTable = newTableDetailsPanel.getTable();
            oldTableDetailsPanel.setTable(newTable);
            this.detailsPanel_ = this.lastPanel_;
        } else if (this.detailsPanel_ instanceof ForeignKeyPanel && this.lastPanel_ instanceof ForeignKeyPanel) {
            ForeignKeyPanel oldFkPanel = (ForeignKeyPanel)this.lastPanel_;
            ForeignKeyPanel newFkPanel = (ForeignKeyPanel)this.detailsPanel_;
            ForeignKey newFk = newFkPanel.getForeignKey();
            oldFkPanel.setForeignKey(newFk);
            this.detailsPanel_ = this.lastPanel_;
        } else {
            this.addDetailsPanel();
        }
    }

    private void addDetailsPanel() {
        this.applyPanelSettings();
        this.removeAll();
        this.add(this.detailsPanel_, "Center");
        GuiHelper.addSmallBorder((JPanel)this.detailsPanel_);
    }

    private void applyPanelSettings() {
        if (this.detailsPanel_ instanceof DataEditor) {
            DataEditor dataEditor = (DataEditor)this.detailsPanel_;
            dataEditor.setSyncOnEdit(true);
        }
        if (this.detailsPanel_ instanceof ISpaceConservable) {
            ((ISpaceConservable)this.detailsPanel_).setConserveSpace(true);
        }
    }

    private void redraw() {
        this.invalidate();
        this.revalidate();
        this.repaint();
    }

    private void initComponents() {
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 400, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 300, Short.MAX_VALUE));
    }

    public void componentOpened() {
    }

    public void componentClosed() {
    }

    void writeProperties(Properties p) {
        p.setProperty("version", "1.0");
    }

    void readProperties(Properties p) {
        String version = p.getProperty("version");
    }
}

