/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.nb8.action.table;

import com.harrand.coregui.Icons;
import com.harrand.dbwrench.jdbc.ConnMgr;
import com.harrand.dbwrench.jdbc.JdbcConfig;
import com.harrand.dbwrench.object.LookupUtil;
import com.harrand.dbwrench.object.Table;
import com.harrand.dbwrench.sql.show.EShowSqlType;
import com.harrand.dbwrench.sql.show.ShowSqlCtrl;
import com.harrand.dbwrenchnb.nb.NbUtil;
import com.harrand.nb8.topComponent.tools.SqlCommunicatorTopComponent;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import org.openide.windows.TopComponent;

public final class ShowTableSqlAction
extends AbstractAction {
    private final ShowSqlCtrl showSqlCtrl;
    private final String actionDisplay;
    private final String title;
    private final EShowSqlType showSqlType;
    private SqlCommunicatorTopComponent editorTC;

    public ShowTableSqlAction(Table table, EShowSqlType showSqlType) {
        this.showSqlType = showSqlType;
        this.actionDisplay = "Show " + this.showSqlType + " SQL";
        this.title = this.showSqlType + " " + table.getName();
        JdbcConfig config = ConnMgr.getInstance().getCurrentCfg();
        this.showSqlCtrl = new ShowSqlCtrl(LookupUtil.getLookupDb(), config, table);
        this.putValue("Name", this.actionDisplay);
        this.putValue("ShortDescription", this.actionDisplay);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.show();
    }

    private void show() {
        String tcClassNm = SqlCommunicatorTopComponent.class.getName();
        TopComponent existingTc = NbUtil.findTopComponent((String)tcClassNm, (String)"unknownTitle");
        if (existingTc == null) {
            this.showNew();
        } else {
            existingTc.requestActive();
        }
    }

    private void showNew() {
        this.editorTC = new SqlCommunicatorTopComponent();
        this.setDisplay(this.editorTC);
        this.editorTC.open();
        this.setText();
        this.editorTC.requestActive();
    }

    private void setDisplay(TopComponent tc) {
        tc.setDisplayName(this.title);
        tc.setToolTipText(this.title);
        tc.setIcon(Icons.SCRIPT.getImage());
    }

    private void setText() {
        String sql = this.showSqlCtrl.getSql(this.showSqlType);
        this.editorTC.setText(sql);
    }
}

