/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.common.refactoring;

import java.util.Collection;
import org.netbeans.modules.refactoring.api.ui.ExplorerContext;
import org.netbeans.modules.refactoring.spi.ui.ActionsImplementationProvider;
import org.netbeans.modules.refactoring.spi.ui.RefactoringUI;
import org.netbeans.modules.refactoring.spi.ui.UI;
import org.netbeans.modules.web.common.refactoring.RenameRefactoringUI;
import org.netbeans.modules.web.common.spi.ProjectWebRootQuery;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.text.CloneableEditorSupport;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.windows.TopComponent;

public class FolderActionsImplementationProvider
extends ActionsImplementationProvider {
    public boolean canRename(Lookup lookup) {
        FileObject fo;
        Collection nodes = lookup.lookupAll(Node.class);
        if (nodes.size() != 1) {
            return false;
        }
        Node node = (Node)nodes.iterator().next();
        EditorCookie ec = FolderActionsImplementationProvider.getEditorCookie(node);
        if ((ec == null || !FolderActionsImplementationProvider.isFromEditor(ec)) && (fo = FolderActionsImplementationProvider.getFileObjectFromNode(node)) != null && fo.isValid() && fo.isFolder() && ProjectWebRootQuery.getWebRoot(fo) != null) {
            FileObject pom = fo.getFileObject("pom.xml");
            if (pom != null) {
                return false;
            }
            try {
                return !fo.getFileSystem().isReadOnly();
            }
            catch (FileStateInvalidException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return false;
    }

    public void doRename(Lookup selectedNodes) {
        Collection nodes = selectedNodes.lookupAll(Node.class);
        assert (nodes.size() == 1);
        Node node = (Node)nodes.iterator().next();
        FileObject file = FolderActionsImplementationProvider.getFileObjectFromNode(node);
        String newName = FolderActionsImplementationProvider.getName(selectedNodes);
        UI.openRefactoringUI((RefactoringUI)new RenameRefactoringUI(file, newName != null ? newName : file.getName()));
    }

    private static FileObject getFileObjectFromNode(Node node) {
        DataObject dobj = (DataObject)node.getLookup().lookup(DataObject.class);
        return dobj != null ? dobj.getPrimaryFile() : null;
    }

    private static boolean isFromEditor(final EditorCookie ec) {
        return (Boolean)Mutex.EVENT.readAccess((Mutex.Action)new Mutex.Action<Boolean>(){

            public Boolean run() {
                TopComponent activetc;
                if (ec != null && ec.getOpenedPanes() != null && (activetc = TopComponent.getRegistry().getActivated()) instanceof CloneableEditorSupport.Pane) {
                    return true;
                }
                return false;
            }
        });
    }

    private static EditorCookie getEditorCookie(Node node) {
        return (EditorCookie)node.getLookup().lookup(EditorCookie.class);
    }

    private static String getName(Lookup look) {
        ExplorerContext ren = (ExplorerContext)look.lookup(ExplorerContext.class);
        if (ren == null) {
            return null;
        }
        return ren.getNewName();
    }
}

