/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.common.api;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;

public final class UsageLogger {
    private final Logger logger;
    private final Class<?> srcClass;
    private final String message;
    private final boolean unrepeated;
    private final AtomicBoolean messageLogged = new AtomicBoolean();

    private UsageLogger(Builder builder) {
        assert (builder != null);
        assert (builder.loggerName != null);
        this.logger = Logger.getLogger(builder.loggerName);
        this.srcClass = builder.srcClass;
        this.message = builder.message;
        this.unrepeated = builder.unrepeated;
    }

    public void reset() {
        this.messageLogged.set(false);
    }

    public void log(Class<?> srcClass, String message, String ... params) {
        Parameters.notNull((CharSequence)"srcClass", srcClass);
        Parameters.notNull((CharSequence)"message", (Object)message);
        this.logInternal(srcClass, message, params);
    }

    public void log(String ... params) {
        if (this.srcClass == null) {
            throw new IllegalStateException("No srcClass set");
        }
        if (this.message == null) {
            throw new IllegalStateException("No message set");
        }
        this.logInternal(this.srcClass, this.message, params);
    }

    private void logInternal(Class<?> srcClass, String message, String ... params) {
        assert (srcClass != null);
        assert (message != null);
        if (!this.isLoggingEnabled()) {
            return;
        }
        LogRecord logRecord = new LogRecord(Level.INFO, message);
        logRecord.setLoggerName(this.logger.getName());
        logRecord.setResourceBundle(NbBundle.getBundle(srcClass));
        logRecord.setResourceBundleName(srcClass.getPackage().getName() + ".Bundle");
        logRecord.setParameters(params);
        this.logger.log(logRecord);
    }

    boolean isLoggingEnabled() {
        if (!this.unrepeated) {
            return true;
        }
        return this.messageLogged.compareAndSet(false, true);
    }

    public static UsageLogger projectBrowserUsageLogger(String loggerName) {
        return new Builder(loggerName).message(UsageLogger.class, "USG_PROJECT_BROWSER").unrepeated(true).create();
    }

    public static UsageLogger jsTestRunUsageLogger(String loggerName) {
        return new Builder(loggerName).message(UsageLogger.class, "USG_TEST_RUN_JS").unrepeated(true).create();
    }

    public static final class Builder {
        private final String loggerName;
        private Class<?> srcClass;
        private String message;
        private boolean unrepeated;

        public Builder(String loggerName) {
            Parameters.notNull((CharSequence)"loggerName", (Object)loggerName);
            this.loggerName = loggerName;
        }

        public Builder unrepeated(boolean unrepeated) {
            this.unrepeated = unrepeated;
            return this;
        }

        public Builder message(Class<?> srcClass, String message) {
            Parameters.notNull((CharSequence)"srcClass", srcClass);
            Parameters.notNull((CharSequence)"message", (Object)message);
            this.srcClass = srcClass;
            this.message = message;
            return this;
        }

        public UsageLogger create() {
            return new UsageLogger(this);
        }
    }
}

