/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.common.api;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import org.netbeans.modules.web.common.api.FileReferenceModification;
import org.netbeans.modules.web.common.api.FileReferenceType;
import org.netbeans.modules.web.common.api.WebUtils;
import org.openide.filesystems.FileObject;

public final class FileReference {
    static final String DESCENDING_PATH_ITEM = "..";
    private FileObject source;
    private FileObject target;
    private FileObject baseFolder;
    private String linkPath;
    private FileReferenceType type;

    FileReference(FileObject source, FileObject target, FileObject baseFolder, String linkPath, FileReferenceType type) {
        assert (baseFolder == null || baseFolder.isFolder());
        this.source = source;
        this.target = target;
        this.baseFolder = baseFolder;
        this.linkPath = linkPath;
        this.type = type;
    }

    public FileObject source() {
        return this.source;
    }

    public FileObject target() {
        return this.target;
    }

    public FileObject baseFolder() {
        return this.baseFolder;
    }

    public List<FileObject> sourcePathMembersToBase() {
        return this.type() == FileReferenceType.RELATIVE ? this.getPathMembersToBase(this.source()) : Collections.emptyList();
    }

    public List<FileObject> targetPathMembersToBase() {
        return this.getPathMembersToBase(this.target());
    }

    private List<FileObject> getPathMembersToBase(FileObject file) {
        if (this.baseFolder() == null) {
            return Collections.emptyList();
        }
        LinkedList<FileObject> members = new LinkedList<FileObject>();
        FileObject member = file;
        while ((member = member.getParent()) != null && !member.equals(this.baseFolder())) {
            members.add(0, member);
        }
        return members;
    }

    public String linkPath() {
        return this.linkPath;
    }

    public String optimizedLinkPath() {
        return this.type() == FileReferenceType.RELATIVE ? WebUtils.getRelativePath(this.source, this.target) : this.linkPath();
    }

    public FileReferenceType type() {
        return this.type;
    }

    public FileReferenceModification createModification() {
        LinkedHashMap<FileObject, String> items = new LinkedHashMap<FileObject, String>();
        List<FileObject> members = this.sourcePathMembersToBase();
        Collections.reverse(members);
        for (FileObject file : members) {
            items.put(file, DESCENDING_PATH_ITEM);
        }
        for (FileObject file : this.targetPathMembersToBase()) {
            items.put(file, file.getNameExt());
        }
        items.put(this.target, this.target.getNameExt());
        return new FileReferenceModification(items, this.type() == FileReferenceType.ABSOLUTE);
    }
}

