/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.xml.cookies;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import org.netbeans.api.xml.cookies.CookieMessage;
import org.netbeans.api.xml.cookies.CookieObserver;
import org.netbeans.api.xml.cookies.TransformableCookie;
import org.netbeans.api.xml.services.UserCatalog;
import org.netbeans.spi.xml.cookies.DefaultXMLProcessorDetail;
import org.netbeans.spi.xml.cookies.Util;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public final class TransformableSupport
implements TransformableCookie {
    private final Source source;
    private static TransformerFactory transformerFactory;

    public TransformableSupport(Source source) {
        if (source == null) {
            throw new NullPointerException();
        }
        this.source = source;
    }

    public void transform(Source transformSource, Result outputResult, CookieObserver notifier) throws TransformerException {
        try {
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("TransformableSupport.transform");
                Util.THIS.debug("   transformSource = " + transformSource.getSystemId());
                Util.THIS.debug("   outputResult = " + outputResult.getSystemId());
            }
            Source xmlSource = this.source;
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("   xmlSource = " + xmlSource.getSystemId());
            }
            Transformer transformer = TransformableSupport.newTransformer(transformSource);
            if (notifier != null) {
                ProtectionDomain domain = transformer.getClass().getProtectionDomain();
                CodeSource codeSource = domain.getCodeSource();
                if (codeSource == null) {
                    notifier.receive(new CookieMessage(Util.THIS.getString("BK000", transformer.getClass().getName())));
                } else {
                    URL location = codeSource.getLocation();
                    notifier.receive(new CookieMessage(Util.THIS.getString("BK001", location, transformer.getClass().getName())));
                }
                Proxy proxy = new Proxy(notifier);
                transformer.setErrorListener(proxy);
            }
            transformer.transform(xmlSource, outputResult);
        }
        catch (Exception exc) {
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("    EXCEPTION during transformation: " + exc.getClass().getName(), exc);
                Util.THIS.debug("    exception's message = " + exc.getLocalizedMessage());
                Throwable tempExc = TransformableSupport.unwrapException(exc);
                Util.THIS.debug("    wrapped exception = " + tempExc.getLocalizedMessage());
            }
            TransformerException transExcept = null;
            DefaultXMLProcessorDetail detail = null;
            if (exc instanceof TransformerException) {
                transExcept = (TransformerException)exc;
                if (notifier != null && exc instanceof TransformerConfigurationException) {
                    detail = new DefaultXMLProcessorDetail(transExcept);
                }
            } else if (exc instanceof SAXParseException) {
                transExcept = new TransformerException(exc);
                if (notifier != null) {
                    detail = new DefaultXMLProcessorDetail((SAXParseException)exc);
                }
            } else {
                transExcept = new TransformerException(exc);
                if (notifier != null) {
                    detail = new DefaultXMLProcessorDetail(transExcept);
                }
            }
            if (notifier != null && detail != null) {
                CookieMessage message = new CookieMessage(TransformableSupport.message(exc), 3, detail);
                notifier.receive(message);
            }
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("--> throw transExcept: " + transExcept);
            }
            throw transExcept;
        }
    }

    private static Throwable unwrapException(Throwable exc) {
        Throwable wrapped = null;
        if (exc instanceof TransformerException) {
            wrapped = ((TransformerException)exc).getException();
        } else if (exc instanceof SAXException) {
            wrapped = ((SAXException)exc).getException();
        } else {
            return exc;
        }
        if (wrapped == null) {
            return exc;
        }
        return TransformableSupport.unwrapException(wrapped);
    }

    private static URIResolver getURIResolver() {
        UserCatalog catalog = UserCatalog.getDefault();
        URIResolver res = catalog == null ? null : catalog.getURIResolver();
        return res;
    }

    private static TransformerFactory getTransformerFactory() {
        if (transformerFactory == null) {
            transformerFactory = TransformerFactory.newInstance();
            transformerFactory.setURIResolver(TransformableSupport.getURIResolver());
        }
        return transformerFactory;
    }

    private static Transformer newTransformer(Source xsl) throws TransformerConfigurationException {
        return TransformableSupport.getTransformerFactory().newTransformer(xsl);
    }

    private static String message(Throwable t) {
        String msg = t.getLocalizedMessage();
        return msg != null ? msg : new ExceptionWriter(t).toString();
    }

    private static class ExceptionWriter
    extends PrintWriter {
        private int counter = 4;
        private Throwable t;

        public ExceptionWriter(Throwable t) {
            super(new StringWriter());
            this.t = t;
        }

        public void println(String s) {
            if (this.counter-- > 0) {
                super.println(s);
            }
        }

        public void println(Object o) {
            if (this.counter-- > 0) {
                super.println(o);
            }
        }

        public String toString() {
            this.t.printStackTrace(this);
            this.flush();
            return ((StringWriter)this.out).getBuffer().toString();
        }
    }

    private static class Proxy
    implements ErrorListener {
        private final CookieObserver peer;

        public Proxy(CookieObserver peer) {
            if (peer == null) {
                throw new NullPointerException();
            }
            this.peer = peer;
        }

        public void error(TransformerException tex) throws TransformerException {
            this.report(2, tex);
        }

        public void fatalError(TransformerException tex) throws TransformerException {
            this.report(3, tex);
            throw tex;
        }

        public void warning(TransformerException tex) throws TransformerException {
            this.report(1, tex);
        }

        private void report(int level, TransformerException tex) throws TransformerException {
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("[TransformableSupport::Proxy]: report [" + level + "]: ", tex);
                Util.THIS.debug("    exception's message = " + tex.getLocalizedMessage());
                Throwable tempExc = TransformableSupport.unwrapException(tex);
                Util.THIS.debug("    wrapped exception = " + tempExc.getLocalizedMessage());
            }
            Throwable unwrappedExc = TransformableSupport.unwrapException(tex);
            CookieMessage message = new CookieMessage(TransformableSupport.message(unwrappedExc), level, new DefaultXMLProcessorDetail(tex));
            this.peer.receive(message);
        }
    }
}

