/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.runtime.arrays;

import java.util.Arrays;
import jdk.nashorn.internal.runtime.JSType;
import jdk.nashorn.internal.runtime.ScriptRuntime;
import jdk.nashorn.internal.runtime.arrays.ArrayData;
import jdk.nashorn.internal.runtime.arrays.DeletedRangeArrayFilter;
import jdk.nashorn.internal.runtime.arrays.LongArrayData;
import jdk.nashorn.internal.runtime.arrays.NumberArrayData;
import jdk.nashorn.internal.runtime.arrays.ObjectArrayData;
import jdk.nashorn.internal.runtime.arrays.SparseArrayData;
import jdk.nashorn.internal.runtime.arrays.UndefinedArrayFilter;

public final class IntArrayData
extends ArrayData {
    private int[] array;

    IntArrayData() {
        this(new int[16], 0);
    }

    IntArrayData(int length) {
        super(length);
        this.array = new int[ArrayData.nextSize(length)];
    }

    IntArrayData(int[] array, int length) {
        super(length);
        this.array = array;
        if (array.length > length) {
            Arrays.fill(array, length, array.length, 0);
        }
    }

    @Override
    public Object[] asObjectArray() {
        return IntArrayData.toObjectArray(this.array, (int)this.length());
    }

    @Override
    public Object asArrayOfType(Class<?> componentType) {
        if (componentType == Integer.TYPE) {
            return (long)this.array.length == this.length() ? (int[])this.array.clone() : Arrays.copyOf(this.array, (int)this.length());
        }
        return super.asArrayOfType(componentType);
    }

    private static Object[] toObjectArray(int[] array, int length) {
        Object[] oarray = new Object[length];
        for (int index = 0; index < length; ++index) {
            oarray[index] = array[index];
        }
        return oarray;
    }

    private static double[] toDoubleArray(int[] array) {
        double[] darray = new double[array.length];
        for (int index = 0; index < array.length; ++index) {
            darray[index] = array[index];
        }
        return darray;
    }

    private static long[] toLongArray(int[] array) {
        long[] larray = new long[array.length];
        for (int index = 0; index < array.length; ++index) {
            larray[index] = array[index];
        }
        return larray;
    }

    @Override
    public ArrayData convert(Class<?> type) {
        if (type == Integer.class) {
            return this;
        }
        if (type == Long.class) {
            return new LongArrayData(IntArrayData.toLongArray(this.array), (int)this.length());
        }
        if (type == Double.class) {
            return new NumberArrayData(IntArrayData.toDoubleArray(this.array), (int)this.length());
        }
        return new ObjectArrayData(IntArrayData.toObjectArray(this.array, this.array.length), (int)this.length());
    }

    @Override
    public void shiftLeft(int by) {
        System.arraycopy(this.array, by, this.array, 0, this.array.length - by);
    }

    @Override
    public ArrayData shiftRight(int by) {
        ArrayData newData = this.ensure((long)by + this.length() - 1L);
        if (newData != this) {
            newData.shiftRight(by);
            return newData;
        }
        System.arraycopy(this.array, 0, this.array, by, this.array.length - by);
        return this;
    }

    @Override
    public ArrayData ensure(long safeIndex) {
        if (safeIndex >= 524288L && safeIndex >= (long)this.array.length) {
            return new SparseArrayData(this, safeIndex + 1L);
        }
        int newLength = this.array.length;
        while ((long)newLength <= safeIndex) {
            newLength = ArrayData.nextSize(newLength);
        }
        if ((long)this.array.length <= safeIndex) {
            this.array = Arrays.copyOf(this.array, newLength);
        }
        this.setLength(safeIndex + 1L);
        return this;
    }

    @Override
    public ArrayData shrink(long newLength) {
        Arrays.fill(this.array, (int)newLength, this.array.length, 0);
        return this;
    }

    @Override
    public ArrayData set(int index, Object value, boolean strict) {
        try {
            int intValue;
            this.array[index] = intValue = ((Integer)value).intValue();
            this.setLength(Math.max((long)(index + 1), this.length()));
            return this;
        }
        catch (ClassCastException | NullPointerException e) {
            if (value instanceof Short || value instanceof Byte) {
                int intValue;
                this.array[index] = intValue = ((Number)value).intValue();
                this.setLength(Math.max((long)(index + 1), this.length()));
                return this;
            }
            if (value == ScriptRuntime.UNDEFINED) {
                return new UndefinedArrayFilter(this).set(index, value, strict);
            }
            ArrayData newData = this.convert(value == null ? Object.class : value.getClass());
            return newData.set(index, value, strict);
        }
    }

    @Override
    public ArrayData set(int index, int value, boolean strict) {
        this.array[index] = value;
        this.setLength(Math.max((long)(index + 1), this.length()));
        return this;
    }

    @Override
    public ArrayData set(int index, long value, boolean strict) {
        int intValue = (int)value;
        if ((long)intValue == value) {
            this.array[index] = intValue;
            this.setLength(Math.max((long)(index + 1), this.length()));
            return this;
        }
        return this.convert(Long.class).set(index, value, strict);
    }

    @Override
    public ArrayData set(int index, double value, boolean strict) {
        if (JSType.isRepresentableAsInt(value)) {
            this.array[index] = (int)value;
            this.setLength(Math.max((long)(index + 1), this.length()));
            return this;
        }
        return this.convert(Double.class).set(index, value, strict);
    }

    @Override
    public int getInt(int index) {
        return this.array[index];
    }

    @Override
    public long getLong(int index) {
        return this.array[index];
    }

    @Override
    public double getDouble(int index) {
        return this.array[index];
    }

    @Override
    public Object getObject(int index) {
        return this.array[index];
    }

    @Override
    public boolean has(int index) {
        return 0 <= index && (long)index < this.length();
    }

    @Override
    public ArrayData delete(int index) {
        return new DeletedRangeArrayFilter(this, index, index);
    }

    @Override
    public ArrayData delete(long fromIndex, long toIndex) {
        return new DeletedRangeArrayFilter(this, fromIndex, toIndex);
    }

    @Override
    public Object pop() {
        if (this.length() == 0L) {
            return ScriptRuntime.UNDEFINED;
        }
        int newLength = (int)this.length() - 1;
        int elem = this.array[newLength];
        this.array[newLength] = 0;
        this.setLength(newLength);
        return elem;
    }

    @Override
    public ArrayData slice(long from, long to) {
        long start = from < 0L ? from + this.length() : from;
        long newLength = to - start;
        return new IntArrayData(Arrays.copyOfRange(this.array, (int)from, (int)to), (int)newLength);
    }
}

