/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.runtime;

import java.lang.invoke.MethodHandle;
import jdk.nashorn.internal.runtime.Property;
import jdk.nashorn.internal.runtime.PropertyMap;
import jdk.nashorn.internal.runtime.ScriptFunction;
import jdk.nashorn.internal.runtime.ScriptObject;
import jdk.nashorn.internal.runtime.linker.Lookup;

public final class UserAccessorProperty
extends Property {
    private final int getterSlot;
    private final int setterSlot;

    public UserAccessorProperty(String key, int flags, int getterSlot, int setterSlot) {
        super(key, flags);
        this.getterSlot = getterSlot;
        this.setterSlot = setterSlot;
    }

    private UserAccessorProperty(UserAccessorProperty property) {
        super(property);
        this.getterSlot = property.getterSlot;
        this.setterSlot = property.setterSlot;
    }

    public int getGetterSlot() {
        return this.getterSlot < 0 ? -this.getterSlot - 1 : this.getterSlot;
    }

    public int getSetterSlot() {
        return this.setterSlot < 0 ? -this.setterSlot - 1 : this.setterSlot;
    }

    @Override
    protected Property copy() {
        return new UserAccessorProperty(this);
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof UserAccessorProperty) {
            UserAccessorProperty uc = (UserAccessorProperty)other;
            return super.equals(other) && this.getterSlot == uc.getterSlot && this.setterSlot == uc.setterSlot;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.getterSlot ^ this.setterSlot;
    }

    @Override
    public int getSpillCount() {
        int count = 0;
        if (this.getGetterSlot() >= 4) {
            ++count;
        }
        if (this.getSetterSlot() >= 4) {
            ++count;
        }
        return count;
    }

    @Override
    public boolean hasGetterFunction() {
        return this.getterSlot > -1;
    }

    @Override
    public boolean hasSetterFunction() {
        return this.setterSlot > -1;
    }

    @Override
    public MethodHandle getGetter(Class<?> type) {
        return Lookup.filterReturnType(ScriptObject.USER_ACCESSOR_GETTER.methodHandle(), type);
    }

    @Override
    public ScriptFunction getGetterFunction(ScriptObject obj) {
        Object value = obj.getEmbedOrSpill(this.getterSlot);
        return value instanceof ScriptFunction ? (ScriptFunction)value : null;
    }

    @Override
    public MethodHandle getSetter(Class<?> type, PropertyMap currentMap) {
        return ScriptObject.USER_ACCESSOR_SETTER.methodHandle();
    }

    @Override
    public ScriptFunction getSetterFunction(ScriptObject obj) {
        Object value = obj.getEmbedOrSpill(this.setterSlot);
        return value instanceof ScriptFunction ? (ScriptFunction)value : null;
    }
}

