/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.runtime;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import jdk.nashorn.internal.ir.FunctionNode;
import jdk.nashorn.internal.parser.Token;
import jdk.nashorn.internal.parser.TokenType;
import jdk.nashorn.internal.runtime.PropertyMap;
import jdk.nashorn.internal.runtime.ScriptFunction;
import jdk.nashorn.internal.runtime.Source;
import jdk.nashorn.internal.runtime.linker.Lookup;

public class ScriptFunctionData {
    private static final int IS_STRICT = 1;
    private static final int IS_BUILTIN = 2;
    private static final int HAS_CALLEE = 4;
    private static final int IS_VARARGS = 8;
    private final String name;
    private final Source source;
    private PropertyMap allocatorMap;
    private final long token;
    private int arity;
    private final int flags;
    private MethodHandle invoker;
    private MethodHandle constructor;
    private MethodHandle allocator;
    private MethodHandle genericInvoker;
    private MethodHandle genericConstructor;
    private MethodHandle[] invokeSpecializations;
    private MethodHandle[] constructSpecializations;

    public ScriptFunctionData(FunctionNode fn, PropertyMap allocatorMap) {
        long firstToken = fn.getFirstToken();
        long lastToken = fn.getLastToken();
        int position = Token.descPosition(firstToken);
        int length = Token.descPosition(lastToken) - position + Token.descLength(lastToken);
        this.name = fn.isAnonymous() ? "" : fn.getIdent().getName();
        this.source = fn.getSource();
        this.allocatorMap = allocatorMap;
        this.token = Token.toDesc(TokenType.FUNCTION, position, length);
        this.arity = fn.getParameters().size();
        this.flags = ScriptFunctionData.makeFlags(fn.needsCallee(), fn.isVarArg(), fn.isStrictMode(), false);
    }

    public ScriptFunctionData(String name, MethodHandle methodHandle, MethodHandle[] specs, boolean strict, boolean builtin) {
        this.name = name;
        this.source = null;
        this.token = 0L;
        MethodType type = methodHandle.type();
        int paramCount = type.parameterCount();
        boolean isVarArg = ((Class)type.parameterType(paramCount - 1)).isArray();
        boolean needsCallee = ScriptFunctionData.needsCallee(methodHandle);
        this.flags = ScriptFunctionData.makeFlags(needsCallee, isVarArg, strict, builtin);
        int n = this.arity = isVarArg ? -1 : paramCount - 1;
        if (needsCallee && !isVarArg) {
            --this.arity;
        }
        if (ScriptFunctionData.isConstructor(methodHandle)) {
            if (!isVarArg) {
                --this.arity;
            }
            this.invoker = Lookup.MH.insertArguments(methodHandle, 0, false);
            this.constructor = Lookup.MH.insertArguments(methodHandle, 0, true);
            if (specs != null) {
                this.invokeSpecializations = new MethodHandle[specs.length];
                this.constructSpecializations = new MethodHandle[specs.length];
                for (int i = 0; i < specs.length; ++i) {
                    this.invokeSpecializations[i] = Lookup.MH.insertArguments(specs[i], 0, false);
                    this.constructSpecializations[i] = Lookup.MH.insertArguments(specs[i], 0, true);
                }
            }
        } else {
            this.invoker = methodHandle;
            this.constructor = methodHandle;
            this.invokeSpecializations = specs;
            this.constructSpecializations = specs;
        }
    }

    public int getArity() {
        return this.arity;
    }

    public void setArity(int arity) {
        this.arity = arity;
    }

    public String getName() {
        return this.name;
    }

    public Source getSource() {
        return this.source;
    }

    public String toSource() {
        if (this.source != null && this.token != 0L) {
            return this.source.getString(Token.descPosition(this.token), Token.descLength(this.token));
        }
        return "function " + (this.name == null ? "" : this.name) + "() { [native code] }";
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString()).append(" [ ").append(this.invoker).append(", ").append(this.name == null || this.name.isEmpty() ? "<anonymous>" : this.name);
        if (this.source != null) {
            sb.append(" @ ").append(this.source.getName()).append(':').append(this.source.getLine(Token.descPosition(this.token)));
        }
        sb.append(" ]");
        return sb.toString();
    }

    public PropertyMap getAllocatorMap() {
        return this.allocatorMap;
    }

    public long getToken() {
        return this.token;
    }

    public boolean needsCallee() {
        return (this.flags & 4) != 0;
    }

    public boolean isStrict() {
        return (this.flags & 1) != 0;
    }

    public boolean isBuiltin() {
        return (this.flags & 2) != 0;
    }

    public boolean isVarArg() {
        return (this.flags & 8) != 0;
    }

    public boolean needsWrappedThis() {
        return (this.flags & 3) == 0;
    }

    public MethodHandle getInvoker() {
        return this.invoker;
    }

    public MethodHandle getConstructor() {
        return this.constructor;
    }

    public void setConstructor(MethodHandle constructor) {
        this.constructor = constructor;
        this.constructSpecializations = null;
    }

    public MethodHandle getAllocator() {
        return this.allocator;
    }

    public MethodHandle getGenericInvoker() {
        if (this.genericInvoker == null) {
            assert (this.invoker != null) : "invoker is null";
            this.genericInvoker = this.adaptMethodType(this.invoker);
        }
        return this.genericInvoker;
    }

    public MethodHandle getGenericConstructor() {
        if (this.genericConstructor == null) {
            assert (this.constructor != null) : "constructor is null";
            this.genericConstructor = this.adaptMethodType(this.constructor);
        }
        return this.genericConstructor;
    }

    public MethodHandle[] getInvokeSpecializations() {
        return this.invokeSpecializations;
    }

    public MethodHandle[] getConstructSpecializations() {
        return this.constructSpecializations;
    }

    public void setMethodHandles(MethodHandle invoker, MethodHandle allocator) {
        if (this.invoker == null) {
            this.invoker = invoker;
            this.constructor = invoker;
            this.allocator = allocator;
        }
    }

    private static int makeFlags(boolean needsCallee, boolean isVarArg, boolean isStrict, boolean isBuiltin) {
        int flags = 0;
        if (needsCallee) {
            flags |= 4;
        }
        if (isVarArg) {
            flags |= 8;
        }
        if (isStrict) {
            flags |= 1;
        }
        if (isBuiltin) {
            flags |= 2;
        }
        return flags;
    }

    private static boolean isConstructor(MethodHandle methodHandle) {
        return methodHandle.type().parameterCount() >= 1 && methodHandle.type().parameterType(0) == Boolean.TYPE;
    }

    private static boolean needsCallee(MethodHandle methodHandle) {
        MethodType type = methodHandle.type();
        int len = type.parameterCount();
        if (len == 0) {
            return false;
        }
        if (type.parameterType(0) == Boolean.TYPE) {
            return len > 2 && type.parameterType(2) == ScriptFunction.class;
        }
        return len > 1 && type.parameterType(1) == ScriptFunction.class;
    }

    private MethodHandle adaptMethodType(MethodHandle handle) {
        MethodType type = handle.type();
        MethodType newType = type.generic();
        if (this.isVarArg()) {
            newType = newType.changeParameterType(type.parameterCount() - 1, Object[].class);
        }
        if (this.needsCallee()) {
            newType = newType.changeParameterType(1, ScriptFunction.class);
        }
        return type.equals((Object)newType) ? handle : handle.asType(newType);
    }
}

