/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.objects;

import jdk.nashorn.internal.objects.ArrayBufferView;
import jdk.nashorn.internal.objects.Global;
import jdk.nashorn.internal.objects.NativeArrayBuffer;
import jdk.nashorn.internal.objects.annotations.Constructor;
import jdk.nashorn.internal.objects.annotations.Function;
import jdk.nashorn.internal.objects.annotations.ScriptClass;
import jdk.nashorn.internal.runtime.ScriptObject;
import jdk.nashorn.internal.runtime.arrays.ArrayData;

@ScriptClass(value="Uint16Array")
public class NativeUint16Array
extends ArrayBufferView {
    private static final int BYTES_PER_ELEMENT = 2;
    private static final ArrayBufferView.Factory FACTORY = new ArrayBufferView.Factory(2){

        @Override
        public ArrayBufferView construct(NativeArrayBuffer buffer, int byteOffset, int length) {
            return new NativeUint16Array(buffer, byteOffset, length);
        }

        @Override
        public ArrayData createArrayData(NativeArrayBuffer buffer, int byteOffset, int length) {
            return new Uint16ArrayData(buffer, byteOffset, length);
        }
    };

    @Constructor(arity=1)
    public static Object constructor(boolean newObj, Object self, Object ... args) {
        return NativeUint16Array.constructorImpl(args, FACTORY);
    }

    NativeUint16Array(NativeArrayBuffer buffer, int byteOffset, int length) {
        super(buffer, byteOffset, length);
    }

    @Override
    protected ArrayBufferView.Factory factory() {
        return FACTORY;
    }

    @Function(attributes=2)
    protected static Object set(Object self, Object array, Object offset) {
        return ArrayBufferView.setImpl(self, array, offset);
    }

    @Function(attributes=2)
    protected static Object subarray(Object self, Object begin, Object end) {
        return ArrayBufferView.subarrayImpl(self, begin, end);
    }

    @Override
    protected ScriptObject getPrototype() {
        return Global.instance().getUint16ArrayPrototype();
    }

    private static final class Uint16ArrayData
    extends ArrayBufferView.ArrayDataImpl {
        private Uint16ArrayData(NativeArrayBuffer buffer, int byteOffset, int elementLength) {
            super(buffer, byteOffset, elementLength);
        }

        @Override
        protected int byteIndex(int index) {
            return index * 2 + this.byteOffset;
        }

        @Override
        protected int getIntImpl(int index) {
            int byteIndex = this.byteIndex(index);
            byte[] byteArray = this.buffer.getByteArray();
            return byteArray[byteIndex] & 0xFF | byteArray[byteIndex + 1] << 8 & 0xFF00;
        }

        @Override
        protected void setImpl(int index, int value) {
            int byteIndex = this.byteIndex(index);
            byte[] byteArray = this.buffer.getByteArray();
            byteArray[byteIndex] = (byte)(value & 0xFF);
            byteArray[byteIndex + 1] = (byte)(value >>> 8 & 0xFF);
        }
    }
}

