/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.objects;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.text.NumberFormat;
import java.util.Locale;
import jdk.nashorn.internal.objects.Global;
import jdk.nashorn.internal.objects.annotations.Constructor;
import jdk.nashorn.internal.objects.annotations.Function;
import jdk.nashorn.internal.objects.annotations.Property;
import jdk.nashorn.internal.objects.annotations.ScriptClass;
import jdk.nashorn.internal.objects.annotations.Where;
import jdk.nashorn.internal.runtime.ECMAErrors;
import jdk.nashorn.internal.runtime.JSType;
import jdk.nashorn.internal.runtime.ScriptObject;
import jdk.nashorn.internal.runtime.ScriptRuntime;
import jdk.nashorn.internal.runtime.linker.Lookup;
import jdk.nashorn.internal.runtime.linker.MethodHandleFactory;
import jdk.nashorn.internal.runtime.linker.PrimitiveLookup;
import org.dynalang.dynalink.linker.GuardedInvocation;
import org.dynalang.dynalink.linker.LinkRequest;

@ScriptClass(value="Number")
public final class NativeNumber
extends ScriptObject {
    static final MethodHandle WRAPFILTER = NativeNumber.findWrapFilter();
    @Property(attributes=7, where=Where.CONSTRUCTOR)
    public static final double MAX_VALUE = Double.MAX_VALUE;
    @Property(attributes=7, where=Where.CONSTRUCTOR)
    public static final double MIN_VALUE = Double.MIN_VALUE;
    @Property(attributes=7, where=Where.CONSTRUCTOR)
    public static final double NaN = Double.NaN;
    @Property(attributes=7, where=Where.CONSTRUCTOR)
    public static final double NEGATIVE_INFINITY = Double.NEGATIVE_INFINITY;
    @Property(attributes=7, where=Where.CONSTRUCTOR)
    public static final double POSITIVE_INFINITY = Double.POSITIVE_INFINITY;
    private final double value;
    private final boolean isInt;
    private final boolean isLong;

    NativeNumber(double value) {
        this(value, Global.instance().getNumberPrototype());
    }

    private NativeNumber(double value, ScriptObject proto) {
        this.value = value;
        this.isInt = JSType.isRepresentableAsInt(value);
        this.isLong = JSType.isRepresentableAsLong(value);
        this.setProto(proto);
    }

    @Override
    public String safeToString() {
        return "[Number " + this.toString() + "]";
    }

    public String toString() {
        return Double.toString(this.getValue());
    }

    public double getValue() {
        return this.doubleValue();
    }

    public double doubleValue() {
        return this.value;
    }

    public int intValue() throws ClassCastException {
        if (this.isInt) {
            return (int)this.value;
        }
        throw new ClassCastException();
    }

    public long longValue() throws ClassCastException {
        if (this.isLong) {
            return (long)this.value;
        }
        throw new ClassCastException();
    }

    @Override
    public String getClassName() {
        return "Number";
    }

    @Constructor(arity=1)
    public static Object constructor(boolean newObj, Object self, Object ... args) {
        double num;
        double d = num = args.length > 0 ? JSType.toNumber(args[0]) : 0.0;
        if (newObj) {
            ScriptObject proto = self instanceof ScriptObject ? ((ScriptObject)self).getProto() : Global.instance().getNumberPrototype();
            return new NativeNumber(num, proto);
        }
        return num;
    }

    @Function(attributes=2)
    public static Object toFixed(Object self, Object fractionDigits) {
        int f = JSType.toInteger(fractionDigits);
        if (f < 0 || f > 20) {
            ECMAErrors.rangeError("invalid.fraction.digits", "toFixed");
            return ScriptRuntime.UNDEFINED;
        }
        double x = NativeNumber.getNumberValue(self);
        if (Double.isNaN(x)) {
            return "NaN";
        }
        if (Math.abs(x) >= 1.0E21) {
            return JSType.toString(x);
        }
        NumberFormat format = NumberFormat.getNumberInstance(Locale.US);
        format.setMinimumFractionDigits(f);
        format.setMaximumFractionDigits(f);
        format.setGroupingUsed(false);
        return format.format(x);
    }

    @Function(attributes=2)
    public static Object toExponential(Object self, Object fractionDigits) {
        int f;
        double x = NativeNumber.getNumberValue(self);
        boolean trimZeros = fractionDigits == ScriptRuntime.UNDEFINED;
        int n = f = trimZeros ? 16 : JSType.toInteger(fractionDigits);
        if (Double.isNaN(x)) {
            return "NaN";
        }
        if (Double.isInfinite(x)) {
            return x > 0.0 ? "Infinity" : "-Infinity";
        }
        if (fractionDigits != ScriptRuntime.UNDEFINED && (f < 0 || f > 20)) {
            ECMAErrors.rangeError("invalid.fraction.digits", "toExponential");
            return ScriptRuntime.UNDEFINED;
        }
        String res = String.format(Locale.US, "%1." + f + "e", x);
        return NativeNumber.fixExponent(res, trimZeros);
    }

    @Function(attributes=2)
    public static Object toPrecision(Object self, Object precision) {
        double x = NativeNumber.getNumberValue(self);
        if (precision == ScriptRuntime.UNDEFINED) {
            return JSType.toString(x);
        }
        int p = JSType.toInteger(precision);
        if (Double.isNaN(x)) {
            return "NaN";
        }
        if (Double.isInfinite(x)) {
            return x > 0.0 ? "Infinity" : "-Infinity";
        }
        if (p < 1 || p > 21) {
            ECMAErrors.rangeError("invalid.precision", new String[0]);
            return ScriptRuntime.UNDEFINED;
        }
        if (x == 0.0 && p <= 1) {
            return "0";
        }
        return NativeNumber.fixExponent(String.format(Locale.US, "%." + p + "g", x), false);
    }

    @Function(attributes=2)
    public static Object toString(Object self, Object radix) {
        int intRadix;
        if (radix != ScriptRuntime.UNDEFINED && (intRadix = JSType.toInteger(radix)) != 10) {
            if (intRadix < 2 || intRadix > 36) {
                ECMAErrors.rangeError("invalid.radix", new String[0]);
            }
            return JSType.toString(NativeNumber.getNumberValue(self), intRadix);
        }
        return JSType.toString(NativeNumber.getNumberValue(self));
    }

    @Function(attributes=2)
    public static Object toLocaleString(Object self) {
        return JSType.toString(NativeNumber.getNumberValue(self));
    }

    @Function(attributes=2)
    public static Object valueOf(Object self) {
        return NativeNumber.getNumberValue(self);
    }

    public static GuardedInvocation lookupPrimitive(LinkRequest request, Object receiver) {
        return PrimitiveLookup.lookupPrimitive(request, Number.class, (ScriptObject)new NativeNumber(((Number)receiver).doubleValue()), WRAPFILTER);
    }

    private static NativeNumber wrapFilter(Object receiver) {
        return new NativeNumber(((Number)receiver).doubleValue());
    }

    private static double getNumberValue(Object self) {
        if (self instanceof Number) {
            return ((Number)self).doubleValue();
        }
        if (self instanceof NativeNumber) {
            return ((NativeNumber)self).getValue();
        }
        if (self != null && self == Global.instance().getNumberPrototype()) {
            return 0.0;
        }
        ECMAErrors.typeError("not.a.number", ScriptRuntime.safeToString(self));
        return Double.NaN;
    }

    private static String fixExponent(String str, boolean trimZeros) {
        int index = str.indexOf(101);
        if (index < 1) {
            return str;
        }
        int expPadding = str.charAt(index + 2) == '0' ? 3 : 2;
        int fractionOffset = index;
        if (trimZeros) {
            assert (fractionOffset > 0);
            char c = str.charAt(fractionOffset - 1);
            while (fractionOffset > 1 && (c == '0' || c == '.')) {
                c = str.charAt(--fractionOffset - 1);
            }
        }
        if (fractionOffset < index || expPadding == 3) {
            return str.substring(0, fractionOffset) + str.substring(index, index + 2) + str.substring(index + expPadding);
        }
        return str;
    }

    private static MethodHandle findWrapFilter() {
        try {
            return MethodHandles.lookup().findStatic(NativeNumber.class, "wrapFilter", Lookup.MH.type(NativeNumber.class, Object.class));
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new MethodHandleFactory.LookupException(e);
        }
    }
}

