/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.ir;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import jdk.nashorn.internal.codegen.CompileUnit;
import jdk.nashorn.internal.codegen.MethodEmitter;
import jdk.nashorn.internal.ir.FunctionNode;
import jdk.nashorn.internal.ir.Node;
import jdk.nashorn.internal.ir.annotations.Ignore;
import jdk.nashorn.internal.ir.annotations.Reference;
import jdk.nashorn.internal.ir.visitor.NodeVisitor;

public class SplitNode
extends Node {
    private final String name;
    private CompileUnit compileUnit;
    private MethodEmitter method;
    private MethodEmitter caller;
    @Reference
    private final FunctionNode functionNode;
    @Ignore
    private final List<MethodEmitter.Label> externalTargets;
    private boolean hasReturn;
    @Ignore
    private Node body;

    public SplitNode(String name, FunctionNode functionNode, Node body) {
        super(body.getSource(), body.getToken(), body.getFinish());
        this.name = name;
        this.functionNode = functionNode;
        this.body = body;
        this.externalTargets = new ArrayList<MethodEmitter.Label>();
    }

    private SplitNode(SplitNode splitNode, Node.CopyState cs) {
        super(splitNode);
        this.name = splitNode.name;
        this.functionNode = (FunctionNode)cs.existingOrSame(splitNode.functionNode);
        this.body = cs.existingOrCopy(splitNode.body);
        this.externalTargets = new ArrayList<MethodEmitter.Label>();
    }

    @Override
    protected Node copy(Node.CopyState cs) {
        return new SplitNode(this, cs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Node accept(NodeVisitor visitor) {
        CompileUnit saveCompileUnit = visitor.getCurrentCompileUnit();
        MethodEmitter saveMethod = visitor.getCurrentMethodEmitter();
        this.setCaller(saveMethod);
        visitor.setCurrentCompileUnit(this.getCompileUnit());
        visitor.setCurrentMethodEmitter(this.getMethodEmitter());
        try {
            if (visitor.enter(this) != null) {
                this.body = this.body.accept(visitor);
                Node node = visitor.leave(this);
                return node;
            }
        }
        finally {
            visitor.setCurrentCompileUnit(saveCompileUnit);
            visitor.setCurrentMethodEmitter(saveMethod);
        }
        return this;
    }

    @Override
    public void toString(StringBuilder sb) {
        sb.append("<split>(");
        sb.append(this.compileUnit.getClass().getSimpleName());
        sb.append(") ");
        this.body.toString(sb);
    }

    public MethodEmitter getCaller() {
        return this.caller;
    }

    public void setCaller(MethodEmitter caller) {
        this.caller = caller;
    }

    public String getName() {
        return this.name;
    }

    public CompileUnit getCompileUnit() {
        return this.compileUnit;
    }

    public void setCompileUnit(CompileUnit compileUnit) {
        this.compileUnit = compileUnit;
    }

    public MethodEmitter getMethodEmitter() {
        return this.method;
    }

    public void setMethodEmitter(MethodEmitter method) {
        this.method = method;
    }

    public FunctionNode getFunctionNode() {
        return this.functionNode;
    }

    public List<MethodEmitter.Label> getExternalTargets() {
        return Collections.unmodifiableList(this.externalTargets);
    }

    public void addExternalTarget(MethodEmitter.Label targetLabel) {
        this.externalTargets.add(targetLabel);
    }

    public boolean hasReturn() {
        return this.hasReturn;
    }

    public void setHasReturn(boolean hasReturn) {
        this.hasReturn = hasReturn;
    }
}

