/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.ir;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import jdk.nashorn.internal.codegen.types.Type;
import jdk.nashorn.internal.ir.BinaryNode;
import jdk.nashorn.internal.ir.Node;
import jdk.nashorn.internal.ir.TypeOverride;
import jdk.nashorn.internal.ir.UnaryNode;
import jdk.nashorn.internal.ir.visitor.NodeVisitor;
import jdk.nashorn.internal.parser.TokenType;
import jdk.nashorn.internal.runtime.Source;

public class RuntimeNode
extends Node
implements TypeOverride {
    private final Request request;
    private final List<Node> args;
    private Type callSiteType;
    private boolean isFinal;

    public RuntimeNode(Source source, long token, int finish, Request request, List<Node> args) {
        super(source, token, finish);
        this.request = request;
        this.args = args;
    }

    public RuntimeNode(Source source, long token, int finish, Request request, Node ... args) {
        this(source, token, finish, request, Arrays.asList(args));
    }

    public RuntimeNode(Node parent, Request request, Node ... args) {
        this(parent, request, Arrays.asList(args));
    }

    public RuntimeNode(Node parent, Request request, List<Node> args) {
        super(parent);
        this.request = request;
        this.args = args;
    }

    public RuntimeNode(UnaryNode parent, Request request) {
        this((Node)parent, request, parent.rhs());
    }

    public RuntimeNode(BinaryNode parent, Request request) {
        this((Node)parent, request, parent.lhs(), parent.rhs());
    }

    private RuntimeNode(RuntimeNode runtimeNode, Node.CopyState cs) {
        super(runtimeNode);
        ArrayList<Node> newArgs = new ArrayList<Node>();
        for (Node arg : runtimeNode.args) {
            newArgs.add(cs.existingOrCopy(arg));
        }
        this.request = runtimeNode.request;
        this.args = newArgs;
        this.callSiteType = runtimeNode.callSiteType;
    }

    public boolean isFinal() {
        return this.isFinal;
    }

    public void setIsFinal() {
        this.isFinal = true;
    }

    @Override
    protected Node copy(Node.CopyState cs) {
        return new RuntimeNode(this, cs);
    }

    @Override
    public Type getType() {
        return this.hasCallSiteType() ? this.callSiteType : this.request.getReturnType();
    }

    @Override
    public void setType(Type type) {
        this.callSiteType = type;
    }

    @Override
    public boolean canHaveCallSiteType() {
        return this.request == Request.ADD;
    }

    private boolean hasCallSiteType() {
        return this.callSiteType != null;
    }

    @Override
    public Node accept(NodeVisitor visitor) {
        if (visitor.enter(this) != null) {
            int count = this.args.size();
            for (int i = 0; i < count; ++i) {
                this.args.set(i, this.args.get(i).accept(visitor));
            }
            return visitor.leave(this);
        }
        return this;
    }

    @Override
    public void toString(StringBuilder sb) {
        sb.append("ScriptRuntime.");
        sb.append((Object)this.request);
        sb.append('(');
        boolean first = true;
        for (Node arg : this.args) {
            if (!first) {
                sb.append(", ");
            } else {
                first = false;
            }
            arg.toString(sb);
        }
        sb.append(')');
    }

    public List<Node> getArgs() {
        return Collections.unmodifiableList(this.args);
    }

    public Request getRequest() {
        return this.request;
    }

    public boolean isPrimitive() {
        for (Node arg : this.args) {
            if (!arg.getType().isObject()) continue;
            return false;
        }
        return true;
    }

    public static enum Request {
        ADD(TokenType.ADD, Type.OBJECT, 2, true),
        DEBUGGER,
        NEW,
        TYPEOF,
        VOID,
        REFERENCE_ERROR,
        DELETE(TokenType.DELETE, Type.BOOLEAN, 1),
        FAIL_DELETE(TokenType.DELETE, Type.BOOLEAN, 1, false),
        EQ_STRICT(TokenType.EQ_STRICT, Type.BOOLEAN, 2, true),
        EQ(TokenType.EQ, Type.BOOLEAN, 2, true),
        GE(TokenType.GE, Type.BOOLEAN, 2, true),
        GT(TokenType.GT, Type.BOOLEAN, 2, true),
        IN(TokenType.IN, Type.BOOLEAN, 2),
        INSTANCEOF(TokenType.INSTANCEOF, Type.BOOLEAN, 2),
        LE(TokenType.LE, Type.BOOLEAN, 2, true),
        LT(TokenType.LT, Type.BOOLEAN, 2, true),
        NE_STRICT(TokenType.NE_STRICT, Type.BOOLEAN, 2, true),
        NE(TokenType.NE, Type.BOOLEAN, 2, true);

        private final TokenType tokenType;
        private final Type returnType;
        private final int arity;
        private final boolean canSpecialize;

        private Request() {
            this(TokenType.VOID, Type.OBJECT, 0);
        }

        private Request(TokenType tokenType, Type returnType, int arity) {
            this(tokenType, returnType, arity, false);
        }

        private Request(TokenType tokenType, Type returnType, int arity, boolean canSpecialize) {
            this.tokenType = tokenType;
            this.returnType = returnType;
            this.arity = arity;
            this.canSpecialize = canSpecialize;
        }

        public boolean canSpecialize() {
            return this.canSpecialize;
        }

        public int getArity() {
            return this.arity;
        }

        public Type getReturnType() {
            return this.returnType;
        }

        public TokenType getTokenType() {
            return this.tokenType;
        }

        public static boolean isEQ(Request request) {
            return request == EQ || request == EQ_STRICT;
        }

        public static boolean isNE(Request request) {
            return request == NE || request == NE_STRICT;
        }

        public static Request reverse(Request request) {
            switch (request) {
                case EQ: 
                case EQ_STRICT: 
                case NE: 
                case NE_STRICT: {
                    return request;
                }
                case LE: {
                    return GE;
                }
                case LT: {
                    return GT;
                }
                case GE: {
                    return LE;
                }
                case GT: {
                    return LT;
                }
            }
            return null;
        }

        public static Request invert(Request request) {
            switch (request) {
                case EQ: {
                    return NE;
                }
                case EQ_STRICT: {
                    return NE_STRICT;
                }
                case NE: {
                    return EQ;
                }
                case NE_STRICT: {
                    return EQ_STRICT;
                }
                case LE: {
                    return GT;
                }
                case LT: {
                    return GE;
                }
                case GE: {
                    return LT;
                }
                case GT: {
                    return LE;
                }
            }
            return null;
        }

        public static boolean isComparison(Request request) {
            switch (request) {
                case EQ: 
                case EQ_STRICT: 
                case NE: 
                case NE_STRICT: 
                case LE: 
                case LT: 
                case GE: 
                case GT: {
                    return true;
                }
            }
            return false;
        }
    }
}

