/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.ir;

import jdk.nashorn.internal.ir.FunctionNode;
import jdk.nashorn.internal.ir.Node;
import jdk.nashorn.internal.ir.PropertyKey;
import jdk.nashorn.internal.ir.annotations.Reference;
import jdk.nashorn.internal.ir.visitor.NodeVisitor;
import jdk.nashorn.internal.runtime.Source;

public class PropertyNode
extends Node {
    private PropertyKey key;
    private Node value;
    @Reference
    private Node getter;
    @Reference
    private Node setter;

    public PropertyNode(Source source, long token, int finish, PropertyKey key, Node value) {
        super(source, token, finish);
        this.key = key;
        this.value = value;
    }

    private PropertyNode(PropertyNode propertyNode, Node.CopyState cs) {
        super(propertyNode);
        this.key = (PropertyKey)((Object)cs.existingOrCopy((Node)((Object)propertyNode.key)));
        this.value = cs.existingOrCopy(propertyNode.value);
        this.getter = cs.existingOrSame(propertyNode.getter);
        this.setter = cs.existingOrSame(propertyNode.setter);
    }

    @Override
    protected Node copy(Node.CopyState cs) {
        return new PropertyNode(this, cs);
    }

    public String getKeyName() {
        return this.key.getPropertyName();
    }

    @Override
    public Node accept(NodeVisitor visitor) {
        if (visitor.enter(this) != null) {
            this.key = (PropertyKey)((Object)((Node)((Object)this.key)).accept(visitor));
            if (this.value != null) {
                this.value = this.value.accept(visitor);
            }
            if (this.getter != null) {
                this.getter = this.getter.accept(visitor);
            }
            if (this.setter != null) {
                this.setter = this.setter.accept(visitor);
            }
            return visitor.leave(this);
        }
        return this;
    }

    @Override
    public void toString(StringBuilder sb) {
        if (this.value instanceof FunctionNode && ((FunctionNode)this.value).getIdent() != null) {
            this.value.toString(sb);
        }
        if (this.value != null) {
            ((Node)((Object)this.key)).toString(sb);
            sb.append(": ");
            this.value.toString(sb);
        }
        if (this.getter != null) {
            sb.append(' ');
            this.getter.toString(sb);
        }
        if (this.setter != null) {
            sb.append(' ');
            this.setter.toString(sb);
        }
    }

    public Node getGetter() {
        return this.getter;
    }

    public void setGetter(Node getter) {
        this.getter = getter;
    }

    public Node getKey() {
        return (Node)((Object)this.key);
    }

    public Node getSetter() {
        return this.setter;
    }

    public void setSetter(Node setter) {
        this.setter = setter;
    }

    public Node getValue() {
        return this.value;
    }

    public void setValue(Node value) {
        this.value = value;
    }
}

