/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.ir;

import jdk.nashorn.internal.codegen.CompilerConstants;
import jdk.nashorn.internal.codegen.objects.ObjectClassGenerator;
import jdk.nashorn.internal.codegen.types.Type;
import jdk.nashorn.internal.ir.FunctionCall;
import jdk.nashorn.internal.ir.Node;
import jdk.nashorn.internal.ir.PropertyKey;
import jdk.nashorn.internal.ir.TypeOverride;
import jdk.nashorn.internal.ir.visitor.NodeVisitor;
import jdk.nashorn.internal.runtime.Source;

public class IdentNode
extends Node
implements PropertyKey,
TypeOverride,
FunctionCall {
    private final String name;
    private Type callSiteType;
    private boolean isPropertyName;
    private boolean isInitializedHere;

    public IdentNode(Source source, long token, int finish, String name) {
        super(source, token, finish);
        this.name = name;
    }

    public IdentNode(IdentNode identNode) {
        super(identNode);
        this.name = identNode.getName();
        this.isPropertyName = identNode.isPropertyName;
        this.isInitializedHere = identNode.isInitializedHere;
    }

    @Override
    public Type getType() {
        return this.callSiteType == null ? super.getType() : this.callSiteType;
    }

    @Override
    public boolean isAtom() {
        return true;
    }

    private boolean hasCallSiteType() {
        return this.callSiteType != null;
    }

    @Override
    public void setType(Type type) {
        if (ObjectClassGenerator.DEBUG_FIELDS && this.getSymbol() != null && !Type.areEquivalent(this.getSymbol().getSymbolType(), type)) {
            ObjectClassGenerator.LOG.info(this.getClass().getName() + " " + this + " => " + type + " instead of " + this.getType());
        }
        this.callSiteType = type;
    }

    @Override
    protected Node copy(Node.CopyState cs) {
        return new IdentNode(this);
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof IdentNode) {
            return this.name.equals(((IdentNode)other).name);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.name.hashCode();
    }

    @Override
    public Node accept(NodeVisitor visitor) {
        if (visitor.enter(this) != null) {
            return visitor.leave(this);
        }
        return this;
    }

    @Override
    public void toString(StringBuilder sb) {
        if (this.hasCallSiteType()) {
            sb.append('{');
            String desc = this.getType().getDescriptor();
            sb.append(desc.charAt(desc.length() - 1) == ';' ? "O" : this.getType().getDescriptor());
            sb.append('}');
        }
        sb.append(this.name);
    }

    public String getName() {
        return this.name;
    }

    @Override
    public String getPropertyName() {
        return this.getName();
    }

    @Override
    public boolean canHaveCallSiteType() {
        return this.getSymbol() != null && this.getSymbol().isScope();
    }

    public boolean isPropertyName() {
        return this.isPropertyName;
    }

    public void setIsPropertyName() {
        this.isPropertyName = true;
    }

    public boolean isInitializedHere() {
        return this.isInitializedHere;
    }

    public void setIsInitializedHere() {
        this.isInitializedHere = true;
    }

    public boolean isSpecialIdentity() {
        return this.name.equals(CompilerConstants.__DIR__.tag()) || this.name.equals(CompilerConstants.__FILE__.tag()) || this.name.equals(CompilerConstants.__LINE__.tag());
    }

    @Override
    public boolean isFunction() {
        return false;
    }
}

