/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.ir;

import jdk.nashorn.internal.ir.Block;
import jdk.nashorn.internal.ir.Node;
import jdk.nashorn.internal.ir.Symbol;
import jdk.nashorn.internal.ir.WhileNode;
import jdk.nashorn.internal.ir.visitor.NodeVisitor;
import jdk.nashorn.internal.runtime.Source;

public class ForNode
extends WhileNode {
    private Node init;
    private Node modify;
    private Symbol iterator;
    private boolean isForIn;
    private boolean isForEach;

    public ForNode(Source source, long token, int finish) {
        super(source, token, finish);
    }

    private ForNode(ForNode forNode, Node.CopyState cs) {
        super(forNode, cs);
        this.init = cs.existingOrCopy(forNode.init);
        this.modify = cs.existingOrCopy(forNode.modify);
        this.iterator = forNode.iterator;
        this.isForIn = forNode.isForIn;
        this.isForEach = forNode.isForEach;
    }

    @Override
    protected Node copy(Node.CopyState cs) {
        return new ForNode(this, cs);
    }

    @Override
    public Node accept(NodeVisitor visitor) {
        if (visitor.enter(this) != null) {
            if (this.init != null) {
                this.init = this.init.accept(visitor);
            }
            if (this.test != null) {
                this.test = this.test.accept(visitor);
            }
            if (this.modify != null) {
                this.modify = this.modify.accept(visitor);
            }
            this.body = (Block)this.body.accept(visitor);
            return visitor.leave(this);
        }
        return this;
    }

    @Override
    public void toString(StringBuilder sb) {
        sb.append("for (");
        if (this.isForIn()) {
            this.init.toString(sb);
            sb.append(" in ");
            this.modify.toString(sb);
        } else {
            if (this.init != null) {
                this.init.toString(sb);
            }
            sb.append("; ");
            if (this.test != null) {
                this.test.toString(sb);
            }
            sb.append("; ");
            if (this.modify != null) {
                this.modify.toString(sb);
            }
        }
        sb.append(')');
    }

    public Node getInit() {
        return this.init;
    }

    public void setInit(Node init) {
        this.init = init;
    }

    public boolean isForIn() {
        return this.isForIn;
    }

    public void setIsForIn() {
        this.isForIn = true;
    }

    public boolean isForEach() {
        return this.isForEach;
    }

    public void setIsForEach() {
        this.isForEach = true;
    }

    public Symbol getIterator() {
        return this.iterator;
    }

    public void setIterator(Symbol iterator) {
        this.iterator = iterator;
    }

    public Node getModify() {
        return this.modify;
    }

    public void setModify(Node modify) {
        this.modify = modify;
    }

    @Override
    public Node getTest() {
        return this.test;
    }

    @Override
    public void setTest(Node test) {
        this.test = test;
    }
}

