/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.ir;

import jdk.nashorn.internal.ir.Block;
import jdk.nashorn.internal.ir.IdentNode;
import jdk.nashorn.internal.ir.Node;
import jdk.nashorn.internal.ir.visitor.NodeVisitor;
import jdk.nashorn.internal.runtime.Source;

public class CatchNode
extends Node {
    private IdentNode exception;
    private Node exceptionCondition;
    private Block body;
    private boolean isSyntheticRethrow;

    public CatchNode(Source source, long token, int finish, IdentNode exception, Node exceptionCondition, Block body) {
        super(source, token, finish);
        this.exception = exception;
        this.exceptionCondition = exceptionCondition;
        this.body = body;
    }

    private CatchNode(CatchNode catchNode, Node.CopyState cs) {
        super(catchNode);
        this.exception = (IdentNode)cs.existingOrCopy(catchNode.exception);
        this.exceptionCondition = cs.existingOrCopy(catchNode.exceptionCondition);
        this.body = (Block)cs.existingOrCopy(catchNode.body);
        this.isSyntheticRethrow = catchNode.isSyntheticRethrow;
    }

    @Override
    protected Node copy(Node.CopyState cs) {
        return new CatchNode(this, cs);
    }

    @Override
    public Node accept(NodeVisitor visitor) {
        if (visitor.enter(this) != null) {
            this.exception = (IdentNode)this.exception.accept(visitor);
            if (this.exceptionCondition != null) {
                this.exceptionCondition = this.exceptionCondition.accept(visitor);
            }
            this.body = (Block)this.body.accept(visitor);
            return visitor.leave(this);
        }
        return this;
    }

    @Override
    public void toString(StringBuilder sb) {
        sb.append(" catch (");
        this.exception.toString(sb);
        if (this.exceptionCondition != null) {
            sb.append(" if ");
            this.exceptionCondition.toString(sb);
        }
        sb.append(')');
    }

    public boolean isSyntheticRethrow() {
        return this.isSyntheticRethrow;
    }

    public void setIsSyntheticRethrow() {
        this.isSyntheticRethrow = true;
    }

    public IdentNode getException() {
        return this.exception;
    }

    public Node getExceptionCondition() {
        return this.exceptionCondition;
    }

    public void setExceptionCondition(Node exceptionCondition) {
        this.exceptionCondition = exceptionCondition;
    }

    public Block getBody() {
        return this.body;
    }
}

