/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.ir;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import jdk.nashorn.internal.codegen.Frame;
import jdk.nashorn.internal.codegen.MethodEmitter;
import jdk.nashorn.internal.ir.CatchNode;
import jdk.nashorn.internal.ir.FunctionNode;
import jdk.nashorn.internal.ir.Node;
import jdk.nashorn.internal.ir.Symbol;
import jdk.nashorn.internal.ir.annotations.Ignore;
import jdk.nashorn.internal.ir.annotations.ParentNode;
import jdk.nashorn.internal.ir.visitor.NodeVisitor;
import jdk.nashorn.internal.runtime.Source;

public class Block
extends Node {
    @ParentNode
    @Ignore
    private Block parent;
    @Ignore
    protected FunctionNode function;
    protected List<Node> statements;
    protected final HashMap<String, Symbol> symbols;
    protected Frame frame;
    protected final MethodEmitter.Label entryLabel;
    protected final MethodEmitter.Label breakLabel;
    protected boolean needsScope;

    public Block(Source source, long token, int finish, Block parent, FunctionNode function) {
        super(source, token, finish);
        this.parent = parent;
        this.function = function;
        this.statements = new ArrayList<Node>();
        this.symbols = new HashMap();
        this.frame = null;
        this.entryLabel = new MethodEmitter.Label("block_entry");
        this.breakLabel = new MethodEmitter.Label("block_break");
    }

    protected Block(Block block, Node.CopyState cs) {
        super(block);
        this.parent = block.parent;
        this.function = block.function;
        this.statements = new ArrayList<Node>();
        for (Node statement : block.getStatements()) {
            this.statements.add(cs.existingOrCopy(statement));
        }
        this.symbols = new HashMap();
        this.frame = block.frame == null ? null : block.frame.copy();
        this.entryLabel = new MethodEmitter.Label(block.entryLabel);
        this.breakLabel = new MethodEmitter.Label(block.breakLabel);
        assert (block.symbols.isEmpty()) : "must not clone with symbols";
    }

    @Override
    protected Node copy(Node.CopyState cs) {
        return Block.fixBlockChain(new Block(this, cs));
    }

    static Block fixBlockChain(final Block root) {
        root.accept(new NodeVisitor(){
            private Block parent;
            private final FunctionNode function;
            {
                this.parent = root.getParent();
                this.function = root.getFunction();
            }

            @Override
            public Node enter(Block block) {
                assert (block.getFunction() == this.function);
                block.setParent(this.parent);
                this.parent = block;
                return block;
            }

            @Override
            public Node leave(Block block) {
                this.parent = block.getParent();
                return block;
            }

            @Override
            public Node enter(FunctionNode functionNode) {
                assert (functionNode.getFunction() == this.function);
                return this.enter((Block)functionNode);
            }

            @Override
            public Node leave(FunctionNode functionNode) {
                assert (functionNode.getFunction() == this.function);
                return this.leave((Block)functionNode);
            }
        });
        return root;
    }

    public void addStatement(Node statement) {
        if (statement != null) {
            this.statements.add(statement);
            if (this.getFinish() < statement.getFinish()) {
                this.setFinish(statement.getFinish());
            }
        }
    }

    public void prependStatement(Node statement) {
        if (statement != null) {
            ArrayList<Node> newStatements = new ArrayList<Node>();
            newStatements.add(statement);
            newStatements.addAll(this.statements);
            this.setStatements(newStatements);
        }
    }

    public void addStatements(List<Node> statementList) {
        this.statements.addAll(statementList);
    }

    public void addFunction(FunctionNode functionNode) {
        assert (this.parent != null) : "Parent context missing.";
        this.parent.addFunction(functionNode);
    }

    public void addFunctions(List<FunctionNode> functionNodes) {
        assert (this.parent != null) : "Parent context missing.";
        this.parent.addFunctions(functionNodes);
    }

    public void setFunctions(List<FunctionNode> functionNodes) {
        assert (this.parent != null) : "Parent context missing.";
        this.parent.setFunctions(functionNodes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Node accept(NodeVisitor visitor) {
        Block saveBlock = visitor.getCurrentBlock();
        visitor.setCurrentBlock(this);
        try {
            if (visitor.enter(this) != null) {
                int count = this.statements.size();
                for (int i = 0; i < count; ++i) {
                    Node statement = this.statements.get(i);
                    this.statements.set(i, statement.accept(visitor));
                }
                Node node = visitor.leave(this);
                return node;
            }
        }
        finally {
            visitor.setCurrentBlock(saveBlock);
        }
        return this;
    }

    public Symbol findSymbol(String name) {
        for (Block block = this; block != null; block = block.getParent()) {
            Symbol symbol = block.symbols.get(name);
            if (symbol == null) continue;
            return symbol;
        }
        return null;
    }

    public Symbol findLocalSymbol(String name) {
        for (Block block = this; block != null; block = block.getParent()) {
            Symbol symbol = block.symbols.get(name);
            if (symbol != null) {
                return symbol;
            }
            if (block == block.function) break;
        }
        return null;
    }

    public boolean isCatchBlock() {
        return this.statements.size() == 1 && this.statements.get(0) instanceof CatchNode;
    }

    public boolean isLocal(Symbol symbol) {
        Block block = symbol.getBlock();
        return block == null || block.getFunction() == this.function;
    }

    public Symbol defineSymbol(String name, int symbolFlags, Node node) {
        int flags = symbolFlags;
        Symbol symbol = this.findSymbol(name);
        if ((flags & 0xF) == 2) {
            flags |= 0x10;
        }
        if (symbol != null) {
            if ((flags & 0xF) == 4) {
                if (!this.function.isLocal(symbol)) {
                    symbol = null;
                } else if (symbol.isParam()) {
                    assert (false) : "duplicate parameter";
                    return null;
                }
            } else if ((flags & 0xF) == 3) {
                if ((flags & 0x200) == 512 || (flags & 0x100) == 256) {
                    assert ((flags & 0x100) != 256 || symbol.getBlock() != this) : "duplicate let variable in block";
                    symbol = null;
                } else if (!this.function.isLocal(symbol) || symbol.less(3)) {
                    symbol = null;
                }
            }
        }
        if (symbol == null) {
            Block symbolBlock = (flags & 0xF) == 3 && ((flags & 0x200) == 512 || (flags & 0x100) == 256) ? this : this.getFunction();
            symbol = new Symbol(name, flags, node, symbolBlock);
            symbolBlock.putSymbol(name, symbol);
            if ((flags & 0xF) != 2) {
                symbolBlock.getFrame().addSymbol(symbol);
                symbol.setNeedsSlot(true);
            }
        } else if (symbol.less(flags)) {
            symbol.setFlags(flags);
        }
        if (node != null) {
            node.setSymbol(symbol);
        }
        return symbol;
    }

    public Symbol useSymbol(String name, Node node) {
        Symbol symbol = this.findSymbol(name);
        if (symbol == null) {
            symbol = this.defineSymbol(name, 2, node);
        } else {
            node.setSymbol(symbol);
        }
        return symbol;
    }

    public void addParentName(StringBuilder sb) {
        if (this.parent != null) {
            this.parent.addParentName(sb);
        }
    }

    @Override
    public void toString(StringBuilder sb) {
        for (Node statement : this.statements) {
            statement.toString(sb);
            sb.append(';');
        }
    }

    public boolean printSymbols(PrintWriter stream) {
        ArrayList<Symbol> values = new ArrayList<Symbol>(this.symbols.values());
        Collections.sort(values, new Comparator<Symbol>(){

            @Override
            public int compare(Symbol s0, Symbol s1) {
                return s0.getName().compareTo(s1.getName());
            }
        });
        for (Symbol symbol : values) {
            symbol.print(stream);
        }
        return !values.isEmpty();
    }

    public MethodEmitter.Label getBreakLabel() {
        return this.breakLabel;
    }

    public MethodEmitter.Label getEntryLabel() {
        return this.entryLabel;
    }

    public Frame getFrame() {
        return this.frame;
    }

    public FunctionNode getFunction() {
        return this.function;
    }

    public void setFrame(Frame frame) {
        this.frame = frame;
    }

    public Block getParent() {
        return this.parent;
    }

    public void setParent(Block parent) {
        this.parent = parent;
    }

    public List<Node> getStatements() {
        return Collections.unmodifiableList(this.statements);
    }

    public void setStatements(List<Node> statements) {
        this.statements = statements;
    }

    public void putSymbol(String name, Symbol symbol) {
        this.symbols.put(name, symbol);
    }

    public boolean needsScope() {
        return this.needsScope;
    }

    public void setNeedsScope() {
        this.needsScope = true;
    }
}

