/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript2.editor.model.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.netbeans.modules.csl.api.Modifier;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.javascript2.editor.doc.spi.JsDocumentationHolder;
import org.netbeans.modules.javascript2.editor.model.Identifier;
import org.netbeans.modules.javascript2.editor.model.JsArray;
import org.netbeans.modules.javascript2.editor.model.JsObject;
import org.netbeans.modules.javascript2.editor.model.TypeUsage;
import org.netbeans.modules.javascript2.editor.model.impl.JsObjectImpl;
import org.netbeans.modules.javascript2.editor.model.impl.ModelUtils;
import org.netbeans.modules.javascript2.editor.model.impl.TypeUsageImpl;

public class JsArrayImpl
extends JsObjectImpl
implements JsArray {
    private List<TypeUsage> typesInArray = new ArrayList<TypeUsage>();

    public JsArrayImpl(JsObject parent, Identifier name, OffsetRange offsetRange, String mimeType, String sourceLabel) {
        super(parent, name, offsetRange, mimeType, sourceLabel);
    }

    public JsArrayImpl(JsObject parent, String name, boolean isDeclared, OffsetRange offsetRange, Set<Modifier> modifiers, String mimeType, String sourceLabel) {
        super(parent, name, isDeclared, offsetRange, modifiers, mimeType, sourceLabel);
    }

    public JsArrayImpl(JsObject parent, Identifier name, OffsetRange offsetRange, boolean isDeclared, Set<Modifier> modifiers, String mimeType, String sourceLabel) {
        super(parent, name, offsetRange, isDeclared, modifiers, mimeType, sourceLabel);
    }

    @Override
    public Collection<? extends TypeUsage> getTypesInArray() {
        ArrayList<TypeUsage> values = new ArrayList<TypeUsage>();
        for (TypeUsage type : this.typesInArray) {
            values.add(type);
        }
        return Collections.unmodifiableCollection(values);
    }

    public void addTypeInArray(TypeUsage type) {
        boolean isHere = false;
        for (TypeUsage typeUsage : this.typesInArray) {
            if (!typeUsage.getType().equals(type.getType())) continue;
            isHere = true;
            break;
        }
        if (!isHere) {
            this.typesInArray.add(type);
        }
    }

    public void addTypesInArray(Collection<TypeUsage> types) {
        for (TypeUsage type : types) {
            this.addTypeInArray(type);
        }
    }

    @Override
    public void resolveTypes(JsDocumentationHolder jsDocHolder) {
        super.resolveTypes(jsDocHolder);
        HashSet<String> nameTypesInArray = new HashSet<String>();
        ArrayList<TypeUsage> resolved = new ArrayList<TypeUsage>();
        Collection<? extends TypeUsage> typesIA = this.getTypesInArray();
        for (TypeUsage typeUsage : typesIA) {
            if (typeUsage.getType().equals("unresolved") && typesIA.size() > 1) continue;
            if (!typeUsage.isResolved()) {
                for (TypeUsage rType : ModelUtils.resolveTypeFromSemiType(this, typeUsage)) {
                    if (nameTypesInArray.contains(rType.getType())) continue;
                    if ("@this;".equals(typeUsage.getType())) {
                        rType = new TypeUsageImpl(rType.getType(), -1, rType.isResolved());
                    }
                    resolved.add(rType);
                    nameTypesInArray.add(rType.getType());
                }
                continue;
            }
            if (nameTypesInArray.contains(typeUsage.getType())) continue;
            resolved.add(typeUsage);
            nameTypesInArray.add(typeUsage.getType());
        }
        for (TypeUsage typeUsage : resolved) {
            if (typeUsage.getOffset() <= 0) continue;
            JsObject jsObject = ModelUtils.findJsObjectByName(this, typeUsage.getType());
            if (jsObject == null) {
                JsObject global = ModelUtils.getGlobalObject(this);
                jsObject = ModelUtils.findJsObjectByName(global, typeUsage.getType());
            }
            if (jsObject == null) continue;
            int index = typeUsage.getType().lastIndexOf(46);
            int typeLength = index > -1 ? typeUsage.getType().length() - index - 1 : typeUsage.getType().length();
            ((JsObjectImpl)jsObject).addOccurrence(new OffsetRange(typeUsage.getOffset(), typeUsage.getOffset() + typeLength));
        }
        this.typesInArray.clear();
        this.typesInArray.addAll(resolved);
    }
}

