/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript2.editor.hints;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.javascript2.editor.api.lexer.JsTokenId;
import org.netbeans.modules.javascript2.editor.api.lexer.LexUtilities;
import org.netbeans.modules.javascript2.editor.model.Identifier;
import org.netbeans.modules.javascript2.editor.model.impl.IdentifierImpl;
import org.netbeans.modules.parsing.api.Snapshot;

public class JSHintSupport {
    private static String GLOBAL_DIRECTIVE = "global";

    public static Collection<Identifier> getDefinedGlobal(Snapshot snapshot, int offset) {
        ArrayList<Identifier> names = new ArrayList<Identifier>();
        List<JsTokenId> findToken = Arrays.asList(JsTokenId.BLOCK_COMMENT);
        TokenSequence<? extends JsTokenId> ts = LexUtilities.getJsTokenSequence(snapshot, offset);
        if (ts == null) {
            return names;
        }
        ts.move(0);
        Token<? extends JsTokenId> token = LexUtilities.findNextIncluding(ts, findToken);
        while (token != null && token.id() == JsTokenId.BLOCK_COMMENT) {
            int iOffset = ts.offset();
            String text = token.text().toString();
            text = text.substring(2);
            iOffset += 2;
            while (!text.isEmpty() && text.charAt(0) == ' ') {
                text = text.substring(1);
                ++iOffset;
            }
            if (text.startsWith(GLOBAL_DIRECTIVE) && text.length() > GLOBAL_DIRECTIVE.length() && text.charAt(GLOBAL_DIRECTIVE.length()) == ' ') {
                String[] parts;
                text = text.substring(GLOBAL_DIRECTIVE.length() + 1);
                iOffset = iOffset + GLOBAL_DIRECTIVE.length() + 1;
                String[] arr$ = parts = text.split(",");
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$; ++i$) {
                    String part;
                    String name = part = arr$[i$];
                    int nameOffset = iOffset;
                    while (!name.isEmpty() && name.charAt(0) == ' ') {
                        name = name.substring(1);
                        ++nameOffset;
                    }
                    name.trim();
                    if (name.indexOf(42) > 0) {
                        name = name.substring(0, name.indexOf(42)).trim();
                    }
                    if (name.indexOf(58) > 0) {
                        name = name.substring(0, name.indexOf(58)).trim();
                    }
                    if (!name.isEmpty()) {
                        names.add(new IdentifierImpl(name, new OffsetRange(nameOffset, nameOffset + name.length())));
                    }
                    iOffset = iOffset + part.length() + 1;
                }
            }
            if (!ts.moveNext()) break;
            token = LexUtilities.findNextIncluding(ts, findToken);
        }
        return names;
    }

    public static void addGlobalInline(Snapshot snapshot, int offset, String name) throws BadLocationException {
        Document document = snapshot.getSource().getDocument(false);
        if (document != null) {
            Collection<Identifier> definedGlobal = JSHintSupport.getDefinedGlobal(snapshot, 0);
            Identifier lastOne = null;
            for (Identifier iden : definedGlobal) {
                if (lastOne != null && lastOne.getOffsetRange().getEnd() >= iden.getOffsetRange().getEnd()) continue;
                lastOne = iden;
            }
            int insertWhere = -1;
            String insertText = null;
            if (lastOne != null) {
                insertWhere = lastOne.getOffsetRange().getEnd();
                insertText = ", " + name;
            } else {
                TokenSequence<? extends JsTokenId> ts = LexUtilities.getJsTokenSequence(snapshot, offset);
                if (ts != null) {
                    Token<? extends JsTokenId> token;
                    ts.move(0);
                    if (ts.moveNext() && (token = LexUtilities.findNext(ts, Arrays.asList(JsTokenId.BLOCK_COMMENT, JsTokenId.WHITESPACE, JsTokenId.EOL))) != null) {
                        insertWhere = ts.offset();
                        StringBuilder sb = new StringBuilder();
                        sb.append("/* ").append(GLOBAL_DIRECTIVE).append(" ").append(name).append(" */\n\n");
                        insertText = sb.toString();
                    }
                }
            }
            if (insertWhere > -1) {
                document.insertString(insertWhere, insertText, null);
            }
        }
    }
}

