/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript2.editor.hints;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.HintFix;
import org.netbeans.modules.csl.api.HintSeverity;
import org.netbeans.modules.csl.api.HintsProvider;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.Rule;
import org.netbeans.modules.javascript2.editor.hints.Bundle;
import org.netbeans.modules.javascript2.editor.hints.JSHintSupport;
import org.netbeans.modules.javascript2.editor.hints.JsAstRule;
import org.netbeans.modules.javascript2.editor.hints.JsHintsProvider;
import org.netbeans.modules.javascript2.editor.index.JsIndex;
import org.netbeans.modules.javascript2.editor.model.DeclarationScope;
import org.netbeans.modules.javascript2.editor.model.Identifier;
import org.netbeans.modules.javascript2.editor.model.JsElement;
import org.netbeans.modules.javascript2.editor.model.JsObject;
import org.netbeans.modules.javascript2.editor.model.Occurrence;
import org.netbeans.modules.javascript2.editor.model.impl.ModelUtils;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.spi.indexing.support.IndexResult;
import org.openide.filesystems.FileObject;

public class GlobalIsNotDefined
extends JsAstRule {
    private static final List<String> KNOWN_GLOBAL_OBJECTS = Arrays.asList("window", "document", "console", "clearInterval", "clearTimeout", "event", "frames", "history", "Image", "location", "name", "navigator", "Option", "parent", "screen", "setInterval", "setTimeout", "XMLHttpRequest", "JSON", "Date", "undefined", "Math", "$", "jQuery", "Array", "Object", "Boolean", "null", "Number", "RegExp", "String", "undefined", "unresolved");

    @Override
    void computeHints(JsHintsProvider.JsRuleContext context, List<Hint> hints, int offset, HintsProvider.HintsManager manager) throws BadLocationException {
        JsObject globalObject = context.getJsParserResult().getModel().getGlobalObject();
        Collection<? extends JsObject> variables = ModelUtils.getVariables((DeclarationScope)((Object)globalObject));
        FileObject fo = context.parserResult.getSnapshot().getSource().getFileObject();
        JsIndex jsIndex = JsIndex.get(fo);
        Collection<String> jsHintGlobalDefinition = this.findJsHintGlobalDefinition(context.getJsParserResult().getSnapshot());
        for (JsObject jsObject : variables) {
            if (jsObject.isDeclared() || KNOWN_GLOBAL_OBJECTS.contains(jsObject.getName()) || jsHintGlobalDefinition.contains(jsObject.getName()) || jsObject.getJSKind() != JsElement.Kind.VARIABLE && jsObject.getJSKind() != JsElement.Kind.OBJECT) continue;
            String varName = jsObject.getName();
            Collection<? extends IndexResult> findByFqn = jsIndex.findByFqn("window." + varName, "bn");
            if (!findByFqn.isEmpty()) continue;
            if (jsObject.getOccurrences().isEmpty()) {
                this.addHint(context, hints, offset, varName, jsObject.getOffsetRange());
                continue;
            }
            for (Occurrence occurrence : jsObject.getOccurrences()) {
                this.addHint(context, hints, offset, varName, occurrence.getOffsetRange());
            }
        }
    }

    private void addHint(JsHintsProvider.JsRuleContext context, List<Hint> hints, int offset, String name, OffsetRange range) throws BadLocationException {
        boolean add = false;
        if (offset > -1) {
            Document document = context.getJsParserResult().getSnapshot().getSource().getDocument(false);
            if (document != null && document instanceof BaseDocument) {
                int lineOffsetRange;
                BaseDocument baseDocument = (BaseDocument)document;
                int lineOffset = Utilities.getLineOffset((BaseDocument)baseDocument, (int)offset);
                add = lineOffset == (lineOffsetRange = Utilities.getLineOffset((BaseDocument)baseDocument, (int)range.getStart()));
            }
        } else {
            add = true;
        }
        if (add) {
            ArrayList<AddJsHintFix> fixes = new ArrayList<AddJsHintFix>();
            fixes.add(new AddJsHintFix(context.getJsParserResult().getSnapshot(), offset, name));
            hints.add(new Hint((Rule)this, Bundle.JsGlobalIsNotDefinedHintDesc(name), context.getJsParserResult().getSnapshot().getSource().getFileObject(), ModelUtils.documentOffsetRange(context.getJsParserResult(), range.getStart(), range.getEnd()), fixes, 500));
        }
    }

    public Set<?> getKinds() {
        return Collections.singleton("js.other.hints");
    }

    public String getId() {
        return "jsglobalisnotdefined.hint";
    }

    public String getDescription() {
        return Bundle.JsGlobalIsNotDefinedDesc();
    }

    public String getDisplayName() {
        return Bundle.JsGlobalIsNotDefinedDN();
    }

    @Override
    public HintSeverity getDefaultSeverity() {
        return HintSeverity.WARNING;
    }

    @Override
    public boolean getDefaultEnabled() {
        return true;
    }

    private Collection<String> findJsHintGlobalDefinition(Snapshot snapshot) {
        ArrayList<String> names = new ArrayList<String>();
        Collection<Identifier> definedGlobal = JSHintSupport.getDefinedGlobal(snapshot, 0);
        for (Identifier identifier : definedGlobal) {
            names.add(identifier.getName());
        }
        return names;
    }

    static class AddJsHintFix
    implements HintFix {
        private final Snapshot snapshot;
        private final String name;
        private int offset;

        public AddJsHintFix(Snapshot snapshot, int offset, String name) {
            this.snapshot = snapshot;
            this.name = name;
            this.offset = offset;
        }

        public String getDescription() {
            return Bundle.AddGlobalJsHint_Description();
        }

        public void implement() throws Exception {
            JSHintSupport.addGlobalInline(this.snapshot, this.offset, this.name);
        }

        public boolean isSafe() {
            return true;
        }

        public boolean isInteractive() {
            return false;
        }
    }
}

