/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript2.editor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.csl.api.ColoringAttributes;
import org.netbeans.modules.csl.api.Modifier;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.SemanticAnalyzer;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.javascript2.editor.api.lexer.JsTokenId;
import org.netbeans.modules.javascript2.editor.api.lexer.LexUtilities;
import org.netbeans.modules.javascript2.editor.doc.spi.JsComment;
import org.netbeans.modules.javascript2.editor.hints.JSHintSupport;
import org.netbeans.modules.javascript2.editor.model.Identifier;
import org.netbeans.modules.javascript2.editor.model.JsFunction;
import org.netbeans.modules.javascript2.editor.model.JsObject;
import org.netbeans.modules.javascript2.editor.model.Model;
import org.netbeans.modules.javascript2.editor.model.Occurrence;
import org.netbeans.modules.javascript2.editor.model.impl.JsObjectImpl;
import org.netbeans.modules.javascript2.editor.model.impl.JsObjectReference;
import org.netbeans.modules.javascript2.editor.model.impl.ModelUtils;
import org.netbeans.modules.javascript2.editor.parser.JsParserResult;
import org.netbeans.modules.parsing.spi.Scheduler;
import org.netbeans.modules.parsing.spi.SchedulerEvent;

public class JsSemanticAnalyzer
extends SemanticAnalyzer<JsParserResult> {
    public static final EnumSet<ColoringAttributes> UNUSED_OBJECT_SET = EnumSet.of(ColoringAttributes.UNUSED, ColoringAttributes.CLASS);
    public static final EnumSet<ColoringAttributes> UNUSED_METHOD_SET = EnumSet.of(ColoringAttributes.UNUSED, ColoringAttributes.METHOD);
    private boolean cancelled = false;
    private Map<OffsetRange, Set<ColoringAttributes>> semanticHighlights = null;
    private static final List<String> GLOBAL_TYPES = Arrays.asList("Array", "String", "Boolean", "Number", "undefined");
    private Collection<OffsetRange> globalJsHintInlines = new ArrayList<OffsetRange>();

    public Map<OffsetRange, Set<ColoringAttributes>> getHighlights() {
        return this.semanticHighlights;
    }

    public void run(JsParserResult result, SchedulerEvent event) {
        this.resume();
        if (this.isCancelled()) {
            return;
        }
        Map<OffsetRange, Set<ColoringAttributes>> highlights = new HashMap<OffsetRange, Set<ColoringAttributes>>(100);
        Model model = result.getModel();
        JsObject global = model.getGlobalObject();
        Collection<Identifier> definedGlobal = JSHintSupport.getDefinedGlobal(result.getSnapshot(), -1);
        for (Identifier iden : definedGlobal) {
            this.globalJsHintInlines.add(iden.getOffsetRange());
        }
        this.semanticHighlights = (highlights = this.count(result, global, highlights)) != null && highlights.size() > 0 ? highlights : null;
    }

    private Map<OffsetRange, Set<ColoringAttributes>> count(JsParserResult result, JsObject parent, Map<OffsetRange, Set<ColoringAttributes>> highlights) {
        for (JsObject jsObject : parent.getProperties().values()) {
            if (jsObject.getDeclarationName() != null) {
                switch (jsObject.getJSKind()) {
                    case CONSTRUCTOR: 
                    case METHOD: 
                    case FUNCTION: {
                        OffsetRange range;
                        if (jsObject.isDeclared() && !jsObject.isAnonymous() && !jsObject.getDeclarationName().getOffsetRange().isEmpty()) {
                            EnumSet<ColoringAttributes> coloring = ColoringAttributes.METHOD_SET;
                            if (jsObject.getModifiers().contains(Modifier.PRIVATE)) {
                                OffsetRange orOccurrence;
                                OffsetRange offsetRange;
                                if (jsObject.getOccurrences().isEmpty()) {
                                    coloring = UNUSED_METHOD_SET;
                                } else if (jsObject.getOccurrences().size() == 1 && (offsetRange = jsObject.getDeclarationName().getOffsetRange()).equals((Object)(orOccurrence = jsObject.getOccurrences().get(0).getOffsetRange()))) {
                                    coloring = UNUSED_METHOD_SET;
                                }
                            }
                            this.addColoring(result, highlights, jsObject.getDeclarationName().getOffsetRange(), coloring);
                        }
                        for (JsObject jsObject2 : ((JsFunction)jsObject).getParameters()) {
                            if (!(jsObject instanceof JsObjectReference) || ((JsObjectReference)jsObject).getOriginal().isAnonymous()) {
                                this.count(result, jsObject2, highlights);
                            }
                            if (this.hasSourceOccurences(result, jsObject2) || (range = LexUtilities.getLexerOffsets(result, jsObject2.getDeclarationName().getOffsetRange())).getStart() >= range.getEnd()) continue;
                            highlights.put(range, ColoringAttributes.UNUSED_SET);
                        }
                        break;
                    }
                    case PROPERTY_GETTER: 
                    case PROPERTY_SETTER: {
                        Token<? extends JsTokenId> token;
                        int offset = LexUtilities.getLexerOffset(result, jsObject.getDeclarationName().getOffsetRange().getStart());
                        TokenSequence<? extends JsTokenId> tokenSequence = LexUtilities.getJsTokenSequence(result.getSnapshot(), offset);
                        if (tokenSequence == null) break;
                        tokenSequence.move(offset);
                        if (tokenSequence.moveNext() && tokenSequence.movePrevious() && (token = LexUtilities.findPrevious(tokenSequence, Arrays.asList(JsTokenId.WHITESPACE, JsTokenId.BLOCK_COMMENT, JsTokenId.DOC_COMMENT))).id() == JsTokenId.IDENTIFIER && token.length() == 3) {
                            highlights.put(new OffsetRange(tokenSequence.offset(), tokenSequence.offset() + token.length()), ColoringAttributes.METHOD_SET);
                        }
                        highlights.put(LexUtilities.getLexerOffsets(result, jsObject.getDeclarationName().getOffsetRange()), ColoringAttributes.FIELD_SET);
                        break;
                    }
                    case OBJECT: 
                    case OBJECT_LITERAL: {
                        if ("UNKNOWN".equals(jsObject.getName())) break;
                        if (parent.getParent() == null && !GLOBAL_TYPES.contains(jsObject.getName())) {
                            this.addColoring(result, highlights, jsObject.getDeclarationName().getOffsetRange(), ColoringAttributes.GLOBAL_SET);
                            for (Occurrence occurence : jsObject.getOccurrences()) {
                                if (this.isCommentOccurence(result, occurence)) continue;
                                this.addColoring(result, highlights, occurence.getOffsetRange(), ColoringAttributes.GLOBAL_SET);
                            }
                        } else {
                            if (!jsObject.isDeclared() || "prototype".equals(jsObject.getName()) || jsObject.isAnonymous()) break;
                            if ((jsObject.getOccurrences().isEmpty() || jsObject.getOccurrences().size() == 1 && jsObject.getOccurrences().get(0).getOffsetRange().equals((Object)jsObject.getDeclarationName().getOffsetRange())) && jsObject.getModifiers().contains(Modifier.PRIVATE)) {
                                highlights.put(LexUtilities.getLexerOffsets(result, jsObject.getDeclarationName().getOffsetRange()), UNUSED_OBJECT_SET);
                                break;
                            }
                            highlights.put(LexUtilities.getLexerOffsets(result, jsObject.getDeclarationName().getOffsetRange()), ColoringAttributes.CLASS_SET);
                            TokenSequence<? extends JsTokenId> cts = LexUtilities.getJsTokenSequence(result.getSnapshot(), jsObject.getDeclarationName().getOffsetRange().getStart());
                            for (Occurrence occurrence : jsObject.getOccurrences()) {
                                cts.move(occurrence.getOffsetRange().getStart());
                                if (!cts.moveNext() || cts.token().id() != JsTokenId.STRING || occurrence.getOffsetRange().equals((Object)jsObject.getDeclarationName().getOffsetRange())) continue;
                                highlights.put(LexUtilities.getLexerOffsets(result, occurrence.getOffsetRange()), ColoringAttributes.CLASS_SET);
                            }
                        }
                        break;
                    }
                    case PROPERTY: {
                        if (!jsObject.isDeclared()) break;
                        highlights.put(LexUtilities.getLexerOffsets(result, jsObject.getDeclarationName().getOffsetRange()), ColoringAttributes.FIELD_SET);
                        for (Occurrence occurence : jsObject.getOccurrences()) {
                            if (this.isCommentOccurence(result, occurence)) continue;
                            highlights.put(LexUtilities.getLexerOffsets(result, occurence.getOffsetRange()), ColoringAttributes.FIELD_SET);
                        }
                        break;
                    }
                    case FIELD: {
                        highlights.put(jsObject.getDeclarationName().getOffsetRange(), ColoringAttributes.FIELD_SET);
                        for (Occurrence occurence : jsObject.getOccurrences()) {
                            if (this.isCommentOccurence(result, occurence)) continue;
                            highlights.put(LexUtilities.getLexerOffsets(result, occurence.getOffsetRange()), ColoringAttributes.FIELD_SET);
                        }
                        break;
                    }
                    case VARIABLE: {
                        OffsetRange range;
                        if (parent.getParent() == null && !GLOBAL_TYPES.contains(jsObject.getName())) {
                            highlights.put(LexUtilities.getLexerOffsets(result, jsObject.getDeclarationName().getOffsetRange()), ColoringAttributes.GLOBAL_SET);
                            for (Occurrence occurence : jsObject.getOccurrences()) {
                                if (this.isCommentOccurence(result, occurence)) continue;
                                highlights.put(LexUtilities.getLexerOffsets(result, occurence.getOffsetRange()), ColoringAttributes.GLOBAL_SET);
                            }
                        } else {
                            if ((jsObject.getOccurrences().isEmpty() || jsObject.getOccurrences().size() == 1 && jsObject.getOccurrences().get(0).getOffsetRange().equals((Object)jsObject.getDeclarationName().getOffsetRange())) && !GLOBAL_TYPES.contains(jsObject.getName())) {
                                range = jsObject.getDeclarationName().getOffsetRange();
                                if (range.getStart() >= range.getEnd()) break;
                                highlights.put(LexUtilities.getLexerOffsets(result, jsObject.getDeclarationName().getOffsetRange()), ColoringAttributes.UNUSED_SET);
                                break;
                            }
                            if (!(jsObject instanceof JsObjectImpl) || "arguments".equals(jsObject.getName()) || jsObject.getOccurrences().size() > ((JsObjectImpl)jsObject).getCountOfAssignments()) break;
                            if (jsObject.getDeclarationName().getOffsetRange().getLength() > 0) {
                                highlights.put(LexUtilities.getLexerOffsets(result, jsObject.getDeclarationName().getOffsetRange()), ColoringAttributes.UNUSED_SET);
                            }
                            for (Occurrence occurence : jsObject.getOccurrences()) {
                                if (occurence.getOffsetRange().getLength() <= 0) continue;
                                highlights.put(LexUtilities.getLexerOffsets(result, occurence.getOffsetRange()), ColoringAttributes.UNUSED_SET);
                            }
                        }
                        break;
                    }
                }
            }
            if (this.isCancelled()) {
                highlights = null;
                break;
            }
            if (jsObject instanceof JsObjectReference && ModelUtils.isDescendant(jsObject, ((JsObjectReference)jsObject).getOriginal())) continue;
            highlights = this.count(result, jsObject, highlights);
        }
        return highlights;
    }

    private void addColoring(ParserResult result, Map<OffsetRange, Set<ColoringAttributes>> highlights, OffsetRange astRange, Set<ColoringAttributes> coloring) {
        int start = result.getSnapshot().getOriginalOffset(astRange.getStart());
        int end = result.getSnapshot().getOriginalOffset(astRange.getEnd());
        if (start > -1 && end > -1 && start < end) {
            OffsetRange range = start == astRange.getStart() ? astRange : new OffsetRange(start, end);
            highlights.put(range, coloring);
        }
    }

    public int getPriority() {
        return 0;
    }

    public Class<? extends Scheduler> getSchedulerClass() {
        return Scheduler.EDITOR_SENSITIVE_TASK_SCHEDULER;
    }

    public synchronized void cancel() {
        this.cancelled = true;
    }

    protected final synchronized boolean isCancelled() {
        return this.cancelled;
    }

    protected final synchronized void resume() {
        this.cancelled = false;
    }

    private boolean hasSourceOccurences(JsParserResult result, JsObject param) {
        if (param.getOccurrences().isEmpty()) {
            return false;
        }
        if (param.getOccurrences().size() == 1 && param.getOccurrences().get(0).getOffsetRange().equals((Object)param.getDeclarationName().getOffsetRange())) {
            return false;
        }
        int sourceOccurenceCount = 0;
        for (Occurrence occurrence : param.getOccurrences()) {
            if (!this.isCommentOccurence(result, occurrence)) {
                ++sourceOccurenceCount;
            }
            if (sourceOccurenceCount <= 1) continue;
            return true;
        }
        return false;
    }

    private boolean isCommentOccurence(JsParserResult result, Occurrence occurence) {
        for (JsComment jsComment : result.getDocumentationHolder().getCommentBlocks().values()) {
            if (!jsComment.getOffsetRange().containsInclusive(occurence.getOffsetRange().getStart())) continue;
            return true;
        }
        return this.globalJsHintInlines.contains(occurence.getOffsetRange());
    }
}

