/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.browser.api;

import java.awt.Image;
import org.netbeans.modules.extbrowser.ExtWebBrowser;
import org.netbeans.modules.extbrowser.PrivateBrowserFamilyId;
import org.netbeans.modules.web.browser.api.BrowserFamilyId;
import org.netbeans.modules.web.browser.spi.BrowserURLMapperImplementation;
import org.netbeans.modules.web.browser.spi.BrowserURLMapperProvider;
import org.netbeans.modules.web.browser.spi.EnhancedBrowserFactory;
import org.openide.awt.HtmlBrowser;
import org.openide.loaders.DataObject;

final class WebBrowserFactoryDescriptor {
    private String id;
    private String name;
    private DataObject dob;
    private boolean def;
    private HtmlBrowser.Factory factory;
    private BrowserFamilyId browserFamily;
    private boolean hasNetBeansIntegration;

    public WebBrowserFactoryDescriptor(String id, DataObject dob, boolean def, HtmlBrowser.Factory factory) {
        this.id = id;
        this.dob = dob;
        this.def = def;
        this.factory = factory;
        if (factory instanceof EnhancedBrowserFactory) {
            this.browserFamily = ((EnhancedBrowserFactory)factory).getBrowserFamilyId();
            this.name = ((EnhancedBrowserFactory)factory).getDisplayName();
            this.hasNetBeansIntegration = ((EnhancedBrowserFactory)factory).hasNetBeansIntegration();
        } else if (factory instanceof ExtWebBrowser) {
            this.browserFamily = WebBrowserFactoryDescriptor.convertBrowserFamilyId(((ExtWebBrowser)factory).getPrivateBrowserFamilyId());
            this.hasNetBeansIntegration = false;
        } else {
            this.browserFamily = BrowserFamilyId.UNKNOWN;
            this.hasNetBeansIntegration = false;
        }
    }

    WebBrowserFactoryDescriptor(WebBrowserFactoryDescriptor delegate, String id, String name) {
        this(id, delegate.dob, delegate.def, delegate.factory);
        this.name = name;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        if (this.name == null) {
            this.name = this.dob.getNodeDelegate().getDisplayName();
        }
        return this.name;
    }

    public boolean isDefault() {
        return this.def;
    }

    void setDefault(boolean def) {
        this.def = def;
    }

    public boolean hasNetBeansIntegration() {
        return this.hasNetBeansIntegration;
    }

    public HtmlBrowser.Factory getFactory() {
        return this.factory;
    }

    public BrowserFamilyId getBrowserFamily() {
        return this.browserFamily;
    }

    public Image getIconImage(boolean small) {
        if (this.factory instanceof EnhancedBrowserFactory) {
            return ((EnhancedBrowserFactory)this.factory).getIconImage(small);
        }
        return null;
    }

    BrowserURLMapperImplementation getBrowserURLMapper() {
        if (this.factory instanceof BrowserURLMapperProvider) {
            return ((BrowserURLMapperProvider)this.factory).getBrowserURLMapper();
        }
        return null;
    }

    public String toString() {
        return "WebBrowserFactoryDescriptor{id=" + this.id + ", def=" + this.def + ", factory=" + this.factory + '}';
    }

    static BrowserFamilyId convertBrowserFamilyId(PrivateBrowserFamilyId privateBrowserFamilyId) {
        switch (privateBrowserFamilyId) {
            case FIREFOX: {
                return BrowserFamilyId.FIREFOX;
            }
            case MOZILLA: {
                return BrowserFamilyId.MOZILLA;
            }
            case CHROME: {
                return BrowserFamilyId.CHROME;
            }
            case CHROMIUM: {
                return BrowserFamilyId.CHROMIUM;
            }
            case SAFARI: {
                return BrowserFamilyId.SAFARI;
            }
            case IE: {
                return BrowserFamilyId.IE;
            }
            case OPERA: {
                return BrowserFamilyId.OPERA;
            }
        }
        return BrowserFamilyId.UNKNOWN;
    }
}

